/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment;

import icy.util.XMLUtil;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SpotsDescription {
    public int version = 1;
    public double volume = 5.0;
    public int pixels = 5;
    public String sourceName = null;
    public String old_boxID = new String("..");
    public String old_experiment = new String("..");
    public String old_comment1 = new String("..");
    public String old_comment2 = new String("..");
    public String old_strain = new String("..");
    public String old_sex = new String("..");
    public String old_cond1 = new String("..");
    public String old_cond2 = new String("..");
    public int grouping = 2;
    public String stimulusR = new String("..");
    public String concentrationR = new String("..");
    public String stimulusL = new String("..");
    public String concentrationL = new String("..");
    private static final String ID_SPOTTRACK = "spotTrack";
    private static final String ID_PARAMETERS = "Parameters";
    private static final String ID_FILE = "file";
    private static final String ID_ID = "ID";
    private static final String ID_DESCGROUPING = "Grouping";
    private static final String ID_DESCN = "n";
    private static final String ID_DESCCAPVOLUME = "capillaryVolume";
    private static final String ID_DESCVOLUMEUL = "volume_ul";
    private static final String ID_DESCCAPILLARYPIX = "capillaryPixels";
    private static final String ID_DESCNPIXELS = "npixels";
    private static final String ID_LRSTIMULUS = "LRstimulus";
    private static final String ID_STIMR = "stimR";
    private static final String ID_CONCR = "concR";
    private static final String ID_STIML = "stimL";
    private static final String ID_CONCL = "concL";
    private static final String ID_EXPERIMENT = "Experiment";
    private static final String ID_BOXID = "boxID";
    private static final String ID_EXPT = "expt";
    private static final String ID_COMMENT1 = "comment";
    private static final String ID_COMMENT2 = "comment2";
    private static final String ID_STRAIN = "strain";
    private static final String ID_SEX = "sex";
    private static final String ID_COND1 = "cond1";
    private static final String ID_COND2 = "cond2";
    private static final String ID_NOPE = "..";

    public void copy(SpotsDescription desc) {
        this.volume = desc.volume;
        this.pixels = desc.pixels;
        this.grouping = desc.grouping;
        this.stimulusR = desc.stimulusR;
        this.stimulusL = desc.stimulusL;
        this.concentrationR = desc.concentrationR;
        this.concentrationL = desc.concentrationL;
    }

    public boolean isChanged(SpotsDescription desc) {
        boolean flag = false;
        flag |= this.volume != desc.volume;
        flag |= this.pixels != desc.pixels;
        flag |= this.grouping != desc.grouping;
        flag |= this.stimulusR != null && !this.stimulusR.equals(desc.stimulusR);
        flag |= this.concentrationR != null && !this.concentrationR.equals(desc.concentrationR);
        flag |= this.stimulusL != null && !this.stimulusL.equals(desc.stimulusL);
        return flag |= this.concentrationL != null && !this.concentrationL.equals(desc.concentrationL);
    }

    public boolean xmlSaveSpotsDescription(Document doc) {
        Element node = XMLUtil.addElement((Node)XMLUtil.getRootElement((Document)doc), (String)ID_SPOTTRACK);
        if (node == null) {
            return false;
        }
        XMLUtil.setElementIntValue((Node)node, (String)"version", (int)2);
        Element xmlElement = XMLUtil.addElement((Node)node, (String)ID_PARAMETERS);
        XMLUtil.addElement((Node)xmlElement, (String)ID_FILE, (String)this.sourceName);
        Element xmlVal = XMLUtil.addElement((Node)xmlElement, (String)"capillaries");
        XMLUtil.setElementIntValue((Node)xmlVal, (String)ID_DESCGROUPING, (int)this.grouping);
        XMLUtil.setElementDoubleValue((Node)xmlVal, (String)ID_DESCVOLUMEUL, (double)this.volume);
        XMLUtil.setElementIntValue((Node)xmlVal, (String)ID_DESCNPIXELS, (int)this.pixels);
        xmlVal = XMLUtil.addElement((Node)xmlElement, (String)ID_EXPERIMENT);
        XMLUtil.setElementValue((Node)xmlVal, (String)ID_BOXID, (String)this.old_boxID);
        XMLUtil.setElementValue((Node)xmlVal, (String)ID_EXPT, (String)this.old_experiment);
        XMLUtil.setElementValue((Node)xmlVal, (String)ID_COMMENT1, (String)this.old_comment1);
        XMLUtil.setElementValue((Node)xmlVal, (String)ID_COMMENT2, (String)this.old_comment2);
        XMLUtil.setElementValue((Node)xmlVal, (String)ID_STRAIN, (String)this.old_strain);
        XMLUtil.setElementValue((Node)xmlVal, (String)ID_SEX, (String)this.old_sex);
        XMLUtil.setElementValue((Node)xmlVal, (String)ID_COND1, (String)this.old_cond1);
        XMLUtil.setElementValue((Node)xmlVal, (String)ID_COND2, (String)this.old_cond2);
        return true;
    }

    public boolean xmlLoadSpotsDescription(Document doc) {
        boolean flag = false;
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)ID_SPOTTRACK);
        if (node == null) {
            return flag;
        }
        this.version = XMLUtil.getElementIntValue((Node)node, (String)"version", (int)0);
        switch (this.version) {
            case 0: {
                flag = this.xmlLoadSpotsDescriptionv0(node);
                break;
            }
            default: {
                flag = this.xmlLoadCSpotsDescriptionv1(node);
            }
        }
        return flag;
    }

    private boolean xmlLoadSpotsDescriptionv0(Node node) {
        Element xmlElement = XMLUtil.getElement((Node)node, (String)ID_PARAMETERS);
        if (xmlElement == null) {
            return false;
        }
        Element xmlVal = XMLUtil.getElement((Node)xmlElement, (String)ID_FILE);
        this.sourceName = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_ID, null);
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)ID_DESCGROUPING);
        this.grouping = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)ID_DESCN, (int)2);
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)ID_DESCCAPVOLUME);
        this.volume = XMLUtil.getAttributeDoubleValue((Element)xmlVal, (String)ID_DESCVOLUMEUL, (double)Double.NaN);
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)ID_DESCCAPILLARYPIX);
        this.pixels = (int)XMLUtil.getAttributeDoubleValue((Element)xmlVal, (String)ID_DESCNPIXELS, (double)Double.NaN);
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)ID_LRSTIMULUS);
        if (xmlVal != null) {
            this.stimulusR = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_STIMR, (String)ID_STIMR);
            this.concentrationR = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_CONCR, (String)ID_CONCR);
            this.stimulusL = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_STIML, (String)ID_STIML);
            this.concentrationL = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_CONCL, (String)ID_CONCL);
        }
        if ((xmlVal = XMLUtil.getElement((Node)xmlElement, (String)ID_EXPERIMENT)) != null) {
            this.old_boxID = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_BOXID, (String)ID_NOPE);
            this.old_experiment = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_EXPT, (String)ID_NOPE);
            this.old_comment1 = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_COMMENT1, (String)ID_NOPE);
            this.old_comment2 = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_COMMENT2, (String)ID_NOPE);
            this.old_strain = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_STRAIN, (String)ID_NOPE);
            this.old_sex = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_SEX, (String)ID_NOPE);
            this.old_cond1 = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_COND1, (String)ID_NOPE);
            this.old_cond2 = XMLUtil.getAttributeValue((Element)xmlVal, (String)ID_COND2, (String)ID_NOPE);
        }
        return true;
    }

    private boolean xmlLoadCSpotsDescriptionv1(Node node) {
        Element xmlElement = XMLUtil.getElement((Node)node, (String)ID_PARAMETERS);
        if (xmlElement == null) {
            return false;
        }
        this.sourceName = XMLUtil.getElementValue((Node)xmlElement, (String)ID_FILE, null);
        Element xmlVal = XMLUtil.getElement((Node)xmlElement, (String)"capillaries");
        if (xmlVal != null) {
            this.grouping = XMLUtil.getElementIntValue((Node)xmlVal, (String)ID_DESCGROUPING, (int)2);
            this.volume = XMLUtil.getElementDoubleValue((Node)xmlVal, (String)ID_DESCVOLUMEUL, (double)Double.NaN);
            this.pixels = XMLUtil.getElementIntValue((Node)xmlVal, (String)ID_DESCNPIXELS, (int)5);
        }
        if ((xmlVal = XMLUtil.getElement((Node)xmlElement, (String)ID_LRSTIMULUS)) != null) {
            this.stimulusR = XMLUtil.getElementValue((Node)xmlVal, (String)ID_STIMR, (String)ID_STIMR);
            this.concentrationR = XMLUtil.getElementValue((Node)xmlVal, (String)ID_CONCR, (String)ID_CONCR);
            this.stimulusL = XMLUtil.getElementValue((Node)xmlVal, (String)ID_STIML, (String)ID_STIML);
            this.concentrationL = XMLUtil.getElementValue((Node)xmlVal, (String)ID_CONCL, (String)ID_CONCL);
        }
        if ((xmlVal = XMLUtil.getElement((Node)xmlElement, (String)ID_EXPERIMENT)) != null) {
            this.old_boxID = XMLUtil.getElementValue((Node)xmlVal, (String)ID_BOXID, (String)ID_NOPE);
            this.old_experiment = XMLUtil.getElementValue((Node)xmlVal, (String)ID_EXPT, (String)ID_NOPE);
            this.old_comment1 = XMLUtil.getElementValue((Node)xmlVal, (String)ID_COMMENT1, (String)ID_NOPE);
            this.old_comment2 = XMLUtil.getElementValue((Node)xmlVal, (String)ID_COMMENT2, (String)ID_NOPE);
        }
        return true;
    }

    public String csvExportSectionHeader(String csvSep) {
        StringBuffer sbf = new StringBuffer();
        sbf.append("#" + csvSep + "DESCRIPTION" + csvSep + "multiSPOTS data\n");
        List<String> row2 = Arrays.asList(ID_DESCGROUPING, ID_DESCVOLUMEUL, ID_DESCNPIXELS, ID_STIMR, ID_CONCR, ID_STIML, ID_CONCL, ID_BOXID, ID_EXPT, ID_COMMENT1, ID_COMMENT2, ID_STRAIN, ID_SEX, ID_COND1, ID_COND2);
        sbf.append(String.join((CharSequence)csvSep, row2));
        sbf.append("\n");
        return sbf.toString();
    }

    public String csvExportExperimentDescriptors(String csvSep) {
        StringBuffer sbf = new StringBuffer();
        List<String> row3 = Arrays.asList(Integer.toString(this.grouping), Double.toString(this.volume), Integer.toString(this.pixels), this.stimulusR, this.concentrationR.replace(",", "."), this.stimulusL, this.concentrationL.replace(",", "."), this.old_boxID, this.old_experiment, this.old_comment1, this.old_comment2, this.old_strain, this.old_sex, this.old_cond1, this.old_cond2);
        sbf.append(String.join((CharSequence)csvSep, row3));
        sbf.append("\n");
        return sbf.toString();
    }

    public void csvImportSpotsDescriptionData(String[] data) {
        int i = 0;
        this.grouping = Integer.valueOf(data[i]);
        this.volume = Double.valueOf(data[++i]);
        this.pixels = Integer.valueOf(data[++i]);
        this.stimulusR = data[++i];
        this.concentrationR = data[++i];
        this.stimulusL = data[++i];
        this.concentrationL = data[++i];
        this.old_boxID = data[++i];
        this.old_experiment = data[++i];
        this.old_comment1 = data[++i];
        this.old_comment2 = data[++i];
        this.old_strain = data[++i];
        this.old_sex = data[++i];
        int nitems = data.length;
        if (i < nitems) {
            this.old_cond1 = data[i];
        }
        if (++i < nitems) {
            this.old_cond2 = data[i];
        }
    }
}

