/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.toExcel;

import java.util.ArrayList;
import java.util.Arrays;
import plugins.fmp.multiSPOTS.experiment.Spot;
import plugins.fmp.multiSPOTS.experiment.SpotsArray;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSResults;

public class XLSResultsArray {
    ArrayList<XLSResults> resultsList = null;
    XLSResults evapL = null;
    XLSResults evapR = null;
    boolean sameLR = true;
    String stim = null;
    String conc = null;
    double lowestPiAllowed = -1.2;
    double highestPiAllowed = 1.2;

    public XLSResultsArray(int size) {
        this.resultsList = new ArrayList(size);
    }

    public XLSResultsArray() {
        this.resultsList = new ArrayList();
    }

    public int size() {
        return this.resultsList.size();
    }

    public XLSResults getRow(int index) {
        if (index >= this.resultsList.size()) {
            return null;
        }
        return this.resultsList.get(index);
    }

    public XLSResults getNextRow(int irow) {
        XLSResults rowL = this.resultsList.get(irow);
        int cageL = this.getCageFromKymoFileName(rowL.name);
        XLSResults rowR = null;
        if (irow + 1 < this.resultsList.size()) {
            rowR = this.resultsList.get(irow + 1);
            int cageR = this.getCageFromKymoFileName(rowR.name);
            if (cageR != cageL) {
                rowR = null;
            }
        }
        return rowR;
    }

    protected int getCageFromKymoFileName(String name) {
        if (!name.contains("line")) {
            return -1;
        }
        return Integer.valueOf(name.substring(4, 5));
    }

    public void checkIfSameStimulusAndConcentration(Spot spot) {
        if (!this.sameLR) {
            return;
        }
        if (this.stim == null) {
            this.stim = spot.spotStim;
        }
        if (this.conc == null) {
            this.conc = spot.spotConc;
        }
        this.sameLR &= this.stim.equals(spot.spotStim);
        this.sameLR &= this.conc.equals(spot.spotConc);
    }

    public void subtractEvaporation() {
        int dimension = 0;
        for (XLSResults result : this.resultsList) {
            if (result.valuesOut == null || result.valuesOut.length <= dimension) continue;
            dimension = result.valuesOut.length;
        }
        if (dimension == 0) {
            return;
        }
        this.computeEvaporationFromResultsWithZeroFlies(dimension);
        this.subtractEvaporationLocal();
    }

    private void computeEvaporationFromResultsWithZeroFlies(int dimension) {
        this.evapL = new XLSResults("L", 0, 0, null);
        this.evapR = new XLSResults("R", 0, 0, null);
        this.evapL.initValuesOutArray(dimension, 0.0);
        this.evapR.initValuesOutArray(dimension, 0.0);
        for (XLSResults result : this.resultsList) {
            if (result.valuesOut == null || result.nflies != 0) continue;
            String side = result.name.substring(result.name.length() - 1);
            if (this.sameLR || side.contains("L")) {
                this.evapL.addDataToValOutEvap(result);
                continue;
            }
            this.evapR.addDataToValOutEvap(result);
        }
        this.evapL.averageEvaporation();
        this.evapR.averageEvaporation();
    }

    private void subtractEvaporationLocal() {
        for (XLSResults result : this.resultsList) {
            String side = result.name.substring(result.name.length() - 1);
            if (this.sameLR || side.contains("L")) {
                result.subtractEvap(this.evapL);
                continue;
            }
            result.subtractEvap(this.evapR);
        }
    }

    public void subtractDeltaT(int i, int j) {
        for (XLSResults row : this.resultsList) {
            row.subtractDeltaT(1, 1);
        }
    }

    private int getLen(XLSResults rowL, XLSResults rowR) {
        int lenL = rowL.valuesOut.length;
        int lenR = rowR.valuesOut.length;
        return Math.min(lenL, lenR);
    }

    public void getPI_LR(XLSResults rowL, XLSResults rowR, double threshold) {
        int len = this.getLen(rowL, rowR);
        for (int index = 0; index < len; ++index) {
            double dataL = rowL.valuesOut[index];
            double dataR = rowR.valuesOut[index];
            double delta = 0.0;
            if (dataL < 0.0) {
                delta = dataL;
            }
            if (dataR < delta) {
                delta = dataR;
            }
            double sum = (dataL -= delta) + (dataR -= delta);
            double pi = 0.0;
            if (sum != 0.0 && !Double.isNaN(sum) && sum >= threshold) {
                pi = (dataL - dataR) / sum;
            }
            if (pi > this.highestPiAllowed) {
                pi = this.highestPiAllowed;
            }
            if (pi < this.lowestPiAllowed) {
                pi = this.lowestPiAllowed;
            }
            rowL.valuesOut[index] = sum;
            rowR.valuesOut[index] = pi;
        }
    }

    public void getSpotsArrayResults_T0(SpotsArray spotsArray, EnumXLSExportType exportType, int nOutputFrames, long kymoBinCol_Ms, XLSExportOptions xlsExportOptions) {
        xlsExportOptions.exportType = exportType;
        this.buildSpotsDataForPass1(spotsArray, nOutputFrames, kymoBinCol_Ms, xlsExportOptions);
        this.buildDataForPass2(xlsExportOptions);
    }

    public void getSpotsArrayResults1(SpotsArray spotsArray, int nOutputFrames, long kymoBinCol_Ms, XLSExportOptions xlsExportOptions) {
        this.buildSpotsDataForPass1(spotsArray, nOutputFrames, kymoBinCol_Ms, xlsExportOptions);
        this.buildDataForPass2(xlsExportOptions);
    }

    private void buildSpotsDataForPass1(SpotsArray spotsArray, int nOutputFrames, long kymoBinCol_Ms, XLSExportOptions xlsExportOptions) {
        double scalingFactorToPhysicalUnits = spotsArray.getScalingFactorToPhysicalUnits(xlsExportOptions.exportType);
        for (Spot spot : spotsArray.spotsList) {
            this.checkIfSameStimulusAndConcentration(spot);
            XLSResults results = new XLSResults(spot.getRoiName(), spot.spotNFlies, spot.spotIndex, xlsExportOptions.exportType, nOutputFrames);
            results.dataValues = spot.getSpotMeasuresForXLSPass1(xlsExportOptions.exportType, kymoBinCol_Ms, xlsExportOptions.buildExcelStepMs);
            if (xlsExportOptions.relativeToT0 && xlsExportOptions.exportType != EnumXLSExportType.AREA_FLYPRESENT) {
                results.relativeToT0();
            }
            results.transferMeasuresToValuesOut(scalingFactorToPhysicalUnits, xlsExportOptions.exportType);
            this.resultsList.add(results);
        }
    }

    public void buildDataForPass2(XLSExportOptions xlsExportOptions) {
        switch (xlsExportOptions.exportType) {
            case TOPLEVEL_LR: 
            case TOPLEVELDELTA_LR: 
            case AREA_SUM_LR: 
            case AREA_SUMCLEAN_LR: {
                this.buildLR(xlsExportOptions.lrPIThreshold);
                break;
            }
            case AUTOCORREL: {
                this.buildAutocorrel(xlsExportOptions);
                break;
            }
            case AUTOCORREL_LR: {
                this.buildAutocorrelLR(xlsExportOptions);
                break;
            }
            case CROSSCORREL: {
                this.buildCrosscorrel(xlsExportOptions);
                break;
            }
            case CROSSCORREL_LR: {
                this.buildCrosscorrelLR(xlsExportOptions);
                break;
            }
        }
    }

    private void buildLR(double threshold) {
        for (int irow = 0; irow < this.resultsList.size(); ++irow) {
            XLSResults rowL = this.getRow(irow);
            XLSResults rowR = this.getNextRow(irow);
            if (rowR == null) continue;
            ++irow;
            this.getPI_LR(rowL, rowR, threshold);
        }
    }

    private void buildAutocorrel(XLSExportOptions xlsExportOptions) {
        for (int irow = 0; irow < this.resultsList.size(); ++irow) {
            XLSResults rowL = this.getRow(irow);
            this.correl(rowL, rowL, rowL, xlsExportOptions.nBinsCorrelation);
        }
    }

    private void buildCrosscorrel(XLSExportOptions xlsExportOptions) {
        for (int irow = 0; irow < this.resultsList.size(); ++irow) {
            XLSResults rowL = this.getRow(irow);
            XLSResults rowR = this.getNextRow(irow);
            if (rowR == null) continue;
            ++irow;
            XLSResults rowLtoR = new XLSResults("LtoR", 0, 0, null);
            rowLtoR.initValuesOutArray(rowL.dimension, 0.0);
            this.correl(rowL, rowR, rowLtoR, xlsExportOptions.nBinsCorrelation);
            XLSResults rowRtoL = new XLSResults("RtoL", 0, 0, null);
            rowRtoL.initValuesOutArray(rowL.dimension, 0.0);
            this.correl(rowR, rowL, rowRtoL, xlsExportOptions.nBinsCorrelation);
            rowL.copyValuesOut(rowLtoR);
            rowR.copyValuesOut(rowRtoL);
        }
    }

    private void buildCrosscorrelLR(XLSExportOptions xlsExportOptions) {
        for (int irow = 0; irow < this.resultsList.size(); ++irow) {
            XLSResults rowL = this.getRow(irow);
            XLSResults rowR = this.getNextRow(irow);
            if (rowR == null) continue;
            ++irow;
            XLSResults rowLR = new XLSResults("LR", 0, 0, null);
            rowLR.initValuesOutArray(rowL.dimension, 0.0);
            this.combineIntervals(rowL, rowR, rowLR);
            this.correl(rowL, rowLR, rowL, xlsExportOptions.nBinsCorrelation);
            this.correl(rowR, rowLR, rowR, xlsExportOptions.nBinsCorrelation);
        }
    }

    private void correl(XLSResults row1, XLSResults row2, XLSResults rowOut, int nbins) {
        double[] sumBins = new double[2 * nbins + 1];
        Arrays.fill(sumBins, 0.0);
        double nitems = 0.0;
        for (int i1 = 0; i1 < row1.valuesOut.length; ++i1) {
            if (row1.valuesOut[i1] == 0.0) continue;
            nitems += 1.0;
            for (int i2 = 0; i2 < row2.valuesOut.length; ++i2) {
                int ibin = i2 - i1;
                if (ibin < -nbins || ibin > nbins || row2.valuesOut[i2] == 0.0) continue;
                int n = ibin + nbins;
                sumBins[n] = sumBins[n] + 1.0;
            }
        }
        Arrays.fill(rowOut.valuesOut, Double.NaN);
        for (int i = 0; i < 2 * nbins; ++i) {
            rowOut.valuesOut[i] = sumBins[i] / nitems;
        }
    }

    private void combineIntervals(XLSResults row1, XLSResults row2, XLSResults rowOut) {
        for (int i = 0; i < rowOut.valuesOut.length; ++i) {
            if (!(row2.valuesOut[i] + row1.valuesOut[i] > 0.0)) continue;
            rowOut.valuesOut[i] = 1.0;
        }
    }

    private void buildAutocorrelLR(XLSExportOptions xlsExportOptions) {
        for (int irow = 0; irow < this.resultsList.size(); ++irow) {
            XLSResults rowL = this.getRow(irow);
            XLSResults rowR = this.getNextRow(irow);
            if (rowR == null) continue;
            ++irow;
            XLSResults rowLR = new XLSResults("LR", 0, 0, null);
            rowLR.initValuesOutArray(rowL.dimension, 0.0);
            this.combineIntervals(rowL, rowR, rowLR);
            this.correl(rowLR, rowLR, rowL, xlsExportOptions.nBinsCorrelation);
            this.correl(rowLR, rowLR, rowR, xlsExportOptions.nBinsCorrelation);
        }
    }
}

