/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import icy.canvas.IcyCanvas;
import icy.canvas.Layer;
import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import plugins.fmp.multiSPOTS.experiment.Cage;
import plugins.fmp.multiSPOTS.experiment.EnumStatus;
import plugins.fmp.multiSPOTS.experiment.ExperimentDirectories;
import plugins.fmp.multiSPOTS.experiment.FileNameTimePattern;
import plugins.fmp.multiSPOTS.tools.Comparators;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class SequenceCamData {
    public Sequence seq = null;
    public IcyBufferedImage refImage = null;
    public long seqAnalysisStart = 0L;
    public int seqAnalysisStep = 1;
    public int currentFrame = 0;
    public int nTotalFrames = 0;
    public EnumStatus status = EnumStatus.REGULAR;
    protected String csCamFileName = null;
    public String imagesDirectory = null;
    public List<String> imagesList = new ArrayList<String>();
    long timeFirstImageInMs = 0L;
    int indexTimePattern = -1;
    FileNameTimePattern[] timePatternArray = new FileNameTimePattern[]{new FileNameTimePattern(), new FileNameTimePattern("yyyy-MM-dd_HH-mm-ss", "\\d{4}-\\d{2}-\\d{2}_\\d{2}\\-\\d{2}\\-\\d{2}"), new FileNameTimePattern("yy-MM-dd_HH-mm-ss", "\\d{2}-\\d{2}-\\d{2}_\\d{2}\\-\\d{2}\\-\\d{2}"), new FileNameTimePattern("yy.MM.dd_HH.mm.ss", "\\d{2}.\\d{2}.\\d{2}_\\d{2}\\.\\d{2}\\.\\d{2}")};

    public SequenceCamData() {
        this.seq = new Sequence();
        this.status = EnumStatus.FILESTACK;
    }

    public SequenceCamData(String name, IcyBufferedImage image) {
        this.seq = new Sequence(name, image);
        this.status = EnumStatus.FILESTACK;
    }

    public SequenceCamData(List<String> listNames) {
        this.setImagesList(listNames);
        this.status = EnumStatus.FILESTACK;
    }

    public String getImagesDirectory() {
        Path strPath = Paths.get(this.imagesList.get(0), new String[0]);
        this.imagesDirectory = strPath.getParent().toString();
        return this.imagesDirectory;
    }

    public void setImagesDirectory(String directoryString) {
        this.imagesDirectory = directoryString;
    }

    public List<String> getImagesList(boolean bsort) {
        if (bsort) {
            Collections.sort(this.imagesList);
        }
        return this.imagesList;
    }

    public String getDecoratedImageName(int t) {
        this.currentFrame = t;
        if (this.seq != null) {
            return this.getCSCamFileName() + " [" + t + "/" + (this.seq.getSizeT() - 1) + "]";
        }
        return this.getCSCamFileName() + "[]";
    }

    public String getCSCamFileName() {
        if (this.csCamFileName == null) {
            Path path = Paths.get(this.imagesList.get(0), new String[0]);
            int rootlevel = path.getNameCount() - 4;
            if (rootlevel < 0) {
                rootlevel = 0;
            }
            this.csCamFileName = path.subpath(rootlevel, path.getNameCount() - 1).toString();
        }
        return this.csCamFileName;
    }

    public String getFileNameFromImageList(int t) {
        String csName = null;
        if (this.status == EnumStatus.FILESTACK || this.status == EnumStatus.KYMOGRAPH) {
            if (this.imagesList.size() < 1) {
                this.loadImageList();
            }
            csName = this.imagesList.get(t);
        }
        return csName;
    }

    private void loadImageList() {
        List<String> imagesList = ExperimentDirectories.getImagesListFromPathV2(this.imagesDirectory, "jpg");
        if (imagesList.size() > 0) {
            this.setImagesList(imagesList);
            this.attachSequence(this.loadSequenceFromImagesList(imagesList));
        }
    }

    public String getFileNameNoPath(int t) {
        String csName = null;
        csName = this.imagesList.get(t);
        if (csName != null) {
            Path path = Paths.get(csName, new String[0]);
            return path.getName(path.getNameCount() - 1).toString();
        }
        return csName;
    }

    public IcyBufferedImage getSeqImage(int t, int z) {
        this.currentFrame = t;
        return this.seq.getImage(t, z);
    }

    String fileComponent(String fname) {
        int pos = fname.lastIndexOf("/");
        if (pos > -1) {
            return fname.substring(pos + 1);
        }
        return fname;
    }

    public FileTime getFileTimeFromStructuredName(int t) {
        long timeInMs = 0L;
        String fileName = this.fileComponent(this.getFileNameFromImageList(t));
        if (fileName == null) {
            timeInMs = this.timePatternArray[0].getDummyTime(t);
        } else {
            if (this.indexTimePattern < 0) {
                this.indexTimePattern = this.findProperFilterIfAny(fileName);
            }
            FileNameTimePattern tp = this.timePatternArray[this.indexTimePattern];
            timeInMs = tp.getTimeFromString(fileName, t);
        }
        FileTime fileTime = FileTime.fromMillis(timeInMs);
        return fileTime;
    }

    int findProperFilterIfAny(String fileName) {
        int index = 0;
        for (int i = 1; i < this.timePatternArray.length; ++i) {
            if (!this.timePatternArray[i].findMatch(fileName)) continue;
            return i;
        }
        return index;
    }

    public FileTime getFileTimeFromFileAttributes(int t) {
        FileTime filetime = null;
        File file = new File(this.getFileNameFromImageList(t));
        Path filePath = file.toPath();
        BasicFileAttributes attributes = null;
        try {
            attributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException exception) {
            System.out.println("SeqCamData:getFileTimeFromFileAttributes() Exception handled when trying to get file attributes: " + exception.getMessage());
        }
        long milliseconds = attributes.creationTime().to(TimeUnit.MILLISECONDS);
        if (milliseconds > Long.MIN_VALUE && milliseconds < Long.MAX_VALUE) {
            Date creationDate = new Date(attributes.creationTime().to(TimeUnit.MILLISECONDS));
            filetime = FileTime.fromMillis(creationDate.getTime());
        }
        return filetime;
    }

    public FileTime getFileTimeFromJPEGMetaData(int t) {
        FileTime filetime = null;
        File file = new File(this.getFileNameFromImageList(t));
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((File)file);
            ExifSubIFDDirectory directory = (ExifSubIFDDirectory)metadata.getFirstDirectoryOfType(ExifSubIFDDirectory.class);
            Date date = directory.getDate(36867);
            filetime = FileTime.fromMillis(date.getTime());
        }
        catch (ImageProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filetime;
    }

    public List<Cage> getCagesFromROIs() {
        ArrayList roiList = this.seq.getROI2Ds();
        Collections.sort(roiList, new Comparators.ROI2D_Name_Comparator());
        ArrayList<Cage> cageList = new ArrayList<Cage>();
        for (ROI2D roi : roiList) {
            String csName = roi.getName();
            if (!(roi instanceof ROI2DPolygon) || (csName.length() <= 4 || !csName.substring(0, 4).contains("cage")) && !csName.contains("Polygon2D")) continue;
            Cage cage = new Cage();
            cage.cageRoi2D = roi;
            cageList.add(cage);
        }
        return cageList;
    }

    public void displayViewerAtRectangle(final Rectangle parent0Rect) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Viewer v = SequenceCamData.this.seq.getFirstViewer();
                    if (v == null) {
                        v = new Viewer(SequenceCamData.this.seq, true);
                    }
                    Rectangle rectv = v.getBoundsInternal();
                    rectv.setLocation(parent0Rect.x + parent0Rect.width, parent0Rect.y);
                    v.setBounds(rectv);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void closeSequence() {
        if (this.seq == null) {
            return;
        }
        this.seq.removeAllROI();
        this.seq.close();
    }

    public void setImagesList(List<String> extImagesList) {
        this.imagesList.clear();
        this.imagesList.addAll(extImagesList);
        this.nTotalFrames = this.imagesList.size();
        this.status = EnumStatus.FILESTACK;
    }

    public void attachSequence(Sequence seq) {
        this.seq = seq;
        this.status = EnumStatus.FILESTACK;
        this.seqAnalysisStart = 0L;
    }

    public void completeSequence(Sequence seq2) {
        if (this.seq != null) {
            ArrayList listROIS = this.seq.getROIs();
            seq2.addROIs((Collection)listROIS, false);
        }
        this.seq = seq2;
        this.status = EnumStatus.FILESTACK;
        this.seqAnalysisStart = 0L;
    }

    public IcyBufferedImage imageIORead(String name) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(name));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return IcyBufferedImage.createFrom((BufferedImage)image);
    }

    public boolean loadImages() {
        if (this.imagesList.size() == 0) {
            return false;
        }
        this.attachSequence(this.loadSequenceFromImagesList(this.imagesList));
        return this.seq != null;
    }

    public boolean loadFirstImage() {
        if (this.imagesList.size() == 0) {
            return false;
        }
        ArrayList<String> dummyList = new ArrayList<String>();
        dummyList.add(this.imagesList.get(0));
        this.attachSequence(this.loadSequenceFromImagesList(dummyList));
        return this.seq != null;
    }

    public Sequence loadSequenceFromImagesList(List<String> imagesList) {
        SequenceFileImporter seqFileImporter = Loader.getSequenceFileImporter((String)imagesList.get(0), (boolean)true);
        Sequence seq = (Sequence)Loader.loadSequences((SequenceFileImporter)seqFileImporter, imagesList, (int)0, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false).get(0);
        return seq;
    }

    public Sequence initSequenceFromFirstImage(List<String> imagesList) {
        SequenceFileImporter seqFileImporter = Loader.getSequenceFileImporter((String)imagesList.get(0), (boolean)true);
        Sequence seq = Loader.loadSequence((SequenceFileImporter)seqFileImporter, (String)imagesList.get(0), (int)0, (boolean)false);
        return seq;
    }

    public void displayROIs(boolean isVisible, String pattern) {
        Viewer v = this.seq.getFirstViewer();
        IcyCanvas canvas = v.getCanvas();
        List layers = canvas.getLayers(false);
        if (layers == null) {
            return;
        }
        for (Layer layer : layers) {
            String cs;
            ROI roi = layer.getAttachedROI();
            if (roi == null || !(cs = roi.getName()).contains(pattern)) continue;
            layer.setVisible(isVisible);
        }
    }
}

