/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.series;

import icy.file.Saver;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageCursor;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.Sequence;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.DataType;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import loci.formats.FormatException;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.ROI2DAlongT;
import plugins.fmp.multiSPOTS.experiment.SequenceCamData;
import plugins.fmp.multiSPOTS.experiment.SequenceKymos;
import plugins.fmp.multiSPOTS.experiment.Spot;
import plugins.fmp.multiSPOTS.series.BuildSeries;
import plugins.fmp.multiSPOTS.tools.GaspardRigidRegistration;

public class BuildSpotsKymos
extends BuildSeries {
    public Sequence seqData = new Sequence();
    private Viewer vData = null;
    private int kymoImageWidth = 0;

    @Override
    void analyzeExperiment(Experiment exp) {
        if (!this.loadExperimentDataToBuildKymos(exp) || exp.spotsArray.spotsList.size() < 1) {
            return;
        }
        this.openKymoViewers(exp);
        this.getTimeLimitsOfSeqCamData(exp);
        if (this.buildKymo(exp)) {
            this.saveComputation(exp);
        }
        this.closeKymoViewers();
        exp.seqSpotKymos.closeSequence();
    }

    private boolean loadExperimentDataToBuildKymos(Experiment exp) {
        boolean flag = exp.loadMCSpots_Only();
        exp.seqCamData.seq = exp.seqCamData.initSequenceFromFirstImage(exp.seqCamData.getImagesList(true));
        return flag;
    }

    private void getTimeLimitsOfSeqCamData(Experiment exp) {
        exp.getFileIntervalsFromSeqCamData();
        exp.binDuration_ms = this.options.t_Ms_BinDuration;
        if (this.options.isFrameFixed) {
            exp.binFirst_ms = this.options.t_Ms_First;
            exp.binLast_ms = this.options.t_Ms_Last;
            if (exp.binLast_ms + exp.camImageFirst_ms > exp.camImageLast_ms) {
                exp.binLast_ms = exp.camImageLast_ms - exp.camImageFirst_ms;
            }
        } else {
            exp.binFirst_ms = 0L;
            exp.binLast_ms = exp.camImageLast_ms - exp.camImageFirst_ms;
        }
    }

    private void saveComputation(final Experiment exp) {
        String directory;
        if (this.options.doCreateBinDir) {
            exp.setBinSubDirectory(exp.getBinNameFromKymoFrameStep());
        }
        if ((directory = exp.getDirectoryToSaveResults()) == null) {
            return;
        }
        ProgressFrame progressBar = new ProgressFrame("Save kymographs");
        int nframes = exp.seqSpotKymos.seq.getSizeT();
        int nCPUs = SystemUtil.getNumberOfCPUs();
        Processor processor = new Processor(nCPUs);
        processor.setThreadName("buildkymo2");
        processor.setPriority(5);
        ArrayList futuresArray = new ArrayList(nframes);
        futuresArray.clear();
        int t = 0;
        while (t < exp.seqSpotKymos.seq.getSizeT()) {
            final int t_index = t++;
            futuresArray.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    Spot spot = exp.spotsArray.spotsList.get(t_index);
                    String filename = directory + File.separator + spot.getRoiName() + ".tiff";
                    File file = new File(filename);
                    IcyBufferedImage image = exp.seqSpotKymos.getSeqImage(t_index, 0);
                    try {
                        Saver.saveImage((IcyBufferedImage)image, (File)file, (boolean)true);
                    }
                    catch (FormatException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }));
        }
        this.waitFuturesCompletion(processor, futuresArray, progressBar);
        progressBar.close();
        exp.saveXML_MCExperiment();
    }

    private boolean buildKymo(final Experiment exp) {
        if (exp.spotsArray.spotsList.size() < 1) {
            System.out.println("BuildKymoSpots:buildKymo Abort (1): nb spots = 0");
            return false;
        }
        this.initArraysToBuildKymographImages(exp);
        this.threadRunning = true;
        this.stopFlag = false;
        final int tFirst = (int)exp.frameFirst;
        final int tLast = exp.seqCamData.nTotalFrames;
        int tDelta = (int)exp.frameDelta;
        final ProgressFrame progressBar1 = new ProgressFrame("Analyze stack frame ");
        Processor processor = new Processor(SystemUtil.getNumberOfCPUs());
        processor.setThreadName("buildKymograph");
        processor.setPriority(5);
        int ntasks = exp.spotsArray.spotsList.size();
        ArrayList tasks = new ArrayList(ntasks);
        tasks.clear();
        this.vData.setTitle(exp.seqCamData.getCSCamFileName());
        for (int ii = tFirst; ii < tLast; ii += tDelta) {
            final int t = ii;
            if (this.options.concurrentDisplay) {
                IcyBufferedImage sourceImage0 = this.imageIORead(exp.seqCamData.getFileNameFromImageList(t));
                this.seqData.setImage(0, 0, (BufferedImage)sourceImage0);
                this.vData.setTitle("Frame #" + ii + " /" + tLast);
            }
            tasks.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    progressBar1.setMessage("Analyze frame: " + t + "//" + tLast);
                    IcyBufferedImage sourceImage = BuildSpotsKymos.this.loadImageFromIndex(exp, t);
                    int sizeC = sourceImage.getSizeC();
                    IcyBufferedImageCursor cursorSource = new IcyBufferedImageCursor(sourceImage);
                    for (Spot spot : exp.spotsArray.spotsList) {
                        BuildSpotsKymos.this.analyzeImageWithSpot(cursorSource, spot, t - tFirst, sizeC);
                    }
                }
            }));
        }
        this.waitFuturesCompletion(processor, tasks, null);
        progressBar1.close();
        ProgressFrame progressBar2 = new ProgressFrame("Combine results into kymograph");
        int sizeC = this.seqData.getSizeC();
        this.exportSpotImages_to_Kymograph(exp, sizeC);
        progressBar2.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeImageWithSpot(IcyBufferedImageCursor cursorSource, Spot spot, int t, int sizeC) {
        ROI2DAlongT roiT = spot.getROIAtT(t);
        for (int chan = 0; chan < sizeC; ++chan) {
            IcyBufferedImageCursor cursor = new IcyBufferedImageCursor(spot.spot_Image);
            try {
                for (int y = 0; y < roiT.mask2DPoints_in.length; ++y) {
                    Point pt = roiT.mask2DPoints_in[y];
                    cursor.set(t, y, chan, cursorSource.get((int)pt.getX(), (int)pt.getY(), chan));
                }
                continue;
            }
            finally {
                cursor.commitChanges();
            }
        }
    }

    private IcyBufferedImage loadImageFromIndex(Experiment exp, int frameIndex) {
        IcyBufferedImage sourceImage = this.imageIORead(exp.seqCamData.getFileNameFromImageList(frameIndex));
        if (this.options.doRegistration) {
            String referenceImageName = exp.seqCamData.getFileNameFromImageList(this.options.referenceFrame);
            IcyBufferedImage referenceImage = this.imageIORead(referenceImageName);
            this.adjustImage(sourceImage, referenceImage);
        }
        return sourceImage;
    }

    private void exportSpotImages_to_Kymograph(Experiment exp, int sizeC) {
        final Sequence seqKymo = exp.seqSpotKymos.seq;
        seqKymo.beginUpdate();
        Processor processor = new Processor(SystemUtil.getNumberOfCPUs());
        processor.setThreadName("buildKymograph");
        processor.setPriority(5);
        int nbspots = exp.spotsArray.spotsList.size();
        ArrayList tasks = new ArrayList(nbspots);
        tasks.clear();
        final int vertical_resolution = 512;
        int ispot = 0;
        while (ispot < nbspots) {
            final Spot spot = exp.spotsArray.spotsList.get(ispot);
            final int indexSpot = ispot++;
            tasks.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    IcyBufferedImage kymoImage = IcyBufferedImageUtil.scale((IcyBufferedImage)spot.spot_Image, (int)spot.spot_Image.getWidth(), (int)vertical_resolution);
                    seqKymo.setImage(indexSpot, 0, (BufferedImage)kymoImage);
                    spot.spot_Image = null;
                }
            }));
        }
        this.waitFuturesCompletion(processor, tasks, null);
        seqKymo.endUpdate();
    }

    private void initArraysToBuildKymographImages(Experiment exp) {
        DataType dataType;
        if (exp.seqSpotKymos == null) {
            exp.seqSpotKymos = new SequenceKymos();
        }
        SequenceKymos seqKymos = exp.seqSpotKymos;
        seqKymos.seq = new Sequence();
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData.seq == null) {
            seqCamData.seq = exp.seqCamData.initSequenceFromFirstImage(exp.seqCamData.getImagesList(true));
        }
        this.kymoImageWidth = (int)((long)exp.seqCamData.nTotalFrames - exp.frameFirst);
        int numC = seqCamData.seq.getSizeC();
        if (numC <= 0) {
            numC = 3;
        }
        if ((dataType = seqCamData.seq.getDataType_()).toString().equals("undefined")) {
            dataType = DataType.UBYTE;
        }
        for (Spot spot : exp.spotsArray.spotsList) {
            int imageHeight = 0;
            for (ROI2DAlongT roiT : spot.getROIAlongTList()) {
                roiT.buildMask2DFromRoi_in();
                int imageHeight_i = roiT.mask2DPoints_in.length;
                if (imageHeight_i <= imageHeight) continue;
                imageHeight = imageHeight_i;
            }
            spot.spot_Image = new IcyBufferedImage(this.kymoImageWidth, imageHeight, numC, dataType);
        }
    }

    private void adjustImage(IcyBufferedImage workImage, IcyBufferedImage referenceImage) {
        int referenceChannel = 0;
        GaspardRigidRegistration.correctTranslation2D(workImage, referenceImage, referenceChannel);
        boolean rotate = GaspardRigidRegistration.correctRotation2D(workImage, referenceImage, referenceChannel);
        if (rotate) {
            GaspardRigidRegistration.correctTranslation2D(workImage, referenceImage, referenceChannel);
        }
    }

    private void closeKymoViewers() {
        this.closeViewer(this.vData);
        this.closeSequence(this.seqData);
    }

    private void openKymoViewers(final Experiment exp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BuildSpotsKymos.this.seqData = BuildSpotsKymos.this.newSequence("analyze stack starting with file " + exp.seqCamData.seq.getName(), exp.seqCamData.getSeqImage(0, 0));
                    BuildSpotsKymos.this.vData = new Viewer(BuildSpotsKymos.this.seqData, true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

