/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.Canvas2D;

import icy.canvas.Canvas2D;
import icy.gui.component.button.IcyButton;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.resource.icon.IcyIcon;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import plugins.fmp.multiSPOTS.resource.ResourceUtilFMP;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformOptions;

public class Canvas2D_2Transforms
extends Canvas2D {
    private static final long serialVersionUID = 8827595503996677250L;
    public ImageTransformEnums[] imageTransformStep1 = new ImageTransformEnums[]{ImageTransformEnums.NONE, ImageTransformEnums.R_RGB, ImageTransformEnums.G_RGB, ImageTransformEnums.B_RGB, ImageTransformEnums.R2MINUS_GB, ImageTransformEnums.G2MINUS_RB, ImageTransformEnums.B2MINUS_RG, ImageTransformEnums.RGB, ImageTransformEnums.GBMINUS_2R, ImageTransformEnums.RBMINUS_2G, ImageTransformEnums.RGMINUS_2B, ImageTransformEnums.RGB_DIFFS, ImageTransformEnums.H_HSB, ImageTransformEnums.S_HSB, ImageTransformEnums.B_HSB};
    public JComboBox<ImageTransformEnums> transformsComboStep1 = new JComboBox<ImageTransformEnums>(this.imageTransformStep1);
    ImageTransformInterface transformStep1 = ImageTransformEnums.NONE.getFunction();
    ImageTransformOptions transformOptionsStep1 = new ImageTransformOptions();
    public ImageTransformEnums[] imageTransformStep2 = new ImageTransformEnums[]{ImageTransformEnums.NONE, ImageTransformEnums.SORT_SUMDIFFCOLS, ImageTransformEnums.SORT_CHAN0COLS};
    public JComboBox<ImageTransformEnums> transformsComboStep2 = new JComboBox<ImageTransformEnums>(this.imageTransformStep2);
    ImageTransformInterface transformStep2 = ImageTransformEnums.NONE.getFunction();

    public Canvas2D_2Transforms(Viewer viewer) {
        super(viewer);
    }

    public void customizeToolbar(JToolBar toolBar) {
        for (int i = 3; i >= 0; --i) {
            toolBar.remove(i);
        }
        toolBar.addSeparator();
        toolBar.add(new JLabel("step1"));
        toolBar.add(this.transformsComboStep1);
        this.transformsComboStep1.setToolTipText("transform image step 1");
        IcyIcon fitY = ResourceUtilFMP.ICON_FIT_YAXIS;
        IcyButton fitYAxisButton = new IcyButton(fitY);
        fitYAxisButton.setSelected(false);
        fitYAxisButton.setFocusable(false);
        fitYAxisButton.setToolTipText("Set image scale ratio to 1:1 and fit Y axis to the window height");
        toolBar.add((Component)fitYAxisButton);
        IcyIcon fitX = ResourceUtilFMP.ICON_FIT_XAXIS;
        IcyButton fitXAxisButton = new IcyButton(fitX);
        fitXAxisButton.setSelected(false);
        fitXAxisButton.setFocusable(false);
        fitXAxisButton.setToolTipText("Fit X and Y axis to the window size");
        toolBar.add((Component)fitXAxisButton);
        super.customizeToolbar(toolBar);
        fitYAxisButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Canvas2D_2Transforms.this.zoomImage_1_1();
            }
        });
        fitXAxisButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Canvas2D_2Transforms.this.shrinkImage_to_fit();
            }
        });
        this.transformsComboStep1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImageTransformEnums transformEnum;
                Canvas2D_2Transforms.this.transformOptionsStep1.transformOption = transformEnum = (ImageTransformEnums)((Object)Canvas2D_2Transforms.this.transformsComboStep1.getSelectedItem());
                Canvas2D_2Transforms.this.transformStep1 = transformEnum.getFunction();
                Canvas2D_2Transforms.this.refresh();
            }
        });
        this.transformsComboStep1.setSelectedIndex(0);
        this.refresh();
    }

    void zoomImage_1_1() {
        double scaleY;
        Sequence seqKymograph = this.getSequence();
        Rectangle rectImage = seqKymograph.getBounds2D();
        Rectangle rectCanvas = this.getCanvasVisibleRect();
        int offsetX = (int)((double)rectCanvas.width / this.getScaleX() / 2.0);
        double scaleX = scaleY = rectCanvas.getHeight() / rectImage.getHeight();
        this.setMouseImagePos(offsetX, rectImage.height / 2);
        this.setScale(scaleX, scaleY, true, true);
    }

    void shrinkImage_to_fit() {
        Sequence seqKymograph = this.getSequence();
        Rectangle rectImage = seqKymograph.getBounds2D();
        Rectangle rectCanvas = this.getCanvasVisibleRect();
        double scaleX = rectCanvas.getWidth() / rectImage.getWidth();
        double scaleY = rectCanvas.getHeight() / rectImage.getHeight();
        this.setMouseImagePos(rectImage.width / 2, rectImage.height / 2);
        this.setScale(scaleX, scaleY, true, true);
    }

    public IcyBufferedImage getImage(int t, int z, int c) {
        IcyBufferedImage img1 = this.transformStep1.getTransformedImage(super.getImage(t, z, c), this.transformOptionsStep1);
        if (this.transformStep2 != null) {
            return this.transformStep2.getTransformedImage(img1, null);
        }
        return img1;
    }

    public int addTransformsComboStep1(ImageTransformEnums transform) {
        int indexFound = -1;
        for (int index = 0; index < this.transformsComboStep1.getItemCount(); ++index) {
            if (transform != this.transformsComboStep1.getItemAt(index)) continue;
            indexFound = index;
            break;
        }
        if (indexFound < 0) {
            this.transformsComboStep1.addItem(transform);
            this.transformsComboStep1.setSelectedItem((Object)transform);
            indexFound = this.transformsComboStep1.getSelectedIndex();
        }
        return indexFound;
    }

    public void updateTransformsComboStep1(ImageTransformEnums[] transformArray) {
        this.updateTransformsCombo(transformArray, this.transformsComboStep1);
    }

    public void updateTransformsComboStep2(ImageTransformEnums[] transformArray) {
        this.updateTransformsCombo(transformArray, this.transformsComboStep2);
    }

    protected void updateTransformsCombo(ImageTransformEnums[] transformArray, JComboBox<ImageTransformEnums> imageTransformFunctionsCombo) {
        int i;
        ActionListener[] listeners = imageTransformFunctionsCombo.getActionListeners();
        for (i = 0; i < listeners.length; ++i) {
            imageTransformFunctionsCombo.removeActionListener(listeners[i]);
        }
        if (imageTransformFunctionsCombo.getItemCount() > 0) {
            imageTransformFunctionsCombo.removeAllItems();
        }
        imageTransformFunctionsCombo.addItem(ImageTransformEnums.NONE);
        for (i = 0; i < transformArray.length; ++i) {
            imageTransformFunctionsCombo.addItem(transformArray[i]);
        }
        for (i = 0; i < listeners.length; ++i) {
            imageTransformFunctionsCombo.addActionListener(listeners[i]);
        }
    }

    public void selectImageTransformFunctionStep1(int iselected) {
        this.transformsComboStep1.setSelectedIndex(iselected);
    }

    public void selectImageTransformFunctionStep2(int iselected) {
        this.transformsComboStep2.setSelectedIndex(iselected);
    }

    public void customizeToolbarStep2(JToolBar toolBar) {
        toolBar.addSeparator();
        IcyButton previousButton = new IcyButton(ResourceUtilFMP.ICON_PREVIOUS_IMAGE);
        previousButton.setSelected(false);
        previousButton.setFocusable(false);
        previousButton.setToolTipText("Previous");
        toolBar.add((Component)previousButton, 0);
        IcyButton nextButton = new IcyButton(ResourceUtilFMP.ICON_NEXT_IMAGE);
        nextButton.setSelected(false);
        nextButton.setFocusable(false);
        nextButton.setToolTipText("Next");
        toolBar.add((Component)nextButton, 1);
        super.customizeToolbar(toolBar);
        previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Canvas2D_2Transforms.this.setPositionT(Canvas2D_2Transforms.this.getPositionT() - 1);
            }
        });
        nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Canvas2D_2Transforms.this.setPositionT(Canvas2D_2Transforms.this.getPositionT() + 1);
            }
        });
        toolBar.add((Component)new JLabel("step2"), 6);
        toolBar.add((Component)this.transformsComboStep2, 7);
        this.transformsComboStep2.setToolTipText("transform image step 2");
        this.transformsComboStep2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImageTransformEnums transformEnum = (ImageTransformEnums)((Object)Canvas2D_2Transforms.this.transformsComboStep2.getSelectedItem());
                Canvas2D_2Transforms.this.transformStep2 = transformEnum.getFunction();
                Canvas2D_2Transforms.this.refresh();
            }
        });
    }

    public void setTransformStep1ReferenceImage(IcyBufferedImage refImage) {
        this.transformOptionsStep1.backgroundImage = refImage;
    }
}

