/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools;

import icy.sequence.Sequence;
import java.util.List;
import plugins.nherve.toolbox.image.feature.DefaultClusteringAlgorithmImpl;
import plugins.nherve.toolbox.image.feature.IcySupportRegion;
import plugins.nherve.toolbox.image.feature.Segmentable;
import plugins.nherve.toolbox.image.feature.SegmentableIcyBufferedImage;
import plugins.nherve.toolbox.image.feature.Signature;
import plugins.nherve.toolbox.image.feature.clustering.KMeans;
import plugins.nherve.toolbox.image.feature.descriptor.ColorPixel;
import plugins.nherve.toolbox.image.feature.descriptor.DefaultDescriptorImpl;
import plugins.nherve.toolbox.image.feature.region.GridFactory;
import plugins.nherve.toolbox.image.feature.region.SupportRegionException;
import plugins.nherve.toolbox.image.feature.signature.SignatureException;
import plugins.nherve.toolbox.image.feature.signature.VectorSignature;
import plugins.nherve.toolbox.image.mask.MaskException;
import plugins.nherve.toolbox.image.segmentation.DefaultSegmentationAlgorithm;
import plugins.nherve.toolbox.image.segmentation.Segmentation;
import plugins.nherve.toolbox.image.segmentation.SegmentationException;

public class ImageKMeans {
    public static Segmentation doClustering(Sequence seq, int nbc2, int nbi2, double stab2, int cs) throws SupportRegionException, SegmentationException, MaskException, NumberFormatException, SignatureException {
        Segmentation segmentation = null;
        segmentation = ImageKMeans.doClusteringKM(seq, nbc2, nbi2, stab2, cs);
        segmentation.reInitColors(seq.getImage(0, 0));
        return segmentation;
    }

    private static Segmentation doClusteringKM(Sequence currentSequence, int nbc2, int nbi2, double stab2, int cs) throws SupportRegionException, SegmentationException, MaskException, NumberFormatException, SignatureException {
        SegmentableIcyBufferedImage img = new SegmentableIcyBufferedImage(currentSequence.getFirstImage());
        KMeans km2 = new KMeans(nbc2, nbi2, stab2);
        km2.setLogEnabled(false);
        Segmentation seg = null;
        ColorPixel col = null;
        ColorPixel cd = new ColorPixel(false);
        cd.setColorSpace(cs);
        col = cd;
        col.setLogEnabled(false);
        GridFactory factory = new GridFactory(4);
        factory.setLogEnabled(false);
        List lRegions = factory.extractRegions((Segmentable)img);
        IcySupportRegion[] regions = new IcySupportRegion[lRegions.size()];
        int r = 0;
        for (IcySupportRegion sr : lRegions) {
            regions[r++] = sr;
        }
        seg = ImageKMeans.doSingleClustering(img, regions, (DefaultDescriptorImpl<SegmentableIcyBufferedImage, ? extends Signature>)col, (DefaultClusteringAlgorithmImpl<VectorSignature>)km2);
        return seg;
    }

    private static Segmentation doSingleClustering(SegmentableIcyBufferedImage img, IcySupportRegion[] regions, DefaultDescriptorImpl<SegmentableIcyBufferedImage, ? extends Signature> descriptor, DefaultClusteringAlgorithmImpl<VectorSignature> algo) throws SupportRegionException, SegmentationException {
        DefaultSegmentationAlgorithm segAlgo = new DefaultSegmentationAlgorithm(descriptor, algo);
        segAlgo.setLogEnabled(false);
        Segmentation seg = segAlgo.segment((Segmentable)img, regions);
        return seg;
    }
}

