/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.flies;

import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Cage;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.FlyPositions;
import plugins.fmp.multiSPOTS.tools.chart.ChartPositions;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;

public class PlotPositions
extends JPanel
implements SequenceListener {
    private static final long serialVersionUID = -7079184380174992501L;
    private ChartPositions ypositionsChart = null;
    private ChartPositions distanceChart = null;
    private ChartPositions aliveChart = null;
    private ChartPositions sleepChart = null;
    private MultiSPOTS parent0 = null;
    public JCheckBox moveCheckbox = new JCheckBox("y position", true);
    private JCheckBox distanceCheckbox = new JCheckBox("distance t/t+1", false);
    JCheckBox aliveCheckbox = new JCheckBox("fly alive", true);
    JCheckBox sleepCheckbox = new JCheckBox("sleep", false);
    JSpinner aliveThresholdSpinner = new JSpinner(new SpinnerNumberModel(50.0, 0.0, 100000.0, 0.1));
    public JButton displayResultsButton = new JButton("Display results");

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(2);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.moveCheckbox);
        panel1.add(this.distanceCheckbox);
        panel1.add(this.aliveCheckbox);
        panel1.add(this.sleepCheckbox);
        this.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(new JLabel("Alive threshold"));
        panel2.add(this.aliveThresholdSpinner);
        this.add(panel2);
        JPanel panel3 = new JPanel(flowLayout);
        panel3.add(this.displayResultsButton);
        this.add(panel3);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.displayResultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotPositions.this.displayGraphsPanels();
                PlotPositions.this.firePropertyChange("DISPLAY_RESULTS", false, true);
            }
        });
    }

    private void displayGraphsPanels() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        Rectangle rectv = exp.seqCamData.seq.getFirstViewer().getBounds();
        Point ptRelative = new Point(0, 30);
        int deltay = 230;
        exp.seqCamData.seq.addListener((SequenceListener)this);
        if (this.moveCheckbox.isSelected()) {
            this.displayYPos("flies Y positions", this.ypositionsChart, rectv, ptRelative, exp, EnumXLSExportType.XYTOPCAGE);
            ptRelative.y += 230;
        }
        if (this.distanceCheckbox.isSelected()) {
            this.displayYPos("distance between positions at t+1 and t", this.distanceChart, rectv, ptRelative, exp, EnumXLSExportType.DISTANCE);
            ptRelative.y += 230;
        }
        if (this.aliveCheckbox.isSelected()) {
            double threshold = (Double)this.aliveThresholdSpinner.getValue();
            for (Cage cage : exp.cages.cagesList) {
                FlyPositions posSeries = cage.flyPositions;
                posSeries.moveThreshold = threshold;
                posSeries.computeIsAlive();
            }
            this.displayYPos("flies alive", this.aliveChart, rectv, ptRelative, exp, EnumXLSExportType.ISALIVE);
            ptRelative.y += 230;
        }
        if (this.sleepCheckbox.isSelected()) {
            for (Cage cage : exp.cages.cagesList) {
                FlyPositions posSeries = cage.flyPositions;
                posSeries.computeSleep();
            }
            this.displayYPos("flies asleep", this.sleepChart, rectv, ptRelative, exp, EnumXLSExportType.SLEEP);
            ptRelative.y += 230;
        }
    }

    private void displayYPos(String title, ChartPositions iChart, Rectangle rectv, Point ptRelative, Experiment exp, EnumXLSExportType option) {
        if (iChart == null || !iChart.mainChartPanel.isValid()) {
            iChart = new ChartPositions();
            iChart.createPanel(title);
            iChart.setLocationRelativeToRectangle(rectv, ptRelative);
        }
        iChart.displayData(exp.cages.cagesList, option);
        iChart.mainChartFrame.toFront();
    }

    public void closeAllCharts() {
        this.close(this.ypositionsChart);
        this.close(this.distanceChart);
        this.close(this.aliveChart);
        this.close(this.sleepChart);
    }

    private void close(ChartPositions chart) {
        if (chart != null) {
            chart.mainChartFrame.close();
            chart = null;
        }
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
    }

    public void sequenceClosed(Sequence sequence) {
        sequence.removeListener((SequenceListener)this);
        this.closeAllCharts();
    }
}

