/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment;

import icy.image.IcyBufferedImage;
import icy.image.ImageUtil;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.util.XMLUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS.experiment.Cage;
import plugins.fmp.multiSPOTS.experiment.Cages;
import plugins.fmp.multiSPOTS.experiment.CapillariesArray;
import plugins.fmp.multiSPOTS.experiment.Capillary;
import plugins.fmp.multiSPOTS.experiment.ExperimentDirectories;
import plugins.fmp.multiSPOTS.experiment.ImageFileDescriptor;
import plugins.fmp.multiSPOTS.experiment.SequenceCamData;
import plugins.fmp.multiSPOTS.experiment.SequenceKymos;
import plugins.fmp.multiSPOTS.experiment.SequenceKymosUtils;
import plugins.fmp.multiSPOTS.experiment.Spot;
import plugins.fmp.multiSPOTS.experiment.SpotsArray;
import plugins.fmp.multiSPOTS.tools.Directories;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DUtilities;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSColumnHeader;

public class Experiment {
    public static final String RESULTS = "results";
    public static final String BIN = "bin_";
    private String imagesDirectory = null;
    private String resultsDirectory = null;
    private String binSubDirectory = null;
    public SequenceCamData seqCamData = null;
    public SequenceKymos seqSpotKymos = null;
    public Sequence seqReference = null;
    public CapillariesArray capillaries = new CapillariesArray();
    public SpotsArray spotsArray = new SpotsArray();
    public Cages cages = new Cages();
    public FileTime firstImage_FileTime;
    public FileTime lastImage_FileTime;
    private String field_boxID = new String("..");
    private String field_experiment = new String("..");
    private String field_comment1 = new String("..");
    private String field_comment2 = new String("..");
    private String field_strain = new String("..");
    private String field_sex = new String("..");
    private String field_cond1 = new String("..");
    private String field_cond2 = new String("..");
    public int col = -1;
    public Experiment chainToPreviousExperiment = null;
    public Experiment chainToNextExperiment = null;
    public long chainImageFirst_ms = 0L;
    public int experimentID = 0;
    private static final String ID_VERSION = "version";
    private static final String ID_VERSIONNUM = "1.0.0";
    private static final String ID_TIMEFIRSTIMAGE = "fileTimeImageFirstMinute";
    private static final String ID_TIMELASTIMAGE = "fileTimeImageLastMinute";
    private static final String ID_BINT0 = "indexBinT0";
    private static final String ID_FRAMEFIRST = "indexFrameFirst";
    private static final String ID_FRAMELAST = "indexFrameLast";
    private static final String ID_FRAMEDELTA = "indexFrameDelta";
    private static final String ID_TIMEFIRSTIMAGEMS = "fileTimeImageFirstMs";
    private static final String ID_TIMELASTIMAGEMS = "fileTimeImageLastMs";
    private static final String ID_FIRSTKYMOCOLMS = "firstKymoColMs";
    private static final String ID_LASTKYMOCOLMS = "lastKymoColMs";
    private static final String ID_BINKYMOCOLMS = "binKymoColMs";
    private static final String ID_IMAGESDIRECTORY = "imagesDirectory";
    private static final String ID_MCEXPERIMENT = "MCexperiment";
    private static final String ID_MCEXPERIMENT_XML = "MCexperiment.xml";
    private static final String ID_MCDROSOTRACK_XML = "MCdrosotrack.xml";
    private static final String ID_BOXID = "boxID";
    private static final String ID_EXPERIMENT = "experiment";
    private static final String ID_COMMENT1 = "comment";
    private static final String ID_COMMENT2 = "comment2";
    private static final String ID_STRAIN = "strain";
    private static final String ID_SEX = "sex";
    private static final String ID_COND1 = "cond1";
    private static final String ID_COND2 = "cond2";
    private static final int EXPT_DIRECTORY = 1;
    private static final int IMG_DIRECTORY = 2;
    private static final int BIN_DIRECTORY = 3;

    public Experiment() {
        this.seqCamData = new SequenceCamData();
        this.seqSpotKymos = new SequenceKymos();
    }

    public Experiment(String expDirectory) {
        this.seqCamData = new SequenceCamData();
        this.seqSpotKymos = new SequenceKymos();
        this.resultsDirectory = expDirectory;
    }

    public Experiment(SequenceCamData seqCamData) {
        this.seqCamData = seqCamData;
        this.seqSpotKymos = new SequenceKymos();
        this.resultsDirectory = this.seqCamData.getImagesDirectory() + File.separator + RESULTS;
        this.getFileIntervalsFromSeqCamData();
        this.xmlLoadExperiment(this.concatenateExptDirectoryWithSubpathAndName(null, ID_MCEXPERIMENT_XML));
    }

    public Experiment(ExperimentDirectories eADF) {
        this.imagesDirectory = eADF.cameraImagesDirectory;
        this.resultsDirectory = eADF.resultsDirectory;
        this.binSubDirectory = eADF.binSubDirectory;
        this.seqCamData = new SequenceCamData();
        String fileName = this.concatenateExptDirectoryWithSubpathAndName(null, ID_MCEXPERIMENT_XML);
        this.xmlLoadExperiment(fileName);
        this.seqCamData.camImagesDirectory = eADF.cameraImagesDirectory;
        this.seqCamData.loadImageList();
        if (eADF.cameraImagesList.size() > 1) {
            this.getFileIntervalsFromSeqCamData();
        }
        if (eADF.kymosImagesList != null && eADF.kymosImagesList.size() > 0) {
            this.seqSpotKymos = new SequenceKymos(eADF.kymosImagesList);
        }
    }

    public String getResultsDirectory() {
        return this.resultsDirectory;
    }

    public String toString() {
        return this.resultsDirectory;
    }

    public void setResultsDirectory(String fileName) {
        this.resultsDirectory = ExperimentDirectories.getParentIf(fileName, BIN);
    }

    public String getKymosBinFullDirectory() {
        String filename = this.resultsDirectory;
        if (this.binSubDirectory != null) {
            filename = filename + File.separator + this.binSubDirectory;
        }
        return filename;
    }

    public void setBinSubDirectory(String bin) {
        this.binSubDirectory = bin;
    }

    public String getBinSubDirectory() {
        return this.binSubDirectory;
    }

    public boolean createDirectoryIfDoesNotExist(String directory) {
        Path pathDir = Paths.get(directory, new String[0]);
        if (Files.notExists(pathDir, new LinkOption[0])) {
            try {
                Files.createDirectory(pathDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Experiment:createDirectoryIfDoesNotExist() Creating directory failed: " + directory);
                return false;
            }
        }
        return true;
    }

    public void checkKymosDirectory(String kymosSubDirectory) {
        if (kymosSubDirectory == null) {
            List<String> listTIFFlocations = Directories.getSortedListOfSubDirectoriesWithTIFF(this.getResultsDirectory());
            if (listTIFFlocations.size() < 1) {
                return;
            }
            boolean found = false;
            for (String subDir : listTIFFlocations) {
                String test = subDir.toLowerCase();
                if (test.contains(BIN)) {
                    kymosSubDirectory = subDir;
                    found = true;
                    break;
                }
                if (!test.contains(RESULTS)) continue;
                found = true;
                break;
            }
            if (!found) {
                int lowest = this.getBinStepFromDirectoryName(listTIFFlocations.get(0)) + 1;
                for (String subDir : listTIFFlocations) {
                    int val = this.getBinStepFromDirectoryName(subDir);
                    if (val >= lowest) continue;
                    lowest = val;
                    kymosSubDirectory = subDir;
                }
            }
        }
        this.setBinSubDirectory(kymosSubDirectory);
    }

    public void setCameraImagesDirectory(String name) {
        this.imagesDirectory = name;
    }

    public String getCameraImagesDirectory() {
        return this.imagesDirectory;
    }

    public void closeSequences() {
        if (this.seqSpotKymos != null) {
            this.seqSpotKymos.closeSequence();
        }
        if (this.seqCamData != null) {
            this.seqCamData.closeSequence();
        }
        if (this.seqReference != null) {
            this.seqReference.close();
        }
    }

    public boolean openCapillarieMeasures() {
        if (this.seqCamData == null) {
            this.seqCamData = new SequenceCamData();
        }
        this.loadXML_MCExperiment();
        this.getFileIntervalsFromSeqCamData();
        if (this.seqSpotKymos == null) {
            this.seqSpotKymos = new SequenceKymos();
        }
        this.loadMCCapillaries_Only();
        return this.capillaries.load_Measures(this.getKymosBinFullDirectory());
    }

    public boolean openPositionsMeasures() {
        if (this.seqCamData == null) {
            this.seqCamData = new SequenceCamData();
        }
        this.loadXML_MCExperiment();
        this.getFileIntervalsFromSeqCamData();
        if (this.seqSpotKymos == null) {
            this.seqSpotKymos = new SequenceKymos();
        }
        return this.xmlReadDrosoTrack(null);
    }

    public boolean openSpotsMeasures() {
        if (this.seqCamData == null) {
            this.seqCamData = new SequenceCamData();
        }
        this.loadXML_MCExperiment();
        this.getFileIntervalsFromSeqCamData();
        this.loadMCSpots_Only();
        return this.spotsArray.load_Measures(this.getKymosBinFullDirectory());
    }

    private String getRootWithNoResultNorBinString(String directoryName) {
        String name = directoryName.toLowerCase();
        while (name.contains(RESULTS) || name.contains(BIN)) {
            name = Paths.get(this.resultsDirectory, new String[0]).getParent().toString();
        }
        return name;
    }

    private SequenceCamData loadImagesForSequenceCamData(String filename) {
        this.imagesDirectory = ExperimentDirectories.getImagesDirectoryAsParentFromFileName(filename);
        List<String> imagesList = ExperimentDirectories.getImagesListFromPathV2(this.imagesDirectory, "jpg");
        this.seqCamData = null;
        if (imagesList.size() > 0) {
            this.seqCamData = new SequenceCamData();
            this.seqCamData.setImagesList(imagesList);
            this.seqCamData.attachSequence(this.seqCamData.loadSequenceFromImagesList(imagesList));
        }
        return this.seqCamData;
    }

    public boolean loadCamDataImages() {
        if (this.seqCamData != null) {
            this.seqCamData.loadImages();
        }
        return this.seqCamData != null && this.seqCamData.seq != null;
    }

    public boolean loadCamDataCapillaries() {
        if (this.capillaries.capillariesList.size() > 0) {
            for (Capillary cap : this.capillaries.capillariesList) {
                this.seqCamData.seq.removeROI((ROI)cap.getRoi());
            }
        }
        this.loadMCCapillaries_Only();
        if (this.seqCamData != null && this.seqCamData.seq != null) {
            this.capillaries.transferCapillaryRoiToSequence(this.seqCamData.seq);
        }
        return this.seqCamData != null && this.seqCamData.seq != null;
    }

    public boolean loadCamDataSpots() {
        this.loadMCSpots_Only();
        if (this.seqCamData != null && this.seqCamData.seq != null) {
            this.spotsArray.transferSpotRoiToSequence(this.seqCamData.seq);
        }
        return this.seqCamData != null && this.seqCamData.seq != null;
    }

    public boolean loadKymosImages() {
        if (this.seqSpotKymos != null) {
            this.seqSpotKymos.loadImages();
        }
        return this.seqSpotKymos != null && this.seqSpotKymos.seq != null;
    }

    public SequenceCamData openSequenceCamData() {
        this.loadImagesForSequenceCamData(this.imagesDirectory);
        if (this.seqCamData != null) {
            this.loadXML_MCExperiment();
            this.getFileIntervalsFromSeqCamData();
        }
        return this.seqCamData;
    }

    public void getFileIntervalsFromSeqCamData() {
        if (this.seqCamData != null && (this.seqCamData.firstImage_ms < 0L || this.seqCamData.lastImage_ms < 0L || this.seqCamData.binImage_ms < 0L)) {
            this.loadFileIntervalsFromSeqCamData();
        }
    }

    public void loadFileIntervalsFromSeqCamData() {
        if (this.seqCamData != null) {
            this.seqCamData.setImagesDirectory(this.imagesDirectory);
            this.firstImage_FileTime = this.seqCamData.getFileTimeFromStructuredName((int)this.seqCamData.indexFirstImage);
            this.lastImage_FileTime = this.seqCamData.getFileTimeFromStructuredName(this.seqCamData.nTotalFrames - 1);
            if (this.firstImage_FileTime != null && this.lastImage_FileTime != null) {
                this.seqCamData.firstImage_ms = this.firstImage_FileTime.toMillis();
                this.seqCamData.lastImage_ms = this.lastImage_FileTime.toMillis();
                if (this.seqCamData.nTotalFrames > 1) {
                    this.seqCamData.binImage_ms = (this.seqCamData.lastImage_ms - this.seqCamData.firstImage_ms) / (long)(this.seqCamData.nTotalFrames - 1);
                }
                if (this.seqCamData.binImage_ms == 0L) {
                    System.out.println("Experiment:loadFileIntervalsFromSeqCamData() error / file interval size");
                }
            } else {
                System.out.println("Experiment:loadFileIntervalsFromSeqCamData() error / file intervals of " + this.seqCamData.getImagesDirectory());
            }
        }
    }

    public long[] build_MsTimeIntervalsArray_From_SeqCamData_FileNamesList() {
        this.seqCamData.camImages_ms = new long[this.seqCamData.nTotalFrames];
        FileTime firstImage_FileTime = this.seqCamData.getFileTimeFromStructuredName(0);
        long firstImage_ms = firstImage_FileTime.toMillis();
        for (int i = 0; i < this.seqCamData.nTotalFrames; ++i) {
            long image_ms;
            FileTime image_FileTime = this.seqCamData.getFileTimeFromStructuredName(i);
            this.seqCamData.camImages_ms[i] = image_ms = image_FileTime.toMillis() - firstImage_ms;
        }
        return this.seqCamData.camImages_ms;
    }

    public int findNearestIntervalWithBinarySearch(long value, int low, int high) {
        int mid;
        int result = -1;
        result = high - low > 1 ? (this.seqCamData.camImages_ms[mid = (low + high) / 2] > value ? this.findNearestIntervalWithBinarySearch(value, low, mid) : (this.seqCamData.camImages_ms[mid] < value ? this.findNearestIntervalWithBinarySearch(value, mid, high) : mid)) : (Math.abs(value - this.seqCamData.camImages_ms[low]) < Math.abs(value - this.seqCamData.camImages_ms[high]) ? low : high);
        return result;
    }

    public int getClosestInterval(int icentral, long valueToCompare) {
        long deltacentral = Math.abs(valueToCompare - this.seqCamData.camImages_ms[icentral]);
        if (deltacentral == 0L) {
            return icentral;
        }
        int ilow = icentral - 1;
        int ihigh = icentral + 1;
        if (icentral <= 0) {
            ilow = 0;
            ihigh = 2;
        }
        if (icentral >= this.seqCamData.camImages_ms.length - 1) {
            ihigh = this.seqCamData.camImages_ms.length - 1;
            ilow = ihigh - 2;
        }
        long deltalow = Math.abs(valueToCompare - this.seqCamData.camImages_ms[ilow]);
        long deltahigh = Math.abs(valueToCompare - this.seqCamData.camImages_ms[ihigh]);
        int ismallest = icentral;
        long deltasmallest = deltacentral;
        if (deltalow <= deltasmallest) {
            ismallest = ilow;
            deltasmallest = deltalow;
        }
        if (deltahigh <= deltasmallest) {
            ismallest = ihigh;
        }
        return ismallest;
    }

    public String getBinNameFromKymoFrameStep() {
        return BIN + this.seqCamData.binDuration_ms / 1000L;
    }

    public String getDirectoryToSaveResults() {
        String directory;
        Path dir = Paths.get(this.resultsDirectory, new String[0]);
        if (this.binSubDirectory != null) {
            dir = dir.resolve(this.binSubDirectory);
        }
        if (!this.createDirectoryIfDoesNotExist(directory = dir.toAbsolutePath().toString())) {
            directory = null;
        }
        return directory;
    }

    public boolean loadXML_MCExperiment() {
        if (this.resultsDirectory == null && this.seqCamData != null) {
            this.imagesDirectory = this.seqCamData.getImagesDirectory();
            this.resultsDirectory = this.imagesDirectory + File.separator + RESULTS;
        }
        boolean found = this.xmlLoadExperiment(this.concatenateExptDirectoryWithSubpathAndName(null, ID_MCEXPERIMENT_XML));
        return found;
    }

    public boolean saveXML_MCExperiment() {
        Document doc = XMLUtil.createDocument((boolean)true);
        if (doc != null) {
            Element xmlRoot = XMLUtil.getRootElement((Document)doc, (boolean)true);
            Element node = XMLUtil.setElement((Node)xmlRoot, (String)ID_MCEXPERIMENT);
            if (node == null) {
                return false;
            }
            XMLUtil.setElementValue((Node)node, (String)ID_VERSION, (String)ID_VERSIONNUM);
            XMLUtil.setElementLongValue((Node)node, (String)ID_TIMEFIRSTIMAGEMS, (long)this.seqCamData.firstImage_ms);
            XMLUtil.setElementLongValue((Node)node, (String)ID_TIMELASTIMAGEMS, (long)this.seqCamData.lastImage_ms);
            XMLUtil.setElementLongValue((Node)node, (String)ID_FRAMEFIRST, (long)this.seqCamData.indexFirstImage);
            XMLUtil.setElementLongValue((Node)node, (String)ID_BINT0, (long)this.seqCamData.indexFirstImage);
            XMLUtil.setElementLongValue((Node)node, (String)ID_FRAMELAST, (long)this.seqCamData.indexLastImage);
            XMLUtil.setElementLongValue((Node)node, (String)ID_FRAMEDELTA, (long)this.seqCamData.deltaImage);
            XMLUtil.setElementLongValue((Node)node, (String)ID_FIRSTKYMOCOLMS, (long)this.seqCamData.binFirst_ms);
            XMLUtil.setElementLongValue((Node)node, (String)ID_LASTKYMOCOLMS, (long)this.seqCamData.binLast_ms);
            XMLUtil.setElementLongValue((Node)node, (String)ID_BINKYMOCOLMS, (long)this.seqCamData.binDuration_ms);
            XMLUtil.setElementValue((Node)node, (String)ID_BOXID, (String)this.field_boxID);
            XMLUtil.setElementValue((Node)node, (String)ID_EXPERIMENT, (String)this.field_experiment);
            XMLUtil.setElementValue((Node)node, (String)ID_COMMENT1, (String)this.field_comment1);
            XMLUtil.setElementValue((Node)node, (String)ID_COMMENT2, (String)this.field_comment2);
            XMLUtil.setElementValue((Node)node, (String)ID_STRAIN, (String)this.field_strain);
            XMLUtil.setElementValue((Node)node, (String)ID_SEX, (String)this.field_sex);
            XMLUtil.setElementValue((Node)node, (String)ID_COND1, (String)this.field_cond1);
            XMLUtil.setElementValue((Node)node, (String)ID_COND2, (String)this.field_cond2);
            if (this.imagesDirectory == null) {
                this.imagesDirectory = this.seqCamData.getImagesDirectory();
            }
            XMLUtil.setElementValue((Node)node, (String)ID_IMAGESDIRECTORY, (String)this.imagesDirectory);
            String tempname = this.concatenateExptDirectoryWithSubpathAndName(null, ID_MCEXPERIMENT_XML);
            return XMLUtil.saveDocument((Document)doc, (String)tempname);
        }
        return false;
    }

    public boolean loadKymographs() {
        if (this.seqSpotKymos == null) {
            this.seqSpotKymos = new SequenceKymos();
        }
        List<ImageFileDescriptor> myList = this.seqSpotKymos.loadListOfPotentialKymographsFromCapillaries(this.getKymosBinFullDirectory(), this.capillaries);
        ImageFileDescriptor.getExistingFileNames(myList);
        return this.seqSpotKymos.loadImagesFromList(myList, true);
    }

    public boolean loadMCCapillaries_Only() {
        String mcCapillaryFileName = this.findFile_3Locations(this.capillaries.getXMLCapillariesName(), 1, 3, 2);
        if (mcCapillaryFileName == null && this.seqCamData != null) {
            return this.xmlLoad_OldCapillaries();
        }
        boolean flag = this.capillaries.loadMCCapillaries_Descriptors(mcCapillaryFileName);
        if (this.capillaries.capillariesList.size() < 1) {
            flag = this.xmlLoad_OldCapillaries();
        }
        if (this.field_boxID.contentEquals("..") && this.field_experiment.contentEquals("..") && this.field_comment1.contentEquals("..") && this.field_comment2.contentEquals("..") && this.field_sex.contentEquals("..") && this.field_strain.contentEquals("..")) {
            this.field_boxID = this.capillaries.capillariesDescription.old_boxID;
            this.field_experiment = this.capillaries.capillariesDescription.old_experiment;
            this.field_comment1 = this.capillaries.capillariesDescription.old_comment1;
            this.field_comment2 = this.capillaries.capillariesDescription.old_comment2;
            this.field_sex = this.capillaries.capillariesDescription.old_sex;
            this.field_strain = this.capillaries.capillariesDescription.old_strain;
            this.field_cond1 = this.capillaries.capillariesDescription.old_cond1;
            this.field_cond2 = this.capillaries.capillariesDescription.old_cond2;
        }
        return flag;
    }

    public boolean loadMCSpots_Only() {
        String mcSpotsFileName = this.findFile_3Locations(this.spotsArray.getXMLSpotsName(), 1, 3, 2);
        if (mcSpotsFileName == null && this.seqCamData != null) {
            return false;
        }
        boolean flag = this.spotsArray.xmlLoad_MCSpots_Descriptors(mcSpotsFileName);
        if (this.field_boxID.contentEquals("..") && this.field_experiment.contentEquals("..") && this.field_comment1.contentEquals("..") && this.field_comment2.contentEquals("..") && this.field_sex.contentEquals("..") && this.field_strain.contentEquals("..")) {
            this.field_boxID = this.spotsArray.spotsDescription.old_boxID;
            this.field_experiment = this.spotsArray.spotsDescription.old_experiment;
            this.field_comment1 = this.spotsArray.spotsDescription.old_comment1;
            this.field_comment2 = this.spotsArray.spotsDescription.old_comment2;
            this.field_sex = this.spotsArray.spotsDescription.old_sex;
            this.field_strain = this.spotsArray.spotsDescription.old_strain;
            this.field_cond1 = this.spotsArray.spotsDescription.old_cond1;
            this.field_cond2 = this.spotsArray.spotsDescription.old_cond2;
        }
        return flag;
    }

    public boolean save_MCSpots_Only() {
        String mcSpotsFileName = this.resultsDirectory + File.separator + this.spotsArray.getXMLSpotsName();
        this.transferExpDescriptorsToSpotsDescriptors();
        boolean flag = this.spotsArray.xmlSave_MCSpots_Descriptors(mcSpotsFileName);
        return flag;
    }

    public boolean loadMCCapillaries() {
        String kymosImagesDirectory;
        boolean flag2;
        String xmlCapillariesFileName = this.findFile_3Locations(this.capillaries.getXMLCapillariesName(), 1, 3, 2);
        boolean flag1 = this.capillaries.loadMCCapillaries_Descriptors(xmlCapillariesFileName);
        if (flag1 & (flag2 = this.capillaries.load_Measures(kymosImagesDirectory = this.getKymosBinFullDirectory()))) {
            this.seqSpotKymos.loadListOfPotentialKymographsFromCapillaries(kymosImagesDirectory, this.capillaries);
        }
        return flag1 & flag2;
    }

    public boolean load_Spots() {
        boolean flag1 = this.loadMCSpots_Only();
        return flag1 & this.spotsArray.load_Spots(this.resultsDirectory);
    }

    public boolean save_Spots() {
        return this.spotsArray.save_Spots(this.resultsDirectory);
    }

    private boolean xmlLoad_OldCapillaries() {
        String filename = this.findFile_3Locations("capillarytrack.xml", 2, 1, 3);
        if (this.capillaries.xmlLoadOldCapillaries_Only(filename)) {
            this.xmlSave_MCCapillaries_Only();
            this.save_CapillariesMeasures();
            try {
                Files.delete(Paths.get(filename, new String[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        filename = this.findFile_3Locations("roislines.xml", 2, 1, 3);
        if (this.xmlLoad_CamDataROIs(filename)) {
            this.xmlLoad_RoiLineParameters(filename);
            try {
                Files.delete(Paths.get(filename, new String[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private boolean xmlLoad_CamDataROIs(String fileName) {
        Document doc;
        Sequence seq = this.seqCamData.seq;
        if (fileName != null && (doc = XMLUtil.loadDocument((String)fileName)) != null) {
            List seqRoisList = seq.getROI2Ds(false);
            List<ROI2D> newRoisList = ROI2DUtilities.loadROIsFromXML(doc);
            ROI2DUtilities.mergeROIsListNoDuplicate(seqRoisList, newRoisList, seq);
            seq.removeAllROI();
            seq.addROIs((Collection)seqRoisList, false);
            return true;
        }
        return false;
    }

    private boolean xmlLoad_RoiLineParameters(String filename) {
        Document doc;
        if (filename != null && (doc = XMLUtil.loadDocument((String)filename)) != null) {
            return this.capillaries.capillariesDescription.xmlLoadCapillaryDescription(doc);
        }
        return false;
    }

    public boolean xmlSave_MCCapillaries_Only() {
        String xmlCapillaryFileName = this.resultsDirectory + File.separator + this.capillaries.getXMLCapillariesName();
        this.transferExpDescriptorsToCapillariesDescriptors();
        return this.capillaries.xmlSaveCapillaries_Descriptors(xmlCapillaryFileName);
    }

    public boolean load_CapillariesMeasures() {
        return this.capillaries.load_Measures(this.getKymosBinFullDirectory());
    }

    public boolean save_CapillariesMeasures() {
        return this.capillaries.save_Measures(this.getKymosBinFullDirectory());
    }

    public boolean load_SpotsMeasures() {
        return this.spotsArray.load_Measures(this.getResultsDirectory());
    }

    public boolean save_SpotsMeasures() {
        return this.spotsArray.save_Measures(this.getResultsDirectory());
    }

    public boolean load_CagesMeasures() {
        return this.xmlReadDrosoTrack(null);
    }

    public boolean save_CagesMeasures() {
        return this.cages.saveCagesMeasures(this.getResultsDirectory());
    }

    public Experiment getFirstChainedExperiment(boolean globalValue) {
        Experiment exp = this;
        if (globalValue && this.chainToPreviousExperiment != null) {
            exp = this.chainToPreviousExperiment.getFirstChainedExperiment(globalValue);
        }
        return exp;
    }

    public Experiment getLastChainedExperiment(boolean globalValue) {
        Experiment exp = this;
        if (globalValue && this.chainToNextExperiment != null) {
            exp = this.chainToNextExperiment.getLastChainedExperiment(globalValue);
        }
        return exp;
    }

    public void setFileTimeImageFirst(FileTime fileTimeImageFirst) {
        this.firstImage_FileTime = fileTimeImageFirst;
    }

    public void setFileTimeImageLast(FileTime fileTimeImageLast) {
        this.lastImage_FileTime = fileTimeImageLast;
    }

    public int getSeqCamSizeT() {
        int lastFrame = 0;
        if (this.seqCamData != null) {
            lastFrame = this.seqCamData.nTotalFrames - 1;
        }
        return lastFrame;
    }

    public String getExperimentField(EnumXLSColumnHeader fieldEnumCode) {
        String strField = null;
        switch (fieldEnumCode) {
            case EXP_STIM: {
                strField = this.field_comment1;
                break;
            }
            case EXP_CONC: {
                strField = this.field_comment2;
                break;
            }
            case EXP_EXPT: {
                strField = this.field_experiment;
                break;
            }
            case EXP_BOXID: {
                strField = this.field_boxID;
                break;
            }
            case EXP_STRAIN: {
                strField = this.field_strain;
                break;
            }
            case EXP_SEX: {
                strField = this.field_sex;
                break;
            }
            case EXP_COND1: {
                strField = this.field_cond1;
                break;
            }
            case EXP_COND2: {
                strField = this.field_cond2;
                break;
            }
        }
        return strField;
    }

    public void getFieldValues(EnumXLSColumnHeader fieldEnumCode, List<String> textList) {
        switch (fieldEnumCode) {
            case EXP_STIM: 
            case EXP_CONC: 
            case EXP_EXPT: 
            case EXP_BOXID: 
            case EXP_STRAIN: 
            case EXP_SEX: 
            case EXP_COND1: 
            case EXP_COND2: {
                this.addValue(this.getExperimentField(fieldEnumCode), textList);
                break;
            }
            case CAP_STIM: 
            case CAP_CONC: {
                this.addSpotsValues(fieldEnumCode, textList);
                break;
            }
        }
    }

    public boolean replaceExperimentFieldIfEqualOld(EnumXLSColumnHeader fieldEnumCode, String oldValue, String newValue) {
        boolean flag = this.getExperimentField(fieldEnumCode).equals(oldValue);
        if (flag) {
            this.setExperimentFieldNoTest(fieldEnumCode, newValue);
        }
        return flag;
    }

    public void copyExperimentFields(Experiment expSource) {
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_BOXID, expSource.getExperimentField(EnumXLSColumnHeader.EXP_BOXID));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_EXPT, expSource.getExperimentField(EnumXLSColumnHeader.EXP_EXPT));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_STIM, expSource.getExperimentField(EnumXLSColumnHeader.EXP_STIM));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_CONC, expSource.getExperimentField(EnumXLSColumnHeader.EXP_CONC));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_STRAIN, expSource.getExperimentField(EnumXLSColumnHeader.EXP_STRAIN));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_SEX, expSource.getExperimentField(EnumXLSColumnHeader.EXP_SEX));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_COND1, expSource.getExperimentField(EnumXLSColumnHeader.EXP_COND1));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_COND2, expSource.getExperimentField(EnumXLSColumnHeader.EXP_COND2));
    }

    public void setExperimentFieldNoTest(EnumXLSColumnHeader fieldEnumCode, String newValue) {
        switch (fieldEnumCode) {
            case EXP_STIM: {
                this.field_comment1 = newValue;
                break;
            }
            case EXP_CONC: {
                this.field_comment2 = newValue;
                break;
            }
            case EXP_EXPT: {
                this.field_experiment = newValue;
                break;
            }
            case EXP_BOXID: {
                this.field_boxID = newValue;
                break;
            }
            case EXP_STRAIN: {
                this.field_strain = newValue;
                break;
            }
            case EXP_SEX: {
                this.field_sex = newValue;
                break;
            }
            case EXP_COND1: {
                this.field_cond1 = newValue;
                break;
            }
            case EXP_COND2: {
                this.field_cond2 = newValue;
                break;
            }
        }
    }

    public void replaceFieldValue(EnumXLSColumnHeader fieldEnumCode, String oldValue, String newValue) {
        switch (fieldEnumCode) {
            case EXP_STIM: 
            case EXP_CONC: 
            case EXP_EXPT: 
            case EXP_BOXID: 
            case EXP_STRAIN: 
            case EXP_SEX: 
            case EXP_COND1: 
            case EXP_COND2: {
                this.replaceExperimentFieldIfEqualOld(fieldEnumCode, oldValue, newValue);
                break;
            }
            case CAP_STIM: 
            case CAP_CONC: {
                if (this.replaceCapillariesValuesIfEqualOld(fieldEnumCode, oldValue, newValue)) {
                    // empty if block
                }
                this.xmlSave_MCCapillaries_Only();
                if (this.replaceSpotsValuesIfEqualOld(fieldEnumCode, oldValue, newValue)) {
                    // empty if block
                }
                this.save_MCSpots_Only();
                break;
            }
        }
    }

    public void kymosBuildFiltered01(int zChannelSource, int zChannelDestination, ImageTransformEnums transformop1, int spanDiff) {
        int nimages = this.seqSpotKymos.seq.getSizeT();
        this.seqSpotKymos.seq.beginUpdate();
        ImageTransformInterface transform = transformop1.getFunction();
        if (transform == null) {
            return;
        }
        if (this.capillaries.capillariesList.size() != nimages) {
            SequenceKymosUtils.transferCamDataROIStoKymo(this);
        }
        for (int t = 0; t < nimages; ++t) {
            Capillary cap = this.capillaries.capillariesList.get(t);
            cap.kymographIndex = t;
            IcyBufferedImage img = this.seqSpotKymos.getSeqImage(t, zChannelSource);
            IcyBufferedImage img2 = transform.getTransformedImage(img, null);
            if (this.seqSpotKymos.seq.getSizeZ(0) < zChannelDestination + 1) {
                this.seqSpotKymos.seq.addImage(t, (BufferedImage)img2);
                continue;
            }
            this.seqSpotKymos.seq.setImage(t, zChannelDestination, (BufferedImage)img2);
        }
        this.seqSpotKymos.seq.dataChanged();
        this.seqSpotKymos.seq.endUpdate();
    }

    public boolean loadReferenceImage() {
        BufferedImage image = null;
        File inputfile = new File(this.getReferenceImageFullName());
        boolean exists = inputfile.exists();
        if (!exists) {
            return false;
        }
        image = ImageUtil.load((File)inputfile, (boolean)true);
        if (image == null) {
            System.out.println("Experiment:loadReferenceImage() image not loaded / not found");
            return false;
        }
        this.seqCamData.refImage = IcyBufferedImage.createFrom((BufferedImage)image);
        this.seqReference = new Sequence(this.seqCamData.refImage);
        this.seqReference.setName("referenceImage");
        return true;
    }

    public boolean saveReferenceImage(IcyBufferedImage referenceImage) {
        File outputfile = new File(this.getReferenceImageFullName());
        BufferedImage image = ImageUtil.toRGBImage((Image)referenceImage);
        return ImageUtil.save((RenderedImage)image, (String)"jpg", (File)outputfile);
    }

    public void cleanPreviousDetectedFliesROIs() {
        ArrayList list = this.seqCamData.seq.getROI2Ds();
        for (ROI2D roi : list) {
            if (!roi.getName().contains("det")) continue;
            this.seqCamData.seq.removeROI((ROI)roi);
        }
    }

    public String getMCDrosoTrackFullName() {
        return this.resultsDirectory + File.separator + ID_MCDROSOTRACK_XML;
    }

    public void updateROIsAt(int t) {
        this.seqCamData.seq.beginUpdate();
        ArrayList rois = this.seqCamData.seq.getROI2Ds();
        for (ROI2D roi : rois) {
            if (!roi.getName().contains("det")) continue;
            this.seqCamData.seq.removeROI((ROI)roi);
        }
        this.seqCamData.seq.addROIs(this.cages.getPositionsAsListOfROI2DRectanglesAtT(t), false);
        this.seqCamData.seq.endUpdate();
    }

    public void saveDetRoisToPositions() {
        ArrayList detectedROIsList = this.seqCamData.seq.getROI2Ds();
        for (Cage cage : this.cages.cagesList) {
            cage.transferRoisToPositions(detectedROIsList);
        }
    }

    private int getBinStepFromDirectoryName(String resultsPath) {
        int step = -1;
        if (resultsPath.contains(BIN)) {
            step = resultsPath.length() < BIN.length() + 1 ? (int)this.seqCamData.binDuration_ms : Integer.valueOf(resultsPath.substring(BIN.length())) * 1000;
        }
        return step;
    }

    private boolean xmlReadDrosoTrack(String filename) {
        if (filename == null && (filename = this.getXMLDrosoTrackLocation()) == null) {
            return false;
        }
        return this.cages.xmlReadCagesFromFileNoQuestion(filename, this);
    }

    private String findFile_3Locations(String xmlFileName, int first, int second, int third) {
        String xmlFullFileName = this.findFile_1Location(xmlFileName, first);
        if (xmlFullFileName == null) {
            xmlFullFileName = this.findFile_1Location(xmlFileName, second);
        }
        if (xmlFullFileName == null) {
            xmlFullFileName = this.findFile_1Location(xmlFileName, third);
        }
        return xmlFullFileName;
    }

    private String findFile_1Location(String xmlFileName, int item) {
        String xmlFullFileName = File.separator + xmlFileName;
        block0 : switch (item) {
            case 2: {
                this.imagesDirectory = this.getRootWithNoResultNorBinString(this.resultsDirectory);
                xmlFullFileName = this.imagesDirectory + File.separator + xmlFileName;
                break;
            }
            case 3: {
                Path dirPath = Paths.get(this.resultsDirectory, new String[0]);
                List<Path> subFolders = Directories.getAllSubPathsOfDirectory(this.resultsDirectory, 1);
                if (subFolders == null) {
                    return null;
                }
                List<String> resultsDirList = Directories.getPathsContainingString(subFolders, RESULTS);
                List<String> binDirList = Directories.getPathsContainingString(subFolders, BIN);
                resultsDirList.addAll(binDirList);
                for (String resultsSub : resultsDirList) {
                    Path dir = dirPath.resolve(resultsSub + File.separator + xmlFileName);
                    if (Files.notExists(dir, new LinkOption[0])) continue;
                    xmlFullFileName = dir.toAbsolutePath().toString();
                    break block0;
                }
                break;
            }
            default: {
                xmlFullFileName = this.resultsDirectory + xmlFullFileName;
            }
        }
        if (xmlFullFileName != null && this.fileExists(xmlFullFileName)) {
            if (item == 2) {
                this.imagesDirectory = this.getRootWithNoResultNorBinString(this.resultsDirectory);
                ExperimentDirectories.moveAndRename(xmlFileName, this.imagesDirectory, xmlFileName, this.resultsDirectory);
                xmlFullFileName = this.resultsDirectory + xmlFullFileName;
            }
            return xmlFullFileName;
        }
        return null;
    }

    private boolean fileExists(String fileName) {
        File f = new File(fileName);
        return f.exists() && !f.isDirectory();
    }

    private boolean replaceCapillariesValuesIfEqualOld(EnumXLSColumnHeader fieldEnumCode, String oldValue, String newValue) {
        if (this.capillaries.capillariesList.size() == 0) {
            this.loadMCCapillaries_Only();
        }
        boolean flag = false;
        for (Capillary cap : this.capillaries.capillariesList) {
            if (!cap.getCapillaryField(fieldEnumCode).equals(oldValue)) continue;
            cap.setCapillaryField(fieldEnumCode, newValue);
            flag = true;
        }
        return flag;
    }

    private boolean replaceSpotsValuesIfEqualOld(EnumXLSColumnHeader fieldEnumCode, String oldValue, String newValue) {
        if (this.spotsArray.spotsList.size() == 0) {
            this.loadMCSpots_Only();
        }
        boolean flag = false;
        for (Spot spot : this.spotsArray.spotsList) {
            if (!spot.getSpotField(fieldEnumCode).equals(oldValue)) continue;
            spot.setSpotField(fieldEnumCode, newValue);
            flag = true;
        }
        return flag;
    }

    private String concatenateExptDirectoryWithSubpathAndName(String subpath, String name) {
        if (subpath != null) {
            return this.resultsDirectory + File.separator + subpath + File.separator + name;
        }
        return this.resultsDirectory + File.separator + name;
    }

    private boolean xmlLoadExperiment(String csFileName) {
        Document doc = XMLUtil.loadDocument((String)csFileName);
        if (doc == null) {
            return false;
        }
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)ID_MCEXPERIMENT);
        if (node == null) {
            return false;
        }
        String version = XMLUtil.getElementValue((Node)node, (String)ID_VERSION, (String)ID_VERSIONNUM);
        if (!version.equals(ID_VERSIONNUM)) {
            return false;
        }
        this.seqCamData.firstImage_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_TIMEFIRSTIMAGEMS, (long)0L);
        this.seqCamData.lastImage_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_TIMELASTIMAGEMS, (long)0L);
        if (this.seqCamData.lastImage_ms <= 0L) {
            this.seqCamData.firstImage_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_TIMEFIRSTIMAGE, (long)0L) * 60000L;
            this.seqCamData.lastImage_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_TIMELASTIMAGE, (long)0L) * 60000L;
        }
        this.seqCamData.indexFirstImage = XMLUtil.getElementLongValue((Node)node, (String)ID_FRAMEFIRST, (long)-1L);
        if (this.seqCamData.indexFirstImage < 0L) {
            this.seqCamData.indexFirstImage = XMLUtil.getElementLongValue((Node)node, (String)ID_BINT0, (long)-1L);
        }
        if (this.seqCamData.indexFirstImage < 0L) {
            this.seqCamData.indexFirstImage = 0L;
        }
        this.seqCamData.indexLastImage = XMLUtil.getElementLongValue((Node)node, (String)ID_FRAMELAST, (long)-1L);
        this.seqCamData.deltaImage = XMLUtil.getElementLongValue((Node)node, (String)ID_FRAMEDELTA, (long)1L);
        this.seqCamData.binFirst_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_FIRSTKYMOCOLMS, (long)-1L);
        this.seqCamData.binLast_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_LASTKYMOCOLMS, (long)-1L);
        this.seqCamData.binDuration_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_BINKYMOCOLMS, (long)-1L);
        this.ugly_checkOffsetValues();
        if (this.field_boxID != null && this.field_boxID.contentEquals("..")) {
            this.field_boxID = XMLUtil.getElementValue((Node)node, (String)ID_BOXID, (String)"..");
            this.field_experiment = XMLUtil.getElementValue((Node)node, (String)ID_EXPERIMENT, (String)"..");
            this.field_comment1 = XMLUtil.getElementValue((Node)node, (String)ID_COMMENT1, (String)"..");
            this.field_comment2 = XMLUtil.getElementValue((Node)node, (String)ID_COMMENT2, (String)"..");
            this.field_strain = XMLUtil.getElementValue((Node)node, (String)ID_STRAIN, (String)"..");
            this.field_sex = XMLUtil.getElementValue((Node)node, (String)ID_SEX, (String)"..");
            this.field_cond1 = XMLUtil.getElementValue((Node)node, (String)ID_COND1, (String)"..");
            this.field_cond2 = XMLUtil.getElementValue((Node)node, (String)ID_COND2, (String)"..");
        }
        return true;
    }

    private void ugly_checkOffsetValues() {
        if (this.seqCamData.firstImage_ms < 0L) {
            this.seqCamData.firstImage_ms = 0L;
        }
        if (this.seqCamData.lastImage_ms < 0L) {
            this.seqCamData.lastImage_ms = 0L;
        }
        if (this.seqCamData.binFirst_ms < 0L) {
            this.seqCamData.binFirst_ms = 0L;
        }
        if (this.seqCamData.binLast_ms < 0L) {
            this.seqCamData.binLast_ms = 0L;
        }
        if (this.seqCamData.binDuration_ms < 0L) {
            this.seqCamData.binDuration_ms = 60000L;
        }
    }

    private void addSpotsValues(EnumXLSColumnHeader fieldEnumCode, List<String> textList) {
        if (this.spotsArray.spotsList.size() == 0) {
            this.loadMCSpots_Only();
        }
        for (Spot spot : this.spotsArray.spotsList) {
            this.addValue(spot.getSpotField(fieldEnumCode), textList);
        }
    }

    private void addValue(String text, List<String> textList) {
        if (!this.isFound(text, textList)) {
            textList.add(text);
        }
    }

    private boolean isFound(String pattern, List<String> names) {
        boolean found;
        block1: {
            String name;
            found = false;
            if (names.size() <= 0) break block1;
            Iterator<String> iterator = names.iterator();
            while (iterator.hasNext() && !(found = (name = iterator.next()).equals(pattern))) {
            }
        }
        return found;
    }

    private void transferExpDescriptorsToCapillariesDescriptors() {
        this.capillaries.capillariesDescription.old_boxID = this.field_boxID;
        this.capillaries.capillariesDescription.old_experiment = this.field_experiment;
        this.capillaries.capillariesDescription.old_comment1 = this.field_comment1;
        this.capillaries.capillariesDescription.old_comment2 = this.field_comment2;
        this.capillaries.capillariesDescription.old_strain = this.field_strain;
        this.capillaries.capillariesDescription.old_sex = this.field_sex;
        this.capillaries.capillariesDescription.old_cond1 = this.field_cond1;
        this.capillaries.capillariesDescription.old_cond2 = this.field_cond2;
    }

    private void transferExpDescriptorsToSpotsDescriptors() {
        this.spotsArray.spotsDescription.old_boxID = this.field_boxID;
        this.spotsArray.spotsDescription.old_experiment = this.field_experiment;
        this.spotsArray.spotsDescription.old_comment1 = this.field_comment1;
        this.spotsArray.spotsDescription.old_comment2 = this.field_comment2;
        this.spotsArray.spotsDescription.old_strain = this.field_strain;
        this.spotsArray.spotsDescription.old_sex = this.field_sex;
        this.spotsArray.spotsDescription.old_cond1 = this.field_cond1;
        this.spotsArray.spotsDescription.old_cond2 = this.field_cond2;
    }

    private String getReferenceImageFullName() {
        return this.resultsDirectory + File.separator + "referenceImage.jpg";
    }

    private String getXMLDrosoTrackLocation() {
        String fileName = this.findFile_3Locations(ID_MCDROSOTRACK_XML, 1, 3, 2);
        if (fileName == null) {
            fileName = this.findFile_3Locations("drosotrack.xml", 2, 1, 3);
        }
        return fileName;
    }
}

