/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.series;

import java.util.ArrayList;
import plugins.fmp.multiSPOTS.experiment.Capillary;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.SequenceKymos;
import plugins.fmp.multiSPOTS.series.BuildSeries;

public class ClipCagesMeasuresToSmallest
extends BuildSeries {
    @Override
    void analyzeExperiment(Experiment exp) {
        exp.loadXML_MCExperiment();
        exp.loadMCCapillaries();
        if (exp.loadKymographs()) {
            SequenceKymos seqKymos = exp.seqSpotKymos;
            ArrayList<Integer> listCageID = new ArrayList<Integer>(seqKymos.nTotalFrames);
            for (int t = 0; t < seqKymos.nTotalFrames; ++t) {
                Capillary tcap = exp.capillaries.capillariesList.get(t);
                int tcage = tcap.cageID;
                if (this.findCageID(tcage, listCageID)) continue;
                listCageID.add(tcage);
                int minLength = this.findMinLength(exp, t, tcage);
                for (int tt = t; tt < seqKymos.nTotalFrames; ++tt) {
                    Capillary ttcap = exp.capillaries.capillariesList.get(tt);
                    int ttcage = ttcap.cageID;
                    if (ttcage != tcage || ttcap.ptsTop.polylineLevel.npoints <= minLength) continue;
                    ttcap.cropMeasuresToNPoints(minLength);
                }
            }
            exp.save_CapillariesMeasures();
        }
        exp.seqCamData.closeSequence();
        exp.seqSpotKymos.closeSequence();
    }

    boolean findCageID(int cageID, ArrayList<Integer> listCageID) {
        boolean found = false;
        for (int iID : listCageID) {
            if (iID != cageID) continue;
            found = true;
            break;
        }
        return found;
    }

    private int findMinLength(Experiment exp, int t, int tcage) {
        Capillary tcap = exp.capillaries.capillariesList.get(t);
        int minLength = tcap.ptsTop.polylineLevel.npoints;
        for (int tt = t; tt < exp.capillaries.capillariesList.size(); ++tt) {
            int dataLength;
            Capillary ttcap = exp.capillaries.capillariesList.get(tt);
            int ttcage = ttcap.cageID;
            if (ttcage != tcage || (dataLength = ttcap.ptsTop.polylineLevel.npoints) >= minLength) continue;
            minLength = dataLength;
        }
        return minLength;
    }
}

