/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.cages;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.dlg.cages.InfosTable;
import plugins.fmp.multiSPOTS.experiment.Cage;
import plugins.fmp.multiSPOTS.experiment.Experiment;

public class Infos
extends JPanel {
    private static final long serialVersionUID = -3325915033686366985L;
    private JButton editCagesButton = new JButton("Edit cages infos...");
    private MultiSPOTS parent0 = null;
    private InfosTable dialog = null;
    private List<Cage> cagesArrayCopy = new ArrayList<Cage>();
    JRadioButton useCages = new JRadioButton("cages");
    JRadioButton useManual = new JRadioButton("manual entry");
    ButtonGroup useGroup = new ButtonGroup();
    private JSpinner lengthSpinner = new JSpinner(new SpinnerNumberModel(78.0, 0.0, 100.0, 1.0));
    private JSpinner pixelsSpinner = new JSpinner(new SpinnerNumberModel(5, 0, 1000, 1));
    String measureString = "get span between 1rst and last cage";
    private JButton measureButton = new JButton(this.measureString);

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel0a = new JPanel(flowLayout);
        panel0a.add(this.useManual);
        panel0a.add(this.useCages);
        panel0a.add(this.measureButton);
        this.add(panel0a);
        this.useGroup.add(this.useCages);
        this.useGroup.add(this.useManual);
        this.useCages.setSelected(true);
        JPanel panel00 = new JPanel(flowLayout);
        panel00.add(new JLabel("length in mm:", 4));
        panel00.add(this.lengthSpinner);
        panel00.add(new JLabel("length in pixels:", 4));
        panel00.add(this.pixelsSpinner);
        this.add(panel00);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.editCagesButton);
        this.add(panel1);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.editCagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Infos)Infos.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.spotsArray.transferDescriptionToSpots();
                    exp.cages.transferNFliesFromSpotsToCages(exp.spotsArray.spotsList);
                    Infos.this.dialog = new InfosTable();
                    Infos.this.dialog.initialize(Infos.this.parent0, Infos.this.cagesArrayCopy);
                }
            }
        });
        this.useCages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Infos.this.lengthSpinner.setValue(78.0);
                Infos.this.measureButton.setText(Infos.this.measureString);
                Infos.this.measureButton.setVisible(true);
            }
        });
        this.useManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Infos.this.measureButton.setVisible(false);
            }
        });
        this.measureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Infos.this.measureCagesSpan();
            }
        });
    }

    void measureCagesSpan() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            int npixels;
            exp.spotsArray.updateSpotsFromSequence(exp.seqCamData.seq);
            if (exp.spotsArray.spotsList.size() > 0 && (npixels = exp.cages.getHorizontalSpanOfCages()) > 0) {
                this.pixelsSpinner.setValue(npixels);
            }
        }
    }
}

