/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.excel;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multiSPOTS.tools.JComponents.JComboBoxMs;

public class Options
extends JPanel {
    private static final long serialVersionUID = 1814896922714679663L;
    JCheckBox exportAllFilesCheckBox = new JCheckBox("all experiments", true);
    JCheckBox transposeCheckBox = new JCheckBox("transpose", true);
    public JCheckBox collateSeriesCheckBox = new JCheckBox("collate series", false);
    JCheckBox padIntervalsCheckBox = new JCheckBox("pad intervals", false);
    JCheckBox onlyAliveCheckBox = new JCheckBox("dead=empty", false);
    JSpinner binSize = new JSpinner(new SpinnerNumberModel(1.0, 1.0, 1000.0, 1.0));
    JComboBoxMs binUnit = new JComboBoxMs();
    JRadioButton isFloatingFrameButton = new JRadioButton("all", true);
    JRadioButton isFixedFrameButton = new JRadioButton("from ", false);
    JSpinner startJSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 10000.0, 1.0));
    JSpinner endJSpinner = new JSpinner(new SpinnerNumberModel(240.0, 1.0, 9.9999999E7, 1.0));
    JComboBoxMs intervalsUnit = new JComboBoxMs();

    void init(GridLayout capLayout) {
        this.setLayout(capLayout);
        FlowLayout layout1 = new FlowLayout(0);
        layout1.setVgap(0);
        JPanel panel0 = new JPanel(layout1);
        panel0.add(this.exportAllFilesCheckBox);
        panel0.add(this.transposeCheckBox);
        panel0.add(this.collateSeriesCheckBox);
        panel0.add(this.padIntervalsCheckBox);
        panel0.add(this.onlyAliveCheckBox);
        this.add(panel0);
        this.padIntervalsCheckBox.setEnabled(false);
        JPanel panel1 = new JPanel(layout1);
        panel1.add(new JLabel("Analyze "));
        panel1.add(this.isFloatingFrameButton);
        panel1.add(this.isFixedFrameButton);
        panel1.add(this.startJSpinner);
        panel1.add(new JLabel(" to "));
        panel1.add(this.endJSpinner);
        panel1.add(this.intervalsUnit);
        this.intervalsUnit.setSelectedIndex(2);
        this.add(panel1);
        JPanel panel2 = new JPanel(layout1);
        panel2.add(new JLabel("bin size "));
        panel2.add(this.binSize);
        panel2.add(this.binUnit);
        this.binUnit.setSelectedIndex(2);
        this.add(panel2);
        this.enableIntervalButtons(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.isFloatingFrameButton);
        group.add(this.isFixedFrameButton);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.collateSeriesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JCheckBox cb = (JCheckBox)event.getSource();
                boolean isSelected = cb.isSelected();
                Options.this.padIntervalsCheckBox.setEnabled(isSelected);
            }
        });
        this.isFixedFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Options.this.enableIntervalButtons(true);
            }
        });
        this.isFloatingFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Options.this.enableIntervalButtons(false);
            }
        });
    }

    private void enableIntervalButtons(boolean isSelected) {
        this.startJSpinner.setEnabled(isSelected);
        this.endJSpinner.setEnabled(isSelected);
        this.intervalsUnit.setEnabled(isSelected);
    }

    int getExcelBuildStep() {
        double binValue = (Double)this.binSize.getValue();
        double buildStep = binValue * (double)this.binUnit.getMsUnitValue();
        return (int)buildStep;
    }

    long getStartAllMs() {
        long startAll = (long)((Double)this.startJSpinner.getValue() * (double)this.intervalsUnit.getMsUnitValue());
        return startAll;
    }

    long getEndAllMs() {
        long endAll = (long)((Double)this.endJSpinner.getValue() * (double)this.intervalsUnit.getMsUnitValue());
        return endAll;
    }

    public boolean getIsFixedFrame() {
        return this.isFixedFrameButton.isSelected();
    }

    public long getStartMs() {
        return (long)((Double)this.startJSpinner.getValue() * (double)this.binUnit.getMsUnitValue());
    }

    public long getEndMs() {
        return (long)((Double)this.endJSpinner.getValue() * (double)this.binUnit.getMsUnitValue());
    }

    public long getBinMs() {
        return (long)((Double)this.binSize.getValue() * (double)this.binUnit.getMsUnitValue());
    }
}

