/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spotsMeasures;

import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.Spot;
import plugins.fmp.multiSPOTS.tools.chart.ChartSpots;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExportOptions;

public class SpotsMeasuresGraphs
extends JPanel
implements SequenceListener {
    private static final long serialVersionUID = -7079184380174992501L;
    private ChartSpots plotAreaPixels = null;
    private MultiSPOTS parent0 = null;
    private JButton displayResultsButton = new JButton("Display results");
    private EnumXLSExportType[] measures = new EnumXLSExportType[]{EnumXLSExportType.AREA_SUM, EnumXLSExportType.AREA_SUMCLEAN};
    private JComboBox<EnumXLSExportType> exportTypeComboBox = new JComboBox<EnumXLSExportType>(this.measures);
    private JCheckBox relativeToCheckbox = new JCheckBox("relative to t0", false);
    private JRadioButton displayAllButton = new JRadioButton("all cages");
    private JRadioButton displaySelectedButton = new JRadioButton("cage selected");

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        this.setLayout(capLayout);
        FlowLayout layout = new FlowLayout(0);
        layout.setVgap(0);
        JPanel panel01 = new JPanel(layout);
        panel01.add(new JLabel("Measure"));
        panel01.add(this.exportTypeComboBox);
        panel01.add(new JLabel(" display"));
        panel01.add(this.displayAllButton);
        panel01.add(this.displaySelectedButton);
        this.add(panel01);
        JPanel panel02 = new JPanel(layout);
        panel02.add(this.relativeToCheckbox);
        this.add(panel02);
        JPanel panel03 = new JPanel(layout);
        panel03.add(this.displayResultsButton);
        this.add(panel03);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.displayAllButton);
        group1.add(this.displaySelectedButton);
        this.displayAllButton.setSelected(true);
        this.exportTypeComboBox.setSelectedIndex(1);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.exportTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotsMeasuresGraphs)SpotsMeasuresGraphs.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotsMeasuresGraphs.this.displayGraphsPanels(exp);
                }
            }
        });
        this.displayResultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotsMeasuresGraphs)SpotsMeasuresGraphs.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotsMeasuresGraphs.this.displayGraphsPanels(exp);
                }
            }
        });
        this.relativeToCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotsMeasuresGraphs)SpotsMeasuresGraphs.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotsMeasuresGraphs.this.displayGraphsPanels(exp);
                }
            }
        });
    }

    private Rectangle getInitialUpperLeftPosition(Experiment exp) {
        Rectangle rectv = new Rectangle(50, 500, 10, 10);
        Viewer v = exp.seqCamData.seq.getFirstViewer();
        if (v != null) {
            rectv = v.getBounds();
            rectv.translate(0, rectv.height);
        } else {
            rectv = this.parent0.mainFrame.getBounds();
            rectv.translate(rectv.width, rectv.height + 100);
        }
        return rectv;
    }

    public void displayGraphsPanels(Experiment exp) {
        Rectangle rectv = this.getInitialUpperLeftPosition(exp);
        int dx = 5;
        int dy = 10;
        exp.seqCamData.seq.addListener((SequenceListener)this);
        EnumXLSExportType exportType = (EnumXLSExportType)((Object)this.exportTypeComboBox.getSelectedItem());
        if (this.isThereAnyDataToDisplay(exp, exportType)) {
            rectv.translate(dx, dy);
            this.plotAreaPixels = this.plotToChart(exp, exportType, this.plotAreaPixels, rectv);
        }
    }

    private ChartSpots plotToChart(Experiment exp, EnumXLSExportType exportType, ChartSpots iChart, Rectangle rectv) {
        boolean bRelative;
        if (iChart != null) {
            iChart.mainChartFrame.dispose();
        }
        iChart = new ChartSpots();
        iChart.createChartPanel(this.parent0, "Spots measures");
        iChart.setUpperLeftLocation(rectv);
        XLSExportOptions xlsExportOptions = new XLSExportOptions();
        xlsExportOptions.buildExcelStepMs = 60000;
        xlsExportOptions.relativeToT0 = bRelative = this.relativeToCheckbox.isSelected();
        xlsExportOptions.subtractEvaporation = false;
        xlsExportOptions.exportType = exportType;
        if (this.displayAllButton.isSelected()) {
            xlsExportOptions.seriesIndexFirst = -1;
        } else {
            int ikymo;
            xlsExportOptions.seriesIndexFirst = ikymo = this.parent0.dlgKymos.tabDisplay.kymographsCombo.getSelectedIndex() / 2;
            xlsExportOptions.seriesIndexLast = ikymo + 1;
        }
        iChart.displayData(exp, xlsExportOptions);
        iChart.mainChartFrame.toFront();
        iChart.mainChartFrame.requestFocus();
        return iChart;
    }

    public void closeAllCharts() {
        this.plotAreaPixels = this.closeChart(this.plotAreaPixels);
    }

    private ChartSpots closeChart(ChartSpots chart) {
        if (chart != null) {
            chart.mainChartFrame.dispose();
        }
        chart = null;
        return chart;
    }

    private boolean isThereAnyDataToDisplay(Experiment exp, EnumXLSExportType option) {
        Spot spot;
        boolean flag = false;
        Iterator<Spot> iterator = exp.spotsArray.spotsList.iterator();
        while (iterator.hasNext() && !(flag = (spot = iterator.next()).isThereAnyMeasuresDone(option))) {
        }
        return flag;
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
    }

    public void sequenceClosed(Sequence sequence) {
        sequence.removeListener((SequenceListener)this);
        this.closeAllCharts();
    }
}

