/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.commons;

import java.util.Arrays;
import plugins.fmp.areatrack.sequence.SequencePlus;

public class FilterTimeSeries {
    static SequencePlus vSequence = null;
    static int startFrame = 0;
    static int endFrame = 1;

    public static void filterMeasures(SequencePlus sequence, int filteroption, int span) {
        vSequence = sequence;
        startFrame = FilterTimeSeries.vSequence.analysisStart;
        endFrame = FilterTimeSeries.vSequence.analysisEnd;
        if (endFrame > FilterTimeSeries.vSequence.nTotalFrames - 1) {
            endFrame = FilterTimeSeries.vSequence.nTotalFrames - 1;
        }
        FilterTimeSeries.filterMeasures_parameters(filteroption, span);
    }

    private static void filterMeasures_parameters(int filteroption, int span) {
        int nrois = FilterTimeSeries.vSequence.data_raw.length;
        if (FilterTimeSeries.vSequence.data_filtered == null || FilterTimeSeries.vSequence.data_filtered.length != FilterTimeSeries.vSequence.data_raw.length) {
            int nbins = (endFrame - startFrame + 1) / FilterTimeSeries.vSequence.analysisStep + 1;
            FilterTimeSeries.vSequence.data_filtered = new double[nrois][nbins];
        }
        if (span / 2 > endFrame - startFrame + 1) {
            filteroption = 0;
        }
        switch (filteroption) {
            case 1: {
                FilterTimeSeries.filterMeasures_RunningAverage(span);
                break;
            }
            case 2: {
                FilterTimeSeries.filterMeasures_RunningMedian(span);
                break;
            }
            default: {
                for (int t = 0; t < endFrame - startFrame + 1; t += FilterTimeSeries.vSequence.analysisStep) {
                    int bin = t / FilterTimeSeries.vSequence.analysisStep;
                    for (int iroi = 0; iroi < nrois; ++iroi) {
                        FilterTimeSeries.vSequence.data_filtered[iroi][bin] = FilterTimeSeries.vSequence.data_raw[iroi][t];
                    }
                }
            }
        }
    }

    private static void filterMeasures_RunningAverage(int span) {
        int nrois = FilterTimeSeries.vSequence.data_raw.length;
        for (int iroi = 0; iroi < nrois; ++iroi) {
            int bin;
            int t;
            double sum = 0.0;
            for (t = 0; t < endFrame - startFrame + 1; t += FilterTimeSeries.vSequence.analysisStep) {
                bin = t / FilterTimeSeries.vSequence.analysisStep;
                sum += (double)FilterTimeSeries.vSequence.data_raw[iroi][t];
                if (t >= span / 2) continue;
                FilterTimeSeries.vSequence.data_filtered[iroi][bin] = FilterTimeSeries.vSequence.data_raw[iroi][t];
            }
            sum -= (double)(FilterTimeSeries.vSequence.data_raw[iroi][span] - FilterTimeSeries.vSequence.data_raw[iroi][0]);
            for (t = endFrame - startFrame - span / 2; t < endFrame - startFrame; t += FilterTimeSeries.vSequence.analysisStep) {
                bin = t / FilterTimeSeries.vSequence.analysisStep;
                FilterTimeSeries.vSequence.data_filtered[iroi][bin] = FilterTimeSeries.vSequence.data_raw[iroi][t];
            }
            for (t = span / 2; t < endFrame - startFrame - span / 2; ++t) {
                bin = t / FilterTimeSeries.vSequence.analysisStep;
                int t0 = t - span / 2;
                int t1 = t + span / 2;
                FilterTimeSeries.vSequence.data_filtered[iroi][bin] = (sum += (double)(FilterTimeSeries.vSequence.data_raw[iroi][t1] - FilterTimeSeries.vSequence.data_raw[iroi][t0])) / (double)span;
            }
        }
    }

    private static void filterMeasures_RunningMedian(int span) {
        int nrois = FilterTimeSeries.vSequence.data_raw.length;
        int nbspan = span / 2;
        for (int iroi = 0; iroi < nrois; ++iroi) {
            int sizeTempArray = nbspan * 2 + 1;
            int[] tempArraySorted = new int[sizeTempArray];
            int[] tempArrayCircular = new int[sizeTempArray];
            for (int t = 0; t < sizeTempArray; ++t) {
                int value;
                int bin = t / FilterTimeSeries.vSequence.analysisStep;
                tempArrayCircular[bin] = value = FilterTimeSeries.vSequence.data_raw[iroi][bin];
                FilterTimeSeries.vSequence.data_filtered[iroi][bin] = value;
            }
            int iarraycircular = sizeTempArray - 1;
            for (int t = nbspan; t < endFrame - startFrame - nbspan; ++t) {
                int newvalue;
                int bin = (t + nbspan) / FilterTimeSeries.vSequence.analysisStep;
                tempArrayCircular[iarraycircular] = newvalue = FilterTimeSeries.vSequence.data_raw[iroi][t];
                tempArraySorted = (int[])tempArrayCircular.clone();
                Arrays.sort(tempArraySorted);
                int median = tempArraySorted[nbspan];
                bin = t / FilterTimeSeries.vSequence.analysisStep;
                FilterTimeSeries.vSequence.data_filtered[iroi][bin] = median;
                if (++iarraycircular < sizeTempArray) continue;
                iarraycircular = 0;
            }
        }
    }
}

