/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.sequence;

import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.gui.viewer.Viewer;
import icy.main.Icy;
import icy.sequence.Sequence;
import java.util.Arrays;
import java.util.List;
import plugins.fmp.areatrack.sequence.Directories;
import plugins.fmp.areatrack.sequence.EnumStatus;
import plugins.fmp.areatrack.sequence.ExperimentDirectories;
import plugins.fmp.areatrack.sequence.SequencePlus;
import plugins.fmp.areatrack.tools.StringSorter;

public class SequencePlusOpen {
    public static EnumStatus statusSequence = EnumStatus.REGULAR;
    private static final String[] acceptedTypes = new String[]{".jpg", ".jpeg", ".bmp", "tiff"};

    public static Viewer initSequenceViewer(Sequence seq) {
        if (seq == null) {
            return null;
        }
        Viewer v = seq.getFirstViewer();
        if (v != null) {
            v.close();
        }
        Icy.getMainInterface().addSequence(seq);
        v = seq.getFirstViewer();
        return v;
    }

    public static SequencePlus openImagesOrAvi(String path) {
        List<String> cameraImagesList = ExperimentDirectories.getV2ImagesListFromDialog(path);
        if (cameraImagesList == null) {
            return null;
        }
        String cameraImagesDirectory = Directories.getDirectoryFromName(cameraImagesList.get(0));
        String strImagesDirectory = ExperimentDirectories.getImagesDirectoryAsParentFromFileName(cameraImagesDirectory);
        List<String> imagesList = ExperimentDirectories.getV2ImagesListFromPath(strImagesDirectory);
        imagesList = ExperimentDirectories.keepOnlyAcceptedNames_List(imagesList, "jpg");
        SequencePlus seqPlus = null;
        if (imagesList.size() > 0) {
            seqPlus = new SequencePlus();
            seqPlus.setV2ImagesList(imagesList);
            seqPlus.attachSequence(SequencePlusOpen.loadSequenceFromImagesList_V2(imagesList));
        }
        return seqPlus;
    }

    private static String[] getAcceptedNamesFromImagesList(String[] list, String directory) {
        statusSequence = EnumStatus.FAILURE;
        String[] imagesList = SequencePlusOpen.keepOnlyAcceptedNames(list);
        if (list == null) {
            return null;
        }
        int j = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            imagesList[j++] = directory + '/' + list[i];
        }
        imagesList = StringSorter.sortNumerically(imagesList);
        statusSequence = EnumStatus.FILESTACK;
        return imagesList;
    }

    private static String[] keepOnlyAcceptedNames(String[] rawlist) {
        int count = 0;
        for (int i = 0; i < rawlist.length; ++i) {
            String name = rawlist[i];
            if (!SequencePlusOpen.acceptedFileType(name)) {
                rawlist[i] = null;
                continue;
            }
            ++count;
        }
        if (count == 0) {
            return null;
        }
        String[] list = rawlist;
        if (count < rawlist.length) {
            list = new String[count];
            int index = 0;
            for (int i = 0; i < rawlist.length; ++i) {
                if (rawlist[i] == null) continue;
                list[index++] = rawlist[i];
            }
        }
        return list;
    }

    private static boolean acceptedFileType(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < acceptedTypes.length; ++i) {
            if (!name.endsWith(acceptedTypes[i])) continue;
            return true;
        }
        return false;
    }

    static SequencePlus loadSequencePlusFromList(String[] list, String directory) {
        String[] imagesArray = SequencePlusOpen.getAcceptedNamesFromImagesList(list, directory);
        List<String> imagesList = Arrays.asList(imagesArray);
        int nTotalFrames = imagesList.size();
        Sequence seq = SequencePlusOpen.loadSequenceFromImagesList_V2(imagesList);
        SequencePlus sequencePlus = new SequencePlus(seq);
        sequencePlus.nTotalFrames = nTotalFrames;
        return sequencePlus;
    }

    public static Sequence loadSequenceFromImagesList_V2(List<String> imagesList) {
        SequenceFileImporter seqFileImporter = Loader.getSequenceFileImporter((String)imagesList.get(0), (boolean)true);
        Sequence seq = (Sequence)Loader.loadSequences((SequenceFileImporter)seqFileImporter, imagesList, (int)0, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false).get(0);
        return seq;
    }
}

