/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.splitroitoarray;

import icy.gui.component.PopupPanel;
import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.areatrack.Areatrack;
import plugins.fmp.areatrack.sequence.SequencePlusOpen;
import plugins.fmp.areatrack.sequence.SequenceVirtual;
import plugins.fmp.areatrack.splitroitoarray.DefineLinesManually;
import plugins.fmp.areatrack.splitroitoarray.DetectLinesSTD;
import plugins.fmp.areatrack.splitroitoarray.DlgOutputData;

public class DlgSTDDetectLines
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 5560218796103433288L;
    JButton buildHistogramsButton = new JButton("Build histograms");
    JLabel txtThresholdSTD = new JLabel("threshold / selected filter");
    JSpinner thresholdSTD = new JSpinner(new SpinnerNumberModel(500, 1, 10000, 1));
    JLabel txtThresholdSTDFFromChanComboBox = new JLabel("Filter from");
    JComboBox<String> thresholdSTDFromChanComboBox = new JComboBox<String>(new String[]{"R", "G", "B", "R+B-2G"});
    JButton generateAutoGridButton = new JButton("Create lines / histograms > threshold");
    JLabel txtAreaShrink = new JLabel("area shrink (%)");
    JSpinner areaShrink = new JSpinner(new SpinnerNumberModel(5, -100, 100, 1));
    JButton convertLinesToSquaresButton = new JButton("Convert lines to squares");
    Areatrack areatrack = null;
    private SequenceVirtual sequenceVirtual = null;
    private DlgOutputData dlgOutputData = null;

    public void init(Areatrack areatrack, final IcyFrame dialogFrame, JPanel mainPanel, DlgOutputData dlgOutputData) {
        this.areatrack = areatrack;
        this.dlgOutputData = dlgOutputData;
        this.sequenceVirtual = areatrack.vSequence;
        PopupPanel popuppanel1 = new PopupPanel("detect lines using STD");
        JPanel panel1 = popuppanel1.getMainPanel();
        panel1.setLayout(new GridLayout(6, 2));
        panel1.add(this.buildHistogramsButton);
        panel1.add(GuiUtil.besidesPanel((Component[])new Component[]{this.txtThresholdSTD, this.thresholdSTD}));
        panel1.add(GuiUtil.besidesPanel((Component[])new Component[]{this.txtThresholdSTDFFromChanComboBox, this.thresholdSTDFromChanComboBox}));
        panel1.add(GuiUtil.besidesPanel((Component[])new Component[]{this.generateAutoGridButton}));
        panel1.add(GuiUtil.besidesPanel((Component[])new Component[]{this.txtAreaShrink, this.areaShrink}));
        panel1.add(GuiUtil.besidesPanel((Component[])new Component[]{this.convertLinesToSquaresButton}));
        mainPanel.add((Component)popuppanel1);
        popuppanel1.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                dialogFrame.revalidate();
                dialogFrame.pack();
                dialogFrame.repaint();
            }
        });
        popuppanel1.expand();
        this.thresholdSTDFromChanComboBox.setSelectedIndex(3);
        this.addActionListeners();
    }

    void addActionListeners() {
        this.buildHistogramsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequencePlusOpen.initSequenceViewer(((DlgSTDDetectLines)DlgSTDDetectLines.this).sequenceVirtual.seq);
                DlgSTDDetectLines.this.sequenceVirtual = new SequenceVirtual(((DlgSTDDetectLines)DlgSTDDetectLines.this).sequenceVirtual.seq);
                DetectLinesSTD.findLines(((DlgSTDDetectLines)DlgSTDDetectLines.this).sequenceVirtual.seq, ((DlgSTDDetectLines)DlgSTDDetectLines.this).sequenceVirtual.currentFrame);
            }
        });
        this.generateAutoGridButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int t = ((DlgSTDDetectLines)DlgSTDDetectLines.this).sequenceVirtual.currentFrame;
                String choice = (String)DlgSTDDetectLines.this.thresholdSTDFromChanComboBox.getSelectedItem();
                int threshold = (Integer)DlgSTDDetectLines.this.thresholdSTD.getValue();
                DetectLinesSTD.buildAutoGrid(((DlgSTDDetectLines)DlgSTDDetectLines.this).sequenceVirtual.seq, t, choice, threshold);
            }
        });
        this.convertLinesToSquaresButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int areaShrinkPCT = (Integer)DlgSTDDetectLines.this.areaShrink.getValue();
                String rootname = (String)((DlgSTDDetectLines)DlgSTDDetectLines.this).dlgOutputData.ezRootnameComboBox.getSelectedItem();
                DefineLinesManually.convertLinesToSquares(((DlgSTDDetectLines)DlgSTDDetectLines.this).sequenceVirtual.seq, rootname, areaShrinkPCT);
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }
}

