/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.dlg;

import icy.gui.component.PopupPanel;
import icy.gui.frame.IcyFrame;
import icy.roi.ROI2D;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.areatrack.Areatrack;
import plugins.fmp.areatrack.commons.AreaAnalysisThread;
import plugins.fmp.areatrack.sequence.SequencePlus;
import plugins.fmp.areatrack.tools.EnumAreaDetection;

public class Dlg5AnalysisRun
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 939455785786474853L;
    private JButton startComputationButton = new JButton("Start");
    private JButton stopComputationButton = new JButton("Stop");
    JSpinner analysisStartSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
    JSpinner analysisEndSpinner = new JSpinner(new SpinnerNumberModel(9999999, 0, 9999999, 1));
    private JSpinner analyzeStepSpinner = new JSpinner(new SpinnerNumberModel(1, 0, 10000, 1));
    public AreaAnalysisThread analysisThread = null;
    Areatrack areatrack = null;

    public void init(Areatrack areatrack, final IcyFrame mainFrame, JPanel mainPanel, String title) {
        this.areatrack = areatrack;
        PopupPanel capPopupPanel = new PopupPanel(title);
        JPanel capPanel = capPopupPanel.getMainPanel();
        capPanel.setLayout(new GridLayout(2, 2));
        capPopupPanel.collapse();
        capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                mainFrame.revalidate();
                mainFrame.pack();
                mainFrame.repaint();
            }
        });
        mainPanel.add((Component)capPopupPanel);
        FlowLayout layoutLeft = new FlowLayout(0);
        JPanel panel1 = new JPanel(layoutLeft);
        ((FlowLayout)panel1.getLayout()).setVgap(0);
        panel1.add(this.startComputationButton);
        panel1.add(this.stopComputationButton);
        this.stopComputationButton.setEnabled(false);
        capPanel.add(panel1);
        JLabel startLabel = new JLabel("from ");
        JLabel endLabel = new JLabel("to ");
        JLabel stepLabel = new JLabel("step ");
        int bWidth = 50;
        int bHeight = 21;
        this.analysisStartSpinner.setPreferredSize(new Dimension(bWidth, bHeight));
        this.analysisEndSpinner.setPreferredSize(new Dimension(100, bHeight));
        this.analyzeStepSpinner.setPreferredSize(new Dimension(bWidth, bHeight));
        JPanel panel0 = new JPanel(layoutLeft);
        ((FlowLayout)panel0.getLayout()).setVgap(0);
        panel0.add(startLabel);
        panel0.add(this.analysisStartSpinner);
        panel0.add(endLabel);
        panel0.add(this.analysisEndSpinner);
        panel0.add(stepLabel);
        panel0.add(this.analyzeStepSpinner);
        capPanel.add(panel0);
        this.declareActionListeners();
    }

    private void declareActionListeners() {
        this.stopComputationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg5AnalysisRun.this.stopAnalysisThread();
                Dlg5AnalysisRun.this.setButtonsStateAsAnalysisRunning(false);
            }
        });
        this.startComputationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg5AnalysisRun.this.startAnalysisThread();
                Dlg5AnalysisRun.this.setButtonsStateAsAnalysisRunning(true);
            }
        });
    }

    private void setButtonsStateAsAnalysisRunning(boolean isRunning) {
        this.stopComputationButton.setEnabled(isRunning);
        this.startComputationButton.setEnabled(!isRunning);
    }

    public void updateStartAndEndFrameFromvSequence(SequencePlus vSequence) {
        if (vSequence == null) {
            return;
        }
        this.analysisEndSpinner.setValue(vSequence.analysisEnd);
        this.analysisStartSpinner.setValue(vSequence.analysisStart);
        this.analyzeStepSpinner.setValue(vSequence.analysisStep);
    }

    private void startAnalysisThread() {
        this.stopAnalysisThread();
        this.analysisThread = new AreaAnalysisThread();
        this.areatrack.vSequence.analysisStart = (Integer)this.analysisStartSpinner.getValue();
        this.areatrack.vSequence.analysisEnd = (Integer)this.analysisEndSpinner.getValue();
        this.areatrack.vSequence.analysisStep = (Integer)this.analyzeStepSpinner.getValue();
        if (this.areatrack.detectionParameters.detectArea) {
            if (this.areatrack.detectionParameters.areaDetectionMode == EnumAreaDetection.SINGLE) {
                this.analysisThread.initAreaDetectionFromFunction(this.areatrack.vSequence, this.getROIsToAnalyze(), this.areatrack.detectionParameters.simpletransformop, this.areatrack.detectionParameters.simplethreshold, this.areatrack.detectionParameters.thresholdUp);
            } else {
                this.areatrack.detectionParameters.areaDetectionMode = EnumAreaDetection.COLORARRAY;
                this.analysisThread.initAreaDetectionFromColors(this.areatrack.vSequence, this.getROIsToAnalyze(), this.areatrack.detectionParameters.colordistanceType, this.areatrack.detectionParameters.colorthreshold, this.areatrack.detectionParameters.colorarray);
            }
        }
        if (this.areatrack.detectionParameters.detectMovement) {
            this.analysisThread.initMovementDetection(this.areatrack.vSequence, this.getROIsToAnalyze(), this.areatrack.detectionParameters.thresholdmovement);
        }
        this.analysisThread.addPropertyChangeListener(this);
        this.analysisThread.execute();
    }

    private void stopAnalysisThread() {
        if (this.analysisThread != null && !this.analysisThread.stopFlag) {
            this.analysisThread.stopFlag = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.setButtonsStateAsAnalysisRunning(false);
        }
    }

    private ArrayList<ROI2D> getROIsToAnalyze() {
        return this.areatrack.vSequence.seq.getROI2Ds();
    }
}

