/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.splitroitoarray;

import icy.gui.component.PopupPanel;
import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.roi.ROI;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.areatrack.Areatrack;

public class DlgOutputData
extends JPanel {
    private static final long serialVersionUID = -4391541015534295004L;
    JLabel txtRootnameComboBox = new JLabel("Names of ROIS begin with");
    JComboBox<String> ezRootnameComboBox = new JComboBox<String>(new String[]{"gridA", "gridB", "gridC"});
    JButton changeGridNameButton = new JButton("Set names of ROIs");
    JButton saveXMLButton = new JButton("Save ROIs to XML file");
    Areatrack areatrack = null;

    public void init(Areatrack areatrack, final IcyFrame dialogFrame, JPanel mainPanel) {
        this.areatrack = areatrack;
        PopupPanel popuppanel3 = new PopupPanel("output data");
        JPanel panel3 = popuppanel3.getMainPanel();
        panel3.setLayout(new GridLayout(3, 2));
        panel3.add(GuiUtil.besidesPanel((Component[])new Component[]{this.txtRootnameComboBox, this.ezRootnameComboBox}));
        panel3.add(GuiUtil.besidesPanel((Component[])new Component[]{this.changeGridNameButton}));
        panel3.add(GuiUtil.besidesPanel((Component[])new Component[]{this.saveXMLButton}));
        mainPanel.add((Component)popuppanel3);
        popuppanel3.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                dialogFrame.revalidate();
                dialogFrame.pack();
                dialogFrame.repaint();
            }
        });
        popuppanel3.expand();
        this.addActionListeners();
    }

    void addActionListeners() {
        this.saveXMLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgOutputData.this.saveXMLFile();
            }
        });
        this.changeGridNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgOutputData.this.changeGridName();
            }
        });
    }

    private void saveXMLFile() {
        this.areatrack.vSequence.capillariesRoi2RoiArray.xmlWriteROIsAndDataNoFilter("roisarray.xml", this.areatrack.vSequence);
    }

    private void changeGridName() {
        List roisList = this.areatrack.vSequence.seq.getROIs(true);
        String baseName = (String)this.ezRootnameComboBox.getSelectedItem();
        for (ROI roi : roisList) {
            String cs = roi.getName();
            int firstunderscore = cs.indexOf("_");
            if (firstunderscore <= 0) continue;
            cs = baseName + cs.substring(firstunderscore);
            roi.setName(cs);
        }
    }
}

