/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.commons;

import icy.gui.frame.progress.AnnounceFrame;
import icy.util.XMLUtil;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.areatrack.sequence.SequencePlus;
import plugins.fmp.areatrack.tools.EnumAreaDetection;
import plugins.fmp.areatrack.tools.EnumColorDistanceType;
import plugins.fmp.areatrack.tools.EnumImageOp;
import plugins.fmp.areatrack.tools.FmpTools;

public class DetectionParameters {
    final String filenameAreatrackXml = "areatrack.xml";
    public boolean detectArea = true;
    public boolean displayOverlay = true;
    public EnumAreaDetection areaDetectionMode = EnumAreaDetection.COLORARRAY;
    public EnumImageOp simpletransformop = EnumImageOp.R2MINUS_GB;
    public int simplethreshold = 20;
    public boolean thresholdUp = true;
    public EnumImageOp colortransformop = EnumImageOp.NONE;
    public EnumColorDistanceType colordistanceType = EnumColorDistanceType.L2;
    public int colorthreshold = 20;
    public ArrayList<Color> colorarray = new ArrayList();
    public boolean detectMovement = false;
    public int thresholdmovement = 20;
    String ID_PARAMETERS = "Parameters";
    String ID_COLORMODESELECTED = "colormodeselected";
    String ID_COLORTRANSFORMOP = "colortransformop";
    String ID_SIMPLETRANSFORMOP = "simpletransformop";
    String ID_THRESHOLDMOVEMENT = "thresholdmovement";
    String ID_COLORDISTANCETYPE = "colordistanceType";
    String ID_COLORTHRESHOLD = "colorthreshold";
    String ID_THRESHOLDUP = "thresholdUp";
    String ID_SIMPLETHRESHOLD = "simplethreshold";
    String ID_NBCOLORS = "ncolors";
    String ID_COLOR = "color";

    public boolean xmlLoadAreaTrackParameters(SequencePlus vSequence) {
        String directory = "";
        if (vSequence != null) {
            directory = vSequence.getDirectory() + File.separator;
        }
        String filename = directory + "areatrack.xml";
        Document doc = XMLUtil.loadDocument((String)filename);
        boolean flag = false;
        if (doc != null && !(flag = this.loadAreaTrackParameters(doc))) {
            new AnnounceFrame("Failed reading xml data from " + filename);
        }
        return flag;
    }

    public void xmlSaveAreaTrackParameters(SequencePlus vSequence) {
        String csFile = FmpTools.saveFileAs("areatrack.xml", vSequence.getDirectory(), "xml");
        csFile.toLowerCase();
        if (!csFile.contains(".xml")) {
            csFile = csFile + ".xml";
        }
        Document doc = XMLUtil.createDocument((boolean)true);
        boolean flag = false;
        if (doc != null) {
            flag = this.saveAreaTrackParameters(doc);
            XMLUtil.saveDocument((Document)doc, (String)csFile);
        }
        if (!flag) {
            new AnnounceFrame("saving data failed");
        }
    }

    private boolean loadAreaTrackParameters(Document doc) {
        String nodeName = "areaTrack";
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)nodeName);
        if (node == null) {
            return false;
        }
        Element xmlElement = XMLUtil.getElement((Node)node, (String)this.ID_PARAMETERS);
        if (xmlElement == null) {
            return false;
        }
        Element xmlVal = XMLUtil.getElement((Node)xmlElement, (String)this.ID_COLORMODESELECTED);
        boolean iscolorselected = XMLUtil.getAttributeBooleanValue((Element)xmlVal, (String)"value", (boolean)true);
        this.areaDetectionMode = iscolorselected ? EnumAreaDetection.COLORARRAY : EnumAreaDetection.SINGLE;
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)this.ID_SIMPLETRANSFORMOP);
        String codestring = XMLUtil.getAttributeValue((Element)xmlVal, (String)"descriptor", (String)"none");
        this.simpletransformop = EnumImageOp.findByText(codestring);
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)this.ID_THRESHOLDUP);
        this.thresholdUp = XMLUtil.getElementBooleanValue((Node)xmlVal, (String)"value", (boolean)true);
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)this.ID_SIMPLETHRESHOLD);
        this.simplethreshold = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"value", (int)35);
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)this.ID_THRESHOLDMOVEMENT);
        this.thresholdmovement = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"value", (int)20);
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)this.ID_COLORTRANSFORMOP);
        this.colortransformop = EnumImageOp.findByText(codestring);
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)this.ID_COLORDISTANCETYPE);
        codestring = XMLUtil.getAttributeValue((Element)xmlVal, (String)"value", (String)"L1");
        this.colordistanceType = EnumColorDistanceType.findByText(codestring);
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)this.ID_COLORTHRESHOLD);
        this.colorthreshold = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"value", (int)20);
        this.colorarray.clear();
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)this.ID_NBCOLORS);
        int ncolors = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"value", (int)0);
        for (int i = 0; i < ncolors; ++i) {
            String element = this.ID_COLOR + Integer.toString(i);
            xmlVal = XMLUtil.getElement((Node)xmlElement, (String)element);
            int alpha = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"a", (int)0);
            int red = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"r", (int)0);
            int blue = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"b", (int)0);
            int green = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"g", (int)0);
            Color color = new Color(red, green, blue, alpha);
            this.colorarray.add(color);
        }
        return true;
    }

    private boolean saveAreaTrackParameters(Document doc) {
        String nodeName = "areaTrack";
        Element node = XMLUtil.addElement((Node)XMLUtil.getRootElement((Document)doc), (String)nodeName);
        if (node == null) {
            return false;
        }
        Element xmlElement = XMLUtil.addElement((Node)node, (String)this.ID_PARAMETERS);
        Element xmlVal = XMLUtil.addElement((Node)xmlElement, (String)this.ID_COLORMODESELECTED);
        boolean iscolorselected = this.areaDetectionMode == EnumAreaDetection.COLORARRAY;
        XMLUtil.setAttributeBooleanValue((Element)xmlVal, (String)"value", (boolean)iscolorselected);
        xmlVal = XMLUtil.addElement((Node)xmlElement, (String)this.ID_SIMPLETRANSFORMOP);
        XMLUtil.setAttributeValue((Element)xmlVal, (String)"descriptor", (String)this.simpletransformop.toString());
        xmlVal = XMLUtil.addElement((Node)xmlElement, (String)this.ID_THRESHOLDUP);
        XMLUtil.setAttributeBooleanValue((Element)xmlVal, (String)"value", (boolean)this.thresholdUp);
        xmlVal = XMLUtil.addElement((Node)xmlElement, (String)this.ID_SIMPLETHRESHOLD);
        XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"value", (int)this.simplethreshold);
        xmlVal = XMLUtil.addElement((Node)xmlElement, (String)this.ID_THRESHOLDMOVEMENT);
        XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"value", (int)this.thresholdmovement);
        xmlVal = XMLUtil.addElement((Node)xmlElement, (String)this.ID_COLORTRANSFORMOP);
        XMLUtil.setAttributeValue((Element)xmlVal, (String)"descriptor", (String)this.colortransformop.toString());
        xmlVal = XMLUtil.addElement((Node)xmlElement, (String)this.ID_COLORDISTANCETYPE);
        XMLUtil.setAttributeValue((Element)xmlVal, (String)"value", (String)this.colordistanceType.toString());
        xmlVal = XMLUtil.addElement((Node)xmlElement, (String)this.ID_COLORTHRESHOLD);
        XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"value", (int)this.colorthreshold);
        xmlVal = XMLUtil.addElement((Node)xmlElement, (String)this.ID_NBCOLORS);
        XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"value", (int)this.colorarray.size());
        for (int i = 0; i < this.colorarray.size(); ++i) {
            Color color = this.colorarray.get(i);
            xmlVal = XMLUtil.addElement((Node)xmlElement, (String)(this.ID_COLOR + Integer.toString(i)));
            XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"a", (int)color.getAlpha());
            XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"r", (int)color.getRed());
            XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"g", (int)color.getGreen());
            XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"b", (int)color.getBlue());
        }
        return true;
    }
}

