/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.commons;

import icy.roi.ROI2D;
import icy.util.XLSUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import plugins.fmp.areatrack.Areatrack;
import plugins.fmp.areatrack.commons.FilterTimeSeries;
import plugins.fmp.areatrack.commons.MeasureAndName;
import plugins.fmp.areatrack.sequence.SequencePlus;
import plugins.fmp.areatrack.tools.FmpTools;

public class ExportToXLS {
    Areatrack areatrack = null;
    SequencePlus vSequence = null;
    int startFrame = 0;
    int endFrame = 1;
    int span = 1;
    int analyzeStep = 1;
    String distanceString;
    String threshold2String;
    boolean detectMovement = false;
    private ArrayList<MeasureAndName> resultsHeatMap = null;

    private void exportToXLSWorksheet(WritableWorkbook xlsWorkBook, String worksheetname) throws InterruptedException {
        int it = 0;
        int irow = 0;
        int nrois = this.vSequence.data_filtered.length;
        int icol0 = 0;
        List<String> listofFiles = null;
        boolean blistofFiles = false;
        if (this.vSequence.isFileStack()) {
            listofFiles = this.vSequence.getListofFiles();
            blistofFiles = true;
        }
        WritableSheet filteredDataPage = XLSUtil.createNewPage((WritableWorkbook)xlsWorkBook, (String)worksheetname);
        XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)0, (int)irow, (String)"name:");
        XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)1, (int)irow, (String)this.vSequence.seq.getName());
        ++irow;
        String cs = worksheetname;
        if (!worksheetname.contains("raw")) {
            cs = cs + " - over " + this.span + " points - ";
        }
        XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)0, (int)irow, (String)worksheetname);
        cs = "Detect surface: colors array with distance=" + this.distanceString;
        XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)0, (int)(++irow), (String)cs);
        cs = "Detect movement using image (n) - (n-1) threshold=" + this.threshold2String;
        XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)0, (int)(++irow), (String)cs);
        irow = 4;
        icol0 = 0;
        if (blistofFiles) {
            icol0 = 1;
        }
        XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)icol0, (int)irow, (String)"index");
        int icol1 = ++icol0;
        ArrayList roisList = this.vSequence.seq.getROI2Ds();
        XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)0, (int)irow, (String)"column");
        XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)0, (int)(irow + 1), (String)"roi surface (pixels)");
        Collections.sort(roisList, new FmpTools.ROI2DNameComparator());
        for (ROI2D roi : roisList) {
            XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)icol1, (int)irow, (String)roi.getName());
            XLSUtil.setCellNumber((WritableSheet)filteredDataPage, (int)icol1, (int)(irow + 1), (double)roi.getNumberOfPoints());
            ++icol1;
        }
        if (this.detectMovement) {
            icol1 = icol0;
            XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)0, (int)(irow + 2), (String)"column");
            XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)0, (int)(irow + 3), (String)("activity(npixels>" + this.threshold2String + ")"));
            XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)0, (int)(irow + 4), (String)"count");
            for (MeasureAndName result : this.resultsHeatMap) {
                if (result.name != "background") {
                    XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)icol1, (int)(irow + 2), (String)result.name);
                    XLSUtil.setCellNumber((WritableSheet)filteredDataPage, (int)icol1, (int)(irow + 3), (double)(result.data / result.count));
                    XLSUtil.setCellNumber((WritableSheet)filteredDataPage, (int)icol1, (int)(irow + 4), (double)result.count);
                    ++icol1;
                    continue;
                }
                XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)(icol0 - 1), (int)(irow + 2), (String)result.name);
                XLSUtil.setCellNumber((WritableSheet)filteredDataPage, (int)(icol0 - 1), (int)(irow + 3), (double)(result.data / result.count));
                XLSUtil.setCellNumber((WritableSheet)filteredDataPage, (int)(icol0 - 1), (int)(irow + 4), (double)result.count);
            }
        }
        icol1 = icol0;
        irow += 7;
        if (blistofFiles) {
            XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)0, (int)irow, (String)"name");
        }
        int iroi = 0;
        while (iroi < nrois) {
            XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)icol1, (int)irow, (String)this.vSequence.seriesname[iroi]);
            ++iroi;
            ++icol1;
        }
        ++irow;
        it = 1;
        int t = this.startFrame;
        while (t <= this.endFrame) {
            icol0 = 0;
            if (blistofFiles) {
                XLSUtil.setCellString((WritableSheet)filteredDataPage, (int)icol0, (int)irow, (String)listofFiles.get(it));
                ++icol0;
            }
            double value = t;
            XLSUtil.setCellNumber((WritableSheet)filteredDataPage, (int)icol0, (int)irow, (double)value);
            ++icol0;
            int frameIndex = (t - this.startFrame) / this.analyzeStep;
            int iroi2 = 0;
            while (iroi2 < nrois) {
                value = this.vSequence.data_filtered[iroi2][frameIndex];
                XLSUtil.setCellNumber((WritableSheet)filteredDataPage, (int)icol0, (int)irow, (double)value);
                ++iroi2;
                ++icol0;
            }
            t += this.analyzeStep;
            ++it;
            ++irow;
        }
    }

    public void exportToXLS(Areatrack areatrack, String filename) throws InterruptedException {
        this.areatrack = areatrack;
        this.vSequence = areatrack.vSequence;
        this.startFrame = this.vSequence.analysisStart;
        this.endFrame = this.vSequence.analysisEnd;
        if (areatrack.dlg5AnalysisRun.analysisThread != null) {
            this.resultsHeatMap = areatrack.dlg5AnalysisRun.analysisThread.results;
        }
        this.span = Integer.parseInt(areatrack.dlg6ResultsExport.spanTextField.getText());
        this.analyzeStep = this.vSequence.analysisStep;
        this.distanceString = String.valueOf(areatrack.detectionParameters.colorthreshold);
        this.threshold2String = String.valueOf(areatrack.detectionParameters.thresholdmovement);
        this.detectMovement = areatrack.detectionParameters.detectMovement;
        System.out.println("XLS output");
        try {
            WritableWorkbook xlsWorkBook = XLSUtil.createWorkbook((String)filename);
            FilterTimeSeries.filterMeasures(this.vSequence, 0, this.span);
            this.exportToXLSWorksheet(xlsWorkBook, "raw");
            if (this.span / 2 < this.endFrame - this.startFrame) {
                FilterTimeSeries.filterMeasures(this.vSequence, 1, this.span);
                this.exportToXLSWorksheet(xlsWorkBook, "avg");
                FilterTimeSeries.filterMeasures(this.vSequence, 2, this.span);
                this.exportToXLSWorksheet(xlsWorkBook, "median");
            }
            XLSUtil.saveAndClose((WritableWorkbook)xlsWorkBook);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
        System.out.println("XLS output done");
    }
}

