/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.dlg;

import icy.gui.component.PopupPanel;
import icy.gui.frame.IcyFrame;
import icy.gui.util.FontUtil;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerListener;
import icy.main.Icy;
import icy.preferences.XMLPreferences;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.areatrack.Areatrack;
import plugins.fmp.areatrack.sequence.SequencePlus;
import plugins.fmp.areatrack.sequence.SequencePlusOpen;

public class Dlg1Source
extends JPanel
implements SequenceListener {
    private static final long serialVersionUID = 6623935409683076615L;
    private JButton openButton = new JButton("Open...");
    private JButton closeButton = new JButton("Close");
    Areatrack areatrack = null;

    public void init(Areatrack areatrack, final IcyFrame mainFrame, JPanel mainPanel, String title) {
        this.areatrack = areatrack;
        PopupPanel capPopupPanel = new PopupPanel(title);
        JPanel capPanel = capPopupPanel.getMainPanel();
        capPanel.setLayout(new BorderLayout());
        capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                mainFrame.revalidate();
                mainFrame.pack();
                mainFrame.repaint();
            }
        });
        capPopupPanel.expand();
        mainPanel.add((Component)capPopupPanel);
        JLabel loadsaveText1 = new JLabel("-> File (jpg, jpeg, bmp, tiff) ", 4);
        loadsaveText1.setFont(FontUtil.setStyle((Font)loadsaveText1.getFont(), (int)2));
        FlowLayout layoutRight = new FlowLayout(2);
        JPanel panel2 = new JPanel(layoutRight);
        panel2.add(loadsaveText1);
        panel2.add(this.openButton);
        panel2.add(this.closeButton);
        capPanel.add(panel2);
        this.declareActionListeners();
    }

    private void declareActionListeners() {
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg1Source.this.openVideoOrStack();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Dlg1Source.this.areatrack.displayCharts != null && Dlg1Source.this.areatrack.displayCharts.mainChartFrame != null) {
                    Dlg1Source.this.areatrack.displayCharts.mainChartFrame.removeAll();
                    Dlg1Source.this.areatrack.displayCharts.mainChartFrame.close();
                    Dlg1Source.this.areatrack.displayCharts.mainChartFrame = null;
                }
                Dlg1Source.this.areatrack.vSequence.close();
            }
        });
    }

    public void openVideoOrStack() {
        SequencePlus sequencePlus;
        String path = null;
        if (this.areatrack.vSequence != null) {
            this.areatrack.vSequence.close();
        }
        if ((sequencePlus = SequencePlusOpen.openImagesOrAvi(null)) == null) {
            return;
        }
        sequencePlus.seq.addListener((SequenceListener)this);
        Viewer v = SequencePlusOpen.initSequenceViewer(sequencePlus.seq);
        v.addListener((ViewerListener)this.areatrack);
        this.placeViewerNextToDialogBox(v, this.areatrack.mainFrame);
        this.areatrack.vSequence = sequencePlus;
        path = this.areatrack.vSequence.getDirectory();
        if (path != null) {
            XMLPreferences guiPrefs = this.areatrack.getPreferences("gui");
            guiPrefs.put("lastUsedPath", path);
        }
        this.updateGuiEndFrame();
    }

    private void placeViewerNextToDialogBox(Viewer v, IcyFrame mainFrame) {
        Rectangle rectv = v.getBoundsInternal();
        Rectangle rect0 = mainFrame.getBoundsInternal();
        if (rect0.x + rect0.width < Icy.getMainInterface().getMainFrame().getDesktopWidth()) {
            rectv.setLocation(rect0.x + rect0.width, rect0.y);
            v.setBounds(rectv);
        }
    }

    private void updateGuiEndFrame() {
        if (this.areatrack.vSequence == null) {
            return;
        }
        this.areatrack.vSequence.analysisEnd = this.areatrack.vSequence.nTotalFrames - 1;
        this.areatrack.dlg5AnalysisRun.updateStartAndEndFrameFromvSequence(this.areatrack.vSequence);
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
        this.updateGuiEndFrame();
    }

    public void sequenceClosed(Sequence sequence) {
    }
}

