/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.dlg;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.areatrack.Areatrack;
import plugins.fmp.areatrack.commons.DetectionParameters;
import plugins.fmp.areatrack.tools.ComboBoxColorRenderer;
import plugins.fmp.areatrack.tools.EnumColorDistanceType;
import plugins.fmp.areatrack.tools.EnumImageOp;

public class Dlg3TabColors
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -4359876050505295400L;
    JComboBox<Color> colorPickCombo = new JComboBox();
    private ComboBoxColorRenderer colorPickComboRenderer = new ComboBoxColorRenderer(this.colorPickCombo);
    private String textPickAPixel = "Pick a pixel";
    private JButton pickColorButton = new JButton(this.textPickAPixel);
    private JButton deleteColorButton = new JButton("Delete color");
    JRadioButton rbL1 = new JRadioButton("L1");
    JRadioButton rbL2 = new JRadioButton("L2");
    JSpinner distanceSpinner = new JSpinner(new SpinnerNumberModel(10, 0, 800, 1));
    JRadioButton rbRGB = new JRadioButton("RGB");
    JRadioButton rbHSV = new JRadioButton("HSV");
    JRadioButton rbH1H2H3 = new JRadioButton("H1H2H3");
    private JLabel distanceLabel = new JLabel("Distance  ");
    private JLabel colorspaceLabel = new JLabel("Color space ");
    boolean isUpdatingDataFromComboAllowed = true;
    Areatrack areatrack = null;

    public void init(JTabbedPane tab, GridLayout capLayout, Areatrack areatrack) {
        this.areatrack = areatrack;
        JPanel panel = new JPanel(false);
        panel.setLayout(capLayout);
        this.colorPickCombo.setRenderer(this.colorPickComboRenderer);
        FlowLayout layoutLeft = new FlowLayout(0);
        JPanel panel0 = new JPanel(layoutLeft);
        panel0.add(this.pickColorButton);
        panel0.add(this.colorPickCombo);
        panel0.add(this.deleteColorButton);
        panel.add(panel0);
        JPanel panel1 = new JPanel(layoutLeft);
        ButtonGroup bgd = new ButtonGroup();
        bgd.add(this.rbL1);
        bgd.add(this.rbL2);
        panel1.add(this.distanceLabel);
        panel1.add(this.rbL1);
        panel1.add(this.rbL2);
        panel1.add(this.distanceSpinner);
        panel.add(panel1);
        ButtonGroup bgcs = new ButtonGroup();
        bgcs.add(this.rbRGB);
        bgcs.add(this.rbHSV);
        bgcs.add(this.rbH1H2H3);
        JPanel panel2 = new JPanel(layoutLeft);
        panel2.add(this.colorspaceLabel);
        panel2.add(this.rbRGB);
        panel2.add(this.rbHSV);
        panel2.add(this.rbH1H2H3);
        panel.add(panel2);
        tab.addTab("Colors", null, panel, "Display parameters for thresholding an image with different colors and a distance");
        this.rbL1.setSelected(true);
        this.rbRGB.setSelected(true);
        this.distanceSpinner.addChangeListener(this);
        this.declareActionListeners();
    }

    private void declareActionListeners() {
        this.rbRGB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg3TabColors.this.areatrack.detectionParameters.colortransformop = EnumImageOp.NONE;
                Dlg3TabColors.this.updateThresholdOverlayParameters();
            }
        });
        this.rbHSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg3TabColors.this.areatrack.detectionParameters.colortransformop = EnumImageOp.RGB_TO_HSV;
                Dlg3TabColors.this.updateThresholdOverlayParameters();
            }
        });
        this.rbH1H2H3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg3TabColors.this.areatrack.detectionParameters.colortransformop = EnumImageOp.RGB_TO_H1H2H3;
                Dlg3TabColors.this.updateThresholdOverlayParameters();
            }
        });
        this.rbL1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg3TabColors.this.areatrack.detectionParameters.colordistanceType = EnumColorDistanceType.L1;
                Dlg3TabColors.this.updateThresholdOverlayParameters();
            }
        });
        this.rbL2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg3TabColors.this.updateThresholdOverlayParameters();
            }
        });
        this.deleteColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Dlg3TabColors.this.colorPickCombo.getItemCount() > 0 && Dlg3TabColors.this.colorPickCombo.getSelectedIndex() >= 0) {
                    Dlg3TabColors.this.colorPickCombo.removeItemAt(Dlg3TabColors.this.colorPickCombo.getSelectedIndex());
                }
                Dlg3TabColors.this.updateThresholdOverlayParameters();
            }
        });
        this.pickColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg3TabColors.this.pickColor();
            }
        });
        class ItemChangeListener
        implements ItemListener {
            ItemChangeListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1 && Dlg3TabColors.this.isUpdatingDataFromComboAllowed) {
                    Dlg3TabColors.this.updateThresholdOverlayParameters();
                }
            }
        }
        this.colorPickCombo.addItemListener(new ItemChangeListener());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.distanceSpinner) {
            this.updateThresholdOverlayParameters();
        }
    }

    void updateThresholdOverlayParameters() {
        this.transferDialogToParameters(this.areatrack.detectionParameters);
        this.areatrack.setOverlay(this.areatrack.detectionParameters.displayOverlay);
    }

    private void pickColor() {
        boolean bActiveTrapOverlay = false;
        if (this.pickColorButton.getText().contains("*") || this.pickColorButton.getText().contains(":")) {
            this.pickColorButton.setBackground(Color.LIGHT_GRAY);
            this.pickColorButton.setText(this.textPickAPixel);
            bActiveTrapOverlay = false;
        } else {
            this.pickColorButton.setText("*" + this.textPickAPixel + "*");
            this.pickColorButton.setBackground(Color.DARK_GRAY);
            bActiveTrapOverlay = true;
        }
        this.areatrack.vSequence.setMouseTrapOverlay(bActiveTrapOverlay, this.pickColorButton, this.colorPickCombo);
    }

    public void transferParametersToDialog(DetectionParameters detectionParameters) {
        this.isUpdatingDataFromComboAllowed = false;
        this.colorPickCombo.removeAllItems();
        int nitems = detectionParameters.colorarray.size();
        for (int i = 0; i < nitems; ++i) {
            Color colorItem = detectionParameters.colorarray.get(i);
            this.colorPickCombo.addItem(colorItem);
        }
        this.isUpdatingDataFromComboAllowed = true;
        if (detectionParameters.colordistanceType == EnumColorDistanceType.L1) {
            this.rbL1.setSelected(true);
        } else {
            this.rbL2.setSelected(true);
        }
        switch (detectionParameters.colortransformop) {
            case RGB_TO_HSV: {
                this.rbHSV.setSelected(true);
                break;
            }
            case RGB_TO_H1H2H3: {
                this.rbH1H2H3.setSelected(true);
                break;
            }
            default: {
                this.rbRGB.setSelected(true);
            }
        }
        this.distanceSpinner.setValue(detectionParameters.colorthreshold);
    }

    public void transferDialogToParameters(DetectionParameters detectionParameters) {
        detectionParameters.colorthreshold = (Integer)this.distanceSpinner.getValue();
        detectionParameters.colortransformop = this.rbHSV.isSelected() ? EnumImageOp.RGB_TO_HSV : (this.rbH1H2H3.isSelected() ? EnumImageOp.RGB_TO_H1H2H3 : EnumImageOp.COLORARRAY1);
        detectionParameters.colorarray.clear();
        for (int i = 0; i < this.colorPickCombo.getItemCount(); ++i) {
            Color colorItem = this.colorPickCombo.getItemAt(i);
            detectionParameters.colorarray.add(colorItem);
        }
        detectionParameters.colordistanceType = this.rbL1.isSelected() ? EnumColorDistanceType.L1 : EnumColorDistanceType.L2;
    }
}

