/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.splitroitoarray;

import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import icy.type.geom.GeomUtil;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import plugins.fmp.areatrack.tools.FmpTools;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class DefineLinesManually {
    public Line2D adjustLine(IcyBufferedImage image, Line2D line, int checksize, int deltainside) {
        Rectangle rect = line.getBounds();
        Line2D.Double bestline = new Line2D.Double();
        if (rect.getWidth() >= rect.getHeight()) {
            Line2D.Double linetest1 = new Line2D.Double(line.getX1() + (double)deltainside, line.getY1() - (double)checksize, line.getX1() + (double)deltainside, line.getY2() + (double)checksize);
            int iy1min = this.getIndexMinimumValue(this.getProfile(image, linetest1)) - checksize;
            Line2D.Double linetest2 = new Line2D.Double(line.getX2() - (double)deltainside, line.getY2() - (double)checksize, line.getX2() - (double)deltainside, line.getY2() + (double)checksize);
            int iy2min = this.getIndexMinimumValue(this.getProfile(image, linetest2)) - checksize;
            ((Line2D)bestline).setLine(line.getX1(), line.getY1() - (double)iy1min, line.getX2(), line.getY2() - (double)iy2min);
        } else {
            Line2D.Double linetest1 = new Line2D.Double(line.getX1() - (double)checksize, line.getY1() + (double)deltainside, line.getX1() + (double)checksize, line.getY2() + (double)deltainside);
            int iy1min = this.getIndexMinimumValue(this.getProfile(image, linetest1)) - checksize;
            Line2D.Double linetest2 = new Line2D.Double(line.getX2() - (double)checksize, line.getY2() - (double)deltainside, line.getX2() + (double)checksize, line.getY2() - (double)deltainside);
            int iy2min = this.getIndexMinimumValue(this.getProfile(image, linetest2)) - checksize;
            ((Line2D)bestline).setLine(line.getX1(), line.getY1() - (double)iy1min, line.getX2(), line.getY2() - (double)iy2min);
        }
        return bestline;
    }

    private double[][] getProfile(IcyBufferedImage image, Line2D line) {
        List<Point2D> pointslist = this.getAllPointsAlongLine(line);
        double[][] profile = this.getValueForPointList(pointslist, image);
        return profile;
    }

    public double[][] getValueForPointList(List<Point2D> pointList, IcyBufferedImage image) {
        int sizeX = image.getSizeX();
        int sizeY = image.getSizeY();
        int nchannels = image.getSizeC();
        int len = pointList.size();
        double[][] value = new double[len][nchannels];
        for (int chan = 0; chan < nchannels; ++chan) {
            double[] sourceValues = Array1DUtil.arrayToDoubleArray((Object)image.getDataXY(chan), (boolean)image.isSignedDataType());
            int len_sourceValues = sourceValues.length - 1;
            for (int i = 0; i < len; ++i) {
                int index;
                Point2D point = pointList.get(i);
                if (point.getX() < 0.0) {
                    point.setLocation(0.0, point.getY());
                }
                if (point.getY() < 0.0) {
                    point.setLocation(point.getX(), 0.0);
                }
                if (point.getX() >= (double)sizeX) {
                    point.setLocation(sizeX - 1, point.getY());
                }
                if (point.getX() >= (double)sizeX || point.getY() >= (double)sizeY) {
                    point.setLocation(point.getX(), sizeY - 1);
                }
                if ((index = (int)point.getX() + (int)point.getY() * sizeX) >= len_sourceValues) {
                    index = len_sourceValues - 1;
                }
                if (index < 0) {
                    System.out.println("i= " + i + " point x:" + point.getX() + " point.y=" + point.getY() + " index=" + index);
                }
                value[i][chan] = sourceValues[index];
            }
        }
        return value;
    }

    private List<Point2D> getAllPointsAlongLine(Line2D line) {
        ArrayList<Point2D> pointslist = new ArrayList<Point2D>();
        int x1 = (int)line.getX1();
        int y1 = (int)line.getY1();
        int x2 = (int)line.getX2();
        int y2 = (int)line.getY2();
        int deltax = Math.abs(x2 - x1);
        int deltay = Math.abs(y2 - y1);
        int error = 0;
        if (deltax > deltay) {
            int y = y1;
            for (int x = x1; x < x2; ++x) {
                pointslist.add(new Point2D.Double(x, y));
                if (2 * (error += deltay) < deltax) continue;
                ++y;
                error -= deltax;
            }
        } else {
            int x = x1;
            for (int y = y1; y < y2; ++y) {
                pointslist.add(new Point2D.Double(x, y));
                if (2 * (error += deltax) < deltay) continue;
                ++x;
                error -= deltay;
            }
        }
        return pointslist;
    }

    public ArrayList<Line2D> getVerticalLinesFromIntervals(Polygon roiPolygon, List<Integer> listofX) {
        ArrayList<Line2D> verticallines = new ArrayList<Line2D>();
        double deltaYTop = roiPolygon.ypoints[3] - roiPolygon.ypoints[0];
        double deltaXTop = roiPolygon.xpoints[3] - roiPolygon.xpoints[0];
        double deltaYBottom = roiPolygon.ypoints[2] - roiPolygon.ypoints[1];
        double deltaXBottom = roiPolygon.xpoints[2] - roiPolygon.xpoints[1];
        double lastX = listofX.get(listofX.size() - 1).intValue();
        for (int i = 0; i < listofX.size(); ++i) {
            int index = listofX.get(i);
            int ixtop = (int)((double)index * deltaXTop / lastX);
            int ixbottom = (int)((double)index * deltaXBottom / lastX);
            Point2D.Double top = new Point2D.Double(roiPolygon.xpoints[0] + ixtop, (double)roiPolygon.ypoints[0] + (double)index * deltaYTop / lastX);
            Point2D.Double bottom = new Point2D.Double(roiPolygon.xpoints[1] + ixbottom, (double)roiPolygon.ypoints[1] + (double)index * deltaYBottom / lastX);
            Line2D.Double line = new Line2D.Double(top, bottom);
            verticallines.add(line);
        }
        return verticallines;
    }

    public ArrayList<Line2D> getHorizontalLinesFromIntervals(Polygon roiPolygon, List<Integer> listofY) {
        ArrayList<Line2D> horizontallines = new ArrayList<Line2D>();
        double deltaYLeft = roiPolygon.ypoints[1] - roiPolygon.ypoints[0];
        double deltaXLeft = roiPolygon.xpoints[1] - roiPolygon.xpoints[0];
        double deltaYRight = roiPolygon.ypoints[2] - roiPolygon.ypoints[3];
        double deltaXRight = roiPolygon.xpoints[2] - roiPolygon.xpoints[3];
        double lastX = listofY.get(listofY.size() - 1).intValue();
        for (int i = 0; i < listofY.size(); ++i) {
            int index = listofY.get(i);
            int iyleft = (int)((double)index * deltaYLeft / lastX);
            int iyright = (int)((double)index * deltaYRight / lastX);
            Point2D.Double left = new Point2D.Double((double)roiPolygon.xpoints[0] + (double)index * deltaXLeft / lastX, roiPolygon.ypoints[0] + iyleft);
            Point2D.Double right = new Point2D.Double((double)roiPolygon.xpoints[3] + (double)index * deltaXRight / lastX, roiPolygon.ypoints[3] + iyright);
            Line2D.Double line = new Line2D.Double(left, right);
            horizontallines.add(line);
        }
        return horizontallines;
    }

    public void buildROIsFromLines(Sequence seq, List<List<Line2D>> linesArray) {
        String[] type = new String[]{"vertical", "horizontal"};
        int itype = 0;
        for (List<Line2D> firstarray : linesArray) {
            int i = 0;
            for (Line2D line : firstarray) {
                ROI2DLine roiL1 = new ROI2DLine(line);
                roiL1.setName(type[itype] + i);
                roiL1.setReadOnly(false);
                roiL1.setColor(Color.RED);
                seq.addROI((ROI)roiL1, true);
                ++i;
            }
            ++itype;
        }
    }

    public int getIndexMinimumValue(double[][] profile) {
        int n = profile.length;
        int imin = 0;
        double valuemin = profile[0][0] + profile[0][1] + profile[0][2];
        for (int chan = 0; chan < 3; ++chan) {
            for (int i = 0; i < n; ++i) {
                double value = profile[i][0] + profile[i][1] + profile[i][2];
                if (!(value < valuemin)) continue;
                valuemin = value;
                imin = i;
            }
        }
        return imin;
    }

    public List<List<Line2D>> buildLinesFromSTDProfile(IcyBufferedImage image, Polygon roiPolygon, double[][] stdXArray, double[][] stdYArray, int threshold, int channel) {
        List<Integer> listofX = this.getTransitions(stdXArray, threshold, channel);
        List<Integer> listofY = this.getTransitions(stdYArray, threshold, channel);
        ArrayList<Line2D> vertlines = this.getVerticalLinesFromIntervals(roiPolygon, listofX);
        ArrayList<Line2D> horzlines = this.getHorizontalLinesFromIntervals(roiPolygon, listofY);
        int averagewidth = (int)(roiPolygon.getBounds().getWidth() / (double)(vertlines.size() - 1));
        int checksize = averagewidth / 3;
        int deltainside = averagewidth / 8;
        for (Line2D line : vertlines) {
            line = this.adjustLine(image, line, checksize, deltainside);
        }
        averagewidth = (int)(roiPolygon.getBounds().getHeight() / (double)(horzlines.size() - 1));
        checksize = averagewidth / 3;
        deltainside = averagewidth / 8;
        for (Line2D line : horzlines) {
            line = this.adjustLine(image, line, checksize, deltainside);
        }
        ArrayList<List<Line2D>> linesArray = new ArrayList<List<Line2D>>();
        linesArray.add(vertlines);
        linesArray.add(horzlines);
        return linesArray;
    }

    private List<Integer> getTransitions(double[][] arrayWithSTDvalues, int userSTDthreshold, int channel) {
        double minSTDvalue;
        ArrayList<Integer> listofpoints = new ArrayList<Integer>();
        listofpoints.add(0);
        boolean bDetectGetDown = true;
        double duserSTDthreshold = userSTDthreshold;
        double previousSTDvalue = minSTDvalue = arrayWithSTDvalues[0][channel];
        int iofminSTDvalue = 0;
        for (int ix = 1; ix < arrayWithSTDvalues.length; ++ix) {
            double value = arrayWithSTDvalues[ix][channel];
            if (bDetectGetDown && previousSTDvalue > duserSTDthreshold && value < duserSTDthreshold) {
                bDetectGetDown = false;
                iofminSTDvalue = ix;
                minSTDvalue = value;
            } else if (!bDetectGetDown) {
                if (value > duserSTDthreshold && previousSTDvalue < duserSTDthreshold) {
                    bDetectGetDown = true;
                    listofpoints.add(iofminSTDvalue);
                } else if (value < minSTDvalue) {
                    minSTDvalue = value;
                    iofminSTDvalue = ix;
                }
            }
            previousSTDvalue = value;
        }
        iofminSTDvalue = arrayWithSTDvalues.length - 1;
        listofpoints.add(iofminSTDvalue);
        return listofpoints;
    }

    public static void convertLinesToSquares(Sequence seq, String baseName, int areaShrinkPCT) {
        ArrayList list = seq.getROI2Ds();
        ArrayList<ROI2DLine> vertRoiLines = new ArrayList<ROI2DLine>();
        ArrayList<ROI2DLine> horizRoiLines = new ArrayList<ROI2DLine>();
        for (ROI2D roi : list) {
            String name = roi.getName();
            if (name.contains("vertical")) {
                vertRoiLines.add((ROI2DLine)roi);
                continue;
            }
            if (!name.contains("horizontal")) continue;
            horizRoiLines.add((ROI2DLine)roi);
        }
        Collections.sort(vertRoiLines, new FmpTools.ROI2DLineLeftXComparator());
        Collections.sort(horizRoiLines, new FmpTools.ROI2DLineLeftYComparator());
        seq.removeAllROI();
        ROI2DLine roih1 = null;
        int row = 0;
        for (ROI2DLine roih2 : horizRoiLines) {
            if (roih1 == null) {
                roih1 = roih2;
                continue;
            }
            ROI2DLine roiv1 = null;
            int col = 0;
            for (ROI2DLine roiv2 : vertRoiLines) {
                if (roiv1 == null) {
                    roiv1 = roiv2;
                    continue;
                }
                ArrayList<Point2D> listpoints = new ArrayList<Point2D>();
                listpoints.add(GeomUtil.getIntersection((Line2D)roiv1.getLine(), (Line2D)roih1.getLine()));
                listpoints.add(GeomUtil.getIntersection((Line2D)roiv1.getLine(), (Line2D)roih2.getLine()));
                listpoints.add(GeomUtil.getIntersection((Line2D)roiv2.getLine(), (Line2D)roih2.getLine()));
                listpoints.add(GeomUtil.getIntersection((Line2D)roiv2.getLine(), (Line2D)roih1.getLine()));
                DefineLinesManually.areaShrink(listpoints, areaShrinkPCT);
                DefineLinesManually.addPolygonROI(seq, listpoints, baseName, col, row);
                roiv1 = roiv2;
                ++col;
            }
            roih1 = roih2;
            ++row;
        }
    }

    private static void areaShrink(List<Point2D> listpoints, int areaShrinkPCT) {
        double xdeltatop = (listpoints.get(3).getX() - listpoints.get(0).getX() + 1.0) * (double)areaShrinkPCT / 200.0;
        double xdeltabottom = (listpoints.get(2).getX() - listpoints.get(1).getX() + 1.0) * (double)areaShrinkPCT / 200.0;
        double ydeltaleft = (listpoints.get(1).getY() - listpoints.get(0).getY() + 1.0) * (double)areaShrinkPCT / 200.0;
        double ydeltaright = (listpoints.get(2).getY() - listpoints.get(3).getY() + 1.0) * (double)areaShrinkPCT / 200.0;
        int i = 0;
        listpoints.get(i).setLocation(listpoints.get(i).getX() + xdeltatop, listpoints.get(i).getY() + ydeltaleft);
        i = 1;
        listpoints.get(i).setLocation(listpoints.get(i).getX() + xdeltabottom, listpoints.get(i).getY() - ydeltaleft);
        i = 2;
        listpoints.get(i).setLocation(listpoints.get(i).getX() - xdeltabottom, listpoints.get(i).getY() - ydeltaright);
        i = 3;
        listpoints.get(i).setLocation(listpoints.get(i).getX() - xdeltatop, listpoints.get(i).getY() + ydeltaright);
    }

    private static void addPolygonROI(Sequence seq, List<Point2D> points, String baseName, int columnnumber, int rownumber) {
        ROI2DPolygon roiP = new ROI2DPolygon(points);
        roiP.setName(baseName + String.format("_R%02d", rownumber) + String.format("_C%02d", columnnumber));
        roiP.setColor(Color.YELLOW);
        seq.addROI((ROI)roiP);
    }

    public static void createROISFromSelectedPolygon(Sequence seq, int ioption, String rootName, double colSpan, double colSize, double nbcols, double rowSpan, double rowSize, double nbrows) {
        ROI2D roi = seq.getSelectedROI2D();
        if (!(roi instanceof ROI2DPolygon)) {
            new AnnounceFrame("Select a 2D ROI polygon");
            return;
        }
        Polygon roiPolygon = FmpTools.orderVerticesofPolygon(((ROI2DPolygon)roi).getPolygon());
        seq.removeAllROI();
        seq.addROI((ROI)roi, true);
        double colsSum = nbcols * (colSize + colSpan) + colSpan;
        double rowsSum = nbrows * (rowSize + rowSpan) + rowSpan;
        String baseName = null;
        int column = 0;
        while ((double)column < nbcols) {
            double ratioX0 = ((colSize + colSpan) * (double)column + colSpan) / colsSum;
            double x = (double)roiPolygon.xpoints[0] + (double)(roiPolygon.xpoints[3] - roiPolygon.xpoints[0]) * ratioX0;
            double y = (double)roiPolygon.ypoints[0] + (double)(roiPolygon.ypoints[3] - roiPolygon.ypoints[0]) * ratioX0;
            Point2D.Double ipoint0 = new Point2D.Double(x, y);
            x = (double)roiPolygon.xpoints[1] + (double)(roiPolygon.xpoints[2] - roiPolygon.xpoints[1]) * ratioX0;
            y = (double)roiPolygon.ypoints[1] + (double)(roiPolygon.ypoints[2] - roiPolygon.ypoints[1]) * ratioX0;
            Point2D.Double ipoint1 = new Point2D.Double(x, y);
            double ratioX1 = (colSize + colSpan) * (double)(column + 1) / colsSum;
            x = (double)roiPolygon.xpoints[1] + (double)(roiPolygon.xpoints[2] - roiPolygon.xpoints[1]) * ratioX1;
            y = (double)roiPolygon.ypoints[1] + (double)(roiPolygon.ypoints[2] - roiPolygon.ypoints[1]) * ratioX1;
            Point2D.Double ipoint2 = new Point2D.Double(x, y);
            x = (double)roiPolygon.xpoints[0] + (double)(roiPolygon.xpoints[3] - roiPolygon.xpoints[0]) * ratioX1;
            y = (double)roiPolygon.ypoints[0] + (double)(roiPolygon.ypoints[3] - roiPolygon.ypoints[0]) * ratioX1;
            Point2D.Double ipoint3 = new Point2D.Double(x, y);
            int row = 0;
            while ((double)row < nbrows) {
                double ratioY0 = ((rowSize + rowSpan) * (double)row + rowSpan) / rowsSum;
                x = ipoint0.x + (ipoint1.x - ipoint0.x) * ratioY0;
                y = ipoint0.y + (ipoint1.y - ipoint0.y) * ratioY0;
                Point2D.Double point0 = new Point2D.Double(x, y);
                x = ipoint3.x + (ipoint2.x - ipoint3.x) * ratioY0;
                y = ipoint3.y + (ipoint2.y - ipoint3.y) * ratioY0;
                Point2D.Double point3 = new Point2D.Double(x, y);
                double ratioY1 = (rowSize + rowSpan) * (double)(row + 1) / rowsSum;
                x = ipoint0.x + (ipoint1.x - ipoint0.x) * ratioY1;
                y = ipoint0.y + (ipoint1.y - ipoint0.y) * ratioY1;
                Point2D.Double point1 = new Point2D.Double(x, y);
                x = ipoint3.x + (ipoint2.x - ipoint3.x) * ratioY1;
                y = ipoint3.y + (ipoint2.y - ipoint3.y) * ratioY1;
                Point2D.Double point2 = new Point2D.Double(x, y);
                ArrayList<Point2D> points = new ArrayList<Point2D>();
                points.add(point0);
                points.add(point1);
                points.add(point2);
                points.add(point3);
                switch (ioption) {
                    case 0: {
                        if (baseName == null) {
                            baseName = rootName + "_line ";
                        }
                        DefineLinesManually.addLineROI(seq, points, baseName, column, row);
                        break;
                    }
                    case 2: {
                        if (baseName == null) {
                            baseName = rootName + "_circle ";
                        }
                        DefineLinesManually.addEllipseROI(seq, points, baseName, column, row);
                        break;
                    }
                    default: {
                        if (baseName == null) {
                            baseName = rootName + "_area ";
                        }
                        DefineLinesManually.addPolygonROI(seq, points, baseName, column, row);
                    }
                }
                ++row;
            }
            ++column;
        }
        ArrayList list = seq.getROI2Ds();
        Collections.sort(list, new FmpTools.ROI2DNameComparator());
    }

    private static void addEllipseROI(Sequence seq, List<Point2D> points, String baseName, int i, int j) {
        ROI2DEllipse roiP = new ROI2DEllipse(points.get(0), points.get(2));
        roiP.setName(baseName + String.format("_r%02d", j) + String.format("_c%02d", i));
        roiP.setColor(Color.YELLOW);
        seq.addROI((ROI)roiP);
    }

    private static void addLineROI(Sequence seq, List<Point2D> points, String baseName, int i, int j) {
        ROI2DLine roiL1 = new ROI2DLine(points.get(0), points.get(1));
        roiL1.setName(baseName + String.format("%02d", i / 2) + "L");
        roiL1.setReadOnly(false);
        roiL1.setColor(Color.YELLOW);
        seq.addROI((ROI)roiL1, true);
        ROI2DLine roiL2 = new ROI2DLine(points.get(2), points.get(3));
        roiL2.setName(baseName + String.format("%02d", i / 2) + "R");
        roiL2.setReadOnly(false);
        roiL2.setColor(Color.YELLOW);
        seq.addROI((ROI)roiL2, true);
    }
}

