/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.tools;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import plugins.fmp.areatrack.sequence.SequenceVirtual;
import plugins.fmp.areatrack.tools.EnumImageOp;

public class ImageTransformTools {
    private IcyBufferedImage referenceImage = null;
    private int spanDiff = 3;
    private SequenceVirtual vinputSequence = null;

    public void setReferenceImage(IcyBufferedImage img) {
        this.referenceImage = IcyBufferedImageUtil.getCopy((IcyBufferedImage)img);
    }

    public void setSpanDiff(int spanDiff) {
        this.spanDiff = spanDiff;
    }

    public int getSpanDiff() {
        return this.spanDiff;
    }

    public void setSequence(SequenceVirtual vinputSeq) {
        this.vinputSequence = vinputSeq;
        this.referenceImage = this.vinputSequence.seq.getImage(0, 0);
    }

    public IcyBufferedImage transformImage(IcyBufferedImage inputImage, EnumImageOp transformop) {
        IcyBufferedImage transformedImage = null;
        switch (transformop) {
            case NONE: 
            case COLORARRAY1: {
                transformedImage = inputImage;
                break;
            }
            case R_RGB: {
                transformedImage = this.functionRGB_keepOneChan(inputImage, 0);
                break;
            }
            case G_RGB: {
                transformedImage = this.functionRGB_keepOneChan(inputImage, 1);
                break;
            }
            case B_RGB: {
                transformedImage = this.functionRGB_keepOneChan(inputImage, 2);
                break;
            }
            case RGB: {
                transformedImage = this.functionRGB_grey(inputImage);
            }
            case H_HSB: {
                transformedImage = this.functionRGBtoHSB(inputImage, 0);
                break;
            }
            case S_HSB: {
                transformedImage = this.functionRGBtoHSB(inputImage, 1);
                break;
            }
            case B_HSB: {
                transformedImage = this.functionRGBtoHSB(inputImage, 2);
                break;
            }
            case R2MINUS_GB: {
                transformedImage = this.functionRGB_2C3MinusC1C2(inputImage, 1, 2, 0);
                break;
            }
            case G2MINUS_RB: {
                transformedImage = this.functionRGB_2C3MinusC1C2(inputImage, 0, 2, 1);
                break;
            }
            case B2MINUS_RG: {
                transformedImage = this.functionRGB_2C3MinusC1C2(inputImage, 0, 1, 2);
                break;
            }
            case GBMINUS_2R: {
                transformedImage = this.functionRGB_C1C2minus2C3(inputImage, 1, 2, 0);
                break;
            }
            case RBMINUS_2G: {
                transformedImage = this.functionRGB_C1C2minus2C3(inputImage, 0, 2, 1);
                break;
            }
            case RGMINUS_2B: {
                transformedImage = this.functionRGB_C1C2minus2C3(inputImage, 0, 1, 2);
                break;
            }
            case NORM_BRMINUSG: {
                transformedImage = this.functionNormRGB_sumC1C2Minus2C3(inputImage, 1, 2, 0);
                break;
            }
            case RTOGB: {
                transformedImage = this.functionTransferRedToGreenAndBlue(inputImage);
                break;
            }
            case REF_T0: {
                transformedImage = this.functionSubtractRef(inputImage);
                break;
            }
            case REF: {
                transformedImage = this.functionSubtractRef(inputImage);
                break;
            }
            case REF_PREVIOUS: {
                int t = this.vinputSequence.currentFrame;
                if (t <= 0) break;
                this.referenceImage = this.vinputSequence.seq.getImage(t - 1, 0);
                transformedImage = this.functionSubtractRef(inputImage);
                break;
            }
            case XDIFFN: {
                transformedImage = this.computeXDiffn(inputImage);
                break;
            }
            case YDIFFN: {
                transformedImage = this.computeYDiffn(inputImage);
                break;
            }
            case XYDIFFN: {
                transformedImage = this.computeXYDiffn(inputImage);
                break;
            }
            case RGB_TO_HSV: {
                transformedImage = this.functionRGBtoHSV(inputImage);
                break;
            }
            case RGB_TO_H1H2H3: {
                transformedImage = this.functionRGBtoH1H2H3(inputImage);
            }
        }
        return transformedImage;
    }

    public IcyBufferedImage transformImageFromVirtualSequence(int t, EnumImageOp transformop) {
        return this.transformImage(this.vinputSequence.seq.getImage(t, 0), transformop);
    }

    private IcyBufferedImage functionNormRGB_sumC1C2Minus2C3(IcyBufferedImage sourceImage, int Rlayer, int Glayer, int Blayer) {
        double[] Rn = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(Rlayer), (boolean)sourceImage.isSignedDataType());
        double[] Gn = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(Glayer), (boolean)sourceImage.isSignedDataType());
        double[] Bn = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(Blayer), (boolean)sourceImage.isSignedDataType());
        double[] ExG = (double[])Array1DUtil.createArray((DataType)DataType.DOUBLE, (int)Rn.length);
        for (int i = 0; i < Rn.length; ++i) {
            double sum = Rn[i] / 255.0 + Gn[i] / 255.0 + Bn[i] / 255.0;
            ExG[i] = (Gn[i] * 2.0 / 255.0 / sum - Rn[i] / 255.0 / sum - Bn[i] / 255.0 / sum) * 255.0;
        }
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 1, sourceImage.getDataType_());
        Array1DUtil.doubleArrayToSafeArray((double[])ExG, (Object)img2.getDataXY(0), (boolean)false);
        img2.setDataXY(0, img2.getDataXY(0));
        return img2;
    }

    private IcyBufferedImage functionTransferRedToGreenAndBlue(IcyBufferedImage sourceImage) {
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 3, sourceImage.getDataType_());
        img2.copyData((BufferedImage)sourceImage, 0, 0);
        img2.copyData((BufferedImage)sourceImage, 0, 1);
        img2.copyData((BufferedImage)sourceImage, 0, 2);
        return img2;
    }

    private IcyBufferedImage functionRGB_2C3MinusC1C2(IcyBufferedImage sourceImage, int addchan1, int addchan2, int subtractchan3) {
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 1, sourceImage.getDataType_());
        double[] tabSubtract = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(subtractchan3), (boolean)sourceImage.isSignedDataType());
        double[] tabAdd1 = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(addchan1), (boolean)sourceImage.isSignedDataType());
        double[] tabAdd2 = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(addchan2), (boolean)sourceImage.isSignedDataType());
        double[] tabResult = (double[])Array1DUtil.createArray((DataType)DataType.DOUBLE, (int)tabSubtract.length);
        for (int i = 0; i < tabResult.length; ++i) {
            double val;
            tabResult[i] = val = tabSubtract[i] * 2.0 - tabAdd1[i] - tabAdd2[i];
        }
        Array1DUtil.doubleArrayToSafeArray((double[])tabResult, (Object)img2.getDataXY(0), (boolean)false);
        img2.setDataXY(0, img2.getDataXY(0));
        return img2;
    }

    private IcyBufferedImage functionRGB_C1C2minus2C3(IcyBufferedImage sourceImage, int addchan1, int addchan2, int subtractchan3) {
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 1, sourceImage.getDataType_());
        if (sourceImage.getSizeC() < 3) {
            return null;
        }
        double[] tabSubtract = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(subtractchan3), (boolean)sourceImage.isSignedDataType());
        double[] tabAdd1 = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(addchan1), (boolean)sourceImage.isSignedDataType());
        double[] tabAdd2 = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(addchan2), (boolean)sourceImage.isSignedDataType());
        double[] tabResult = (double[])Array1DUtil.createArray((DataType)DataType.DOUBLE, (int)tabSubtract.length);
        for (int i = 0; i < tabResult.length; ++i) {
            tabResult[i] = tabAdd1[i] + tabAdd2[i] - tabSubtract[i] * 2.0;
        }
        Array1DUtil.doubleArrayToSafeArray((double[])tabResult, (Object)img2.getDataXY(0), (boolean)false);
        img2.setDataXY(0, img2.getDataXY(0));
        return img2;
    }

    private IcyBufferedImage computeXDiffn(IcyBufferedImage sourceImage) {
        int chan0 = 0;
        int chan1 = sourceImage.getSizeC();
        int imageSizeX = sourceImage.getSizeX();
        int imageSizeY = sourceImage.getSizeY();
        IcyBufferedImage img2 = new IcyBufferedImage(imageSizeX, imageSizeY, 3, sourceImage.getDataType_());
        for (int c = chan0; c < chan1; ++c) {
            double[] tabValues = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(c), (boolean)sourceImage.isSignedDataType());
            double[] outValues = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(c), (boolean)img2.isSignedDataType());
            for (int iy = 0; iy < imageSizeY; ++iy) {
                int ix;
                for (int ix2 = 0; ix2 < this.spanDiff; ++ix2) {
                    outValues[ix2 + iy * imageSizeX] = 0.0;
                }
                int deltay = iy * imageSizeX;
                for (ix = this.spanDiff; ix < imageSizeX - this.spanDiff; ++ix) {
                    int kx = ix + deltay;
                    int deltax = 0;
                    double outVal = 0.0;
                    for (int ispan = 1; ispan < this.spanDiff; ++ispan) {
                        outVal += tabValues[kx + ++deltax] - tabValues[kx - deltax];
                    }
                    outValues[kx] = (int)Math.abs(outVal);
                }
                for (ix = imageSizeX - this.spanDiff; ix < imageSizeX; ++ix) {
                    outValues[ix + iy * imageSizeX] = 0.0;
                }
            }
            Array1DUtil.doubleArrayToSafeArray((double[])outValues, (Object)img2.getDataXY(c), (boolean)false);
            img2.setDataXY(c, img2.getDataXY(c));
        }
        return img2;
    }

    private IcyBufferedImage computeYDiffn(IcyBufferedImage sourceImage) {
        int chan0 = 0;
        int chan1 = sourceImage.getSizeC();
        int imageSizeX = sourceImage.getSizeX();
        int imageSizeY = sourceImage.getSizeY();
        IcyBufferedImage img2 = new IcyBufferedImage(imageSizeX, imageSizeY, 1, sourceImage.getDataType_());
        for (int c = chan0; c < chan1; ++c) {
            double[] tabValues = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(c), (boolean)sourceImage.isSignedDataType());
            double[] outValues = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(c), (boolean)img2.isSignedDataType());
            for (int ix = this.spanDiff; ix < imageSizeX - this.spanDiff; ++ix) {
                for (int iy = this.spanDiff; iy < imageSizeY - this.spanDiff; ++iy) {
                    int kx = ix + iy * imageSizeX;
                    int deltax = 0;
                    double outVal = 0.0;
                    for (int ispan = 1; ispan < this.spanDiff; ++ispan) {
                        outVal += tabValues[kx + (deltax += imageSizeX)] - tabValues[kx - deltax];
                    }
                    outValues[kx] = (int)Math.abs(outVal);
                }
            }
            Array1DUtil.doubleArrayToSafeArray((double[])outValues, (Object)img2.getDataXY(c), (boolean)false);
            img2.setDataXY(c, img2.getDataXY(c));
        }
        return img2;
    }

    private IcyBufferedImage computeXYDiffn(IcyBufferedImage sourceImage) {
        int chan0 = 0;
        int chan1 = sourceImage.getSizeC();
        int imageSizeX = sourceImage.getSizeX();
        int imageSizeY = sourceImage.getSizeY();
        IcyBufferedImage img2 = new IcyBufferedImage(imageSizeX, imageSizeY, 1, sourceImage.getDataType_());
        for (int c = chan0; c < chan1; ++c) {
            double[] tabValues = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(c), (boolean)sourceImage.isSignedDataType());
            double[] outValues = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(c), (boolean)img2.isSignedDataType());
            for (int ix = 0; ix < imageSizeX; ++ix) {
                int iy;
                for (iy = this.spanDiff; iy < imageSizeY - this.spanDiff; ++iy) {
                    int ky = ix + iy * imageSizeX;
                    int deltay = 0;
                    double outVal = 0.0;
                    for (int ispan = 1; ispan < this.spanDiff; ++ispan) {
                        outVal += tabValues[ky + (deltay += imageSizeX)] - tabValues[ky - deltay];
                    }
                    int deltax = 0;
                    int yspan2 = 10;
                    if (ix > yspan2 && ix < imageSizeX - yspan2) {
                        for (int ispan = 1; ispan < yspan2; ++ispan) {
                            outVal += tabValues[ky + ++deltax] - tabValues[ky - deltax];
                        }
                    }
                    outValues[ky] = (int)Math.abs(outVal);
                }
                for (iy = 0; iy < this.spanDiff; ++iy) {
                    outValues[ix + iy * imageSizeX] = 0.0;
                }
                for (iy = imageSizeY - this.spanDiff; iy < imageSizeY; ++iy) {
                    outValues[ix + iy * imageSizeX] = 0.0;
                }
            }
            Array1DUtil.doubleArrayToSafeArray((double[])outValues, (Object)img2.getDataXY(c), (boolean)false);
            img2.setDataXY(c, img2.getDataXY(c));
        }
        return img2;
    }

    private IcyBufferedImage functionRGB_keepOneChan(IcyBufferedImage sourceImage, int keepChan) {
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 1, sourceImage.getDataType_());
        img2.copyData((BufferedImage)sourceImage, keepChan, 0);
        return img2;
    }

    private IcyBufferedImage functionRGB_grey(IcyBufferedImage sourceImage) {
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 1, sourceImage.getDataType_());
        int[] tabValuesR = Array1DUtil.arrayToIntArray((Object)sourceImage.getDataXY(0), (boolean)sourceImage.isSignedDataType());
        int[] tabValuesG = Array1DUtil.arrayToIntArray((Object)sourceImage.getDataXY(1), (boolean)sourceImage.isSignedDataType());
        int[] tabValuesB = Array1DUtil.arrayToIntArray((Object)sourceImage.getDataXY(2), (boolean)sourceImage.isSignedDataType());
        int[] outValues0 = Array1DUtil.arrayToIntArray((Object)img2.getDataXY(0), (boolean)sourceImage.isSignedDataType());
        for (int ky = 0; ky < outValues0.length; ++ky) {
            outValues0[ky] = (tabValuesR[ky] + tabValuesG[ky] + tabValuesB[ky]) / 3;
        }
        Object dataArray = img2.getDataXY(0);
        Array1DUtil.intArrayToSafeArray((int[])outValues0, (Object)dataArray, (boolean)sourceImage.isSignedDataType(), (boolean)false);
        img2.setDataXY(0, dataArray);
        return img2;
    }

    private IcyBufferedImage functionRGBtoHSB(IcyBufferedImage sourceImage, int xHSB) {
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 3, sourceImage.getDataType_());
        double[] tabValuesR = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(0), (boolean)sourceImage.isSignedDataType());
        double[] tabValuesG = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(1), (boolean)sourceImage.isSignedDataType());
        double[] tabValuesB = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(2), (boolean)sourceImage.isSignedDataType());
        double[] outValues0 = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(0), (boolean)img2.isSignedDataType());
        double[] outValues1 = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(1), (boolean)img2.isSignedDataType());
        double[] outValues2 = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(2), (boolean)img2.isSignedDataType());
        for (int ky = 0; ky < tabValuesR.length; ++ky) {
            double val;
            int R = (int)tabValuesR[ky];
            int G = (int)tabValuesG[ky];
            int B = (int)tabValuesB[ky];
            float[] hsb = Color.RGBtoHSB(R, G, B, null);
            outValues0[ky] = val = (double)hsb[xHSB] * 100.0;
            outValues1[ky] = val;
            outValues2[ky] = val;
        }
        Array1DUtil.doubleArrayToSafeArray((double[])outValues0, (Object)img2.getDataXY(0), (boolean)false);
        img2.setDataXY(0, img2.getDataXY(0));
        Array1DUtil.doubleArrayToSafeArray((double[])outValues1, (Object)img2.getDataXY(1), (boolean)false);
        img2.setDataXY(1, img2.getDataXY(1));
        Array1DUtil.doubleArrayToSafeArray((double[])outValues2, (Object)img2.getDataXY(2), (boolean)false);
        img2.setDataXY(2, img2.getDataXY(2));
        return img2;
    }

    private IcyBufferedImage functionSubtractRef(IcyBufferedImage sourceImage) {
        if (this.referenceImage == null) {
            this.referenceImage = this.vinputSequence.seq.getImage(0, 0);
        }
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getSizeX(), sourceImage.getSizeY(), sourceImage.getSizeC(), sourceImage.getDataType_());
        for (int c = 0; c < sourceImage.getSizeC(); ++c) {
            int[] imgSourceInt = Array1DUtil.arrayToIntArray((Object)sourceImage.getDataXY(0), (boolean)sourceImage.isSignedDataType());
            int[] img2Int = Array1DUtil.arrayToIntArray((Object)img2.getDataXY(0), (boolean)img2.isSignedDataType());
            int[] imgReferenceInt = Array1DUtil.arrayToIntArray((Object)this.referenceImage.getDataXY(0), (boolean)this.referenceImage.isSignedDataType());
            for (int i = 0; i < imgSourceInt.length; ++i) {
                int val = imgSourceInt[i] - imgReferenceInt[i];
                if (val < 0) {
                    val = -val;
                }
                img2Int[i] = 255 - val;
            }
            Array1DUtil.intArrayToSafeArray((int[])img2Int, (Object)img2.getDataXY(c), (boolean)true, (boolean)false);
            img2.setDataXY(c, img2.getDataXY(c));
        }
        return img2;
    }

    private IcyBufferedImage functionRGBtoHSV(IcyBufferedImage sourceImage) {
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 3, sourceImage.getDataType_());
        double[] tabValuesR = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(0), (boolean)sourceImage.isSignedDataType());
        double[] tabValuesG = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(1), (boolean)sourceImage.isSignedDataType());
        double[] tabValuesB = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(2), (boolean)sourceImage.isSignedDataType());
        double[] outValues0 = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(0), (boolean)img2.isSignedDataType());
        double[] outValues1 = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(1), (boolean)img2.isSignedDataType());
        double[] outValues2 = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(2), (boolean)img2.isSignedDataType());
        float[] hsb = new float[3];
        for (int ky = 0; ky < tabValuesR.length; ++ky) {
            int R = (int)tabValuesR[ky];
            int G = (int)tabValuesG[ky];
            int B = (int)tabValuesB[ky];
            hsb = Color.RGBtoHSB(R, G, B, hsb);
            outValues0[ky] = hsb[0];
            outValues1[ky] = hsb[1];
            outValues2[ky] = hsb[2];
        }
        Array1DUtil.doubleArrayToSafeArray((double[])outValues0, (Object)img2.getDataXY(0), (boolean)false);
        img2.setDataXY(0, img2.getDataXY(0));
        Array1DUtil.doubleArrayToSafeArray((double[])outValues1, (Object)img2.getDataXY(1), (boolean)false);
        img2.setDataXY(1, img2.getDataXY(1));
        Array1DUtil.doubleArrayToSafeArray((double[])outValues2, (Object)img2.getDataXY(2), (boolean)false);
        img2.setDataXY(2, img2.getDataXY(2));
        return img2;
    }

    private IcyBufferedImage functionRGBtoH1H2H3(IcyBufferedImage sourceImage) {
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 3, sourceImage.getDataType_());
        double[] tabValuesR = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(0), (boolean)sourceImage.isSignedDataType());
        double[] tabValuesG = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(1), (boolean)sourceImage.isSignedDataType());
        double[] tabValuesB = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(2), (boolean)sourceImage.isSignedDataType());
        double[] outValues0 = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(0), (boolean)img2.isSignedDataType());
        double[] outValues1 = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(1), (boolean)img2.isSignedDataType());
        double[] outValues2 = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(2), (boolean)img2.isSignedDataType());
        double VMAX = 255.0;
        for (int ky = 0; ky < tabValuesR.length; ++ky) {
            int r = (int)tabValuesR[ky];
            int g = (int)tabValuesG[ky];
            int b = (int)tabValuesB[ky];
            outValues0[ky] = (double)(r + g) / 2.0;
            outValues1[ky] = (255.0 + (double)r - (double)g) / 2.0;
            outValues2[ky] = (255.0 + (double)b - (double)(r + g) / 2.0) / 2.0;
        }
        Array1DUtil.doubleArrayToSafeArray((double[])outValues0, (Object)img2.getDataXY(0), (boolean)false);
        img2.setDataXY(0, img2.getDataXY(0));
        Array1DUtil.doubleArrayToSafeArray((double[])outValues1, (Object)img2.getDataXY(1), (boolean)false);
        img2.setDataXY(1, img2.getDataXY(1));
        Array1DUtil.doubleArrayToSafeArray((double[])outValues2, (Object)img2.getDataXY(2), (boolean)false);
        img2.setDataXY(2, img2.getDataXY(2));
        return img2;
    }
}

