/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.sequence;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import plugins.fmp.areatrack.sequence.Capillaries;
import plugins.fmp.areatrack.sequence.EnumStatus;
import plugins.fmp.areatrack.tools.ImageOperationsStruct;

public class SequenceVirtual {
    public Sequence seq = null;
    private List<String> imagesList = null;
    private String csFileName = null;
    private String directory = null;
    protected String csCamFileName = null;
    public IcyBufferedImage refImage = null;
    public int analysisStart = 0;
    public int analysisEnd = 99999999;
    public int analysisStep = 1;
    public int currentFrame = 0;
    public int nTotalFrames = 0;
    public EnumStatus statusSequenceVirtual = EnumStatus.REGULAR;
    public Capillaries capillariesRoi2RoiArray = new Capillaries();
    public String[] seriesname = null;
    public int[][] data_raw = null;
    public double[][] data_filtered = null;
    public IcyBufferedImage cacheTransformedImage = null;
    public ImageOperationsStruct cacheTransformOp = new ImageOperationsStruct();
    public IcyBufferedImage cacheThresholdedImage = null;
    public ImageOperationsStruct cacheThresholdOp = new ImageOperationsStruct();

    public SequenceVirtual() {
        this.seq = new Sequence();
        this.statusSequenceVirtual = EnumStatus.REGULAR;
    }

    public SequenceVirtual(Sequence seq) {
        this.seq = seq;
        this.statusSequenceVirtual = EnumStatus.REGULAR;
        this.nTotalFrames = seq.getSizeT();
        this.analysisEnd = this.nTotalFrames - 1;
        String filename = seq.getFilename();
        Path path = Paths.get(filename, new String[0]);
        Path parent = path.getParent();
        this.directory = parent.toString();
    }

    public SequenceVirtual(String name, IcyBufferedImage image) {
        this.seq = new Sequence(name, image);
        this.statusSequenceVirtual = EnumStatus.FILESTACK;
    }

    public SequenceVirtual(List<String> listNames) {
        this.setV2ImagesList(listNames);
        this.statusSequenceVirtual = EnumStatus.FILESTACK;
    }

    public void setV2ImagesList(List<String> extImagesList) {
        if (this.imagesList != null) {
            this.imagesList.clear();
        } else {
            this.imagesList = new ArrayList<String>(extImagesList.size());
        }
        this.imagesList.addAll(extImagesList);
        this.nTotalFrames = this.imagesList.size();
        this.statusSequenceVirtual = EnumStatus.FILESTACK;
    }

    public void close() {
        this.seq.close();
    }

    public String getDirectory() {
        if (this.directory == null) {
            return this.getDirectoryFromSequence();
        }
        return this.directory;
    }

    public String getDirectoryFromSequence() {
        if (this.seq == null) {
            return null;
        }
        String filename = this.seq.getFilename();
        Path path = Paths.get(filename, new String[0]);
        Path parent = path.getParent();
        this.directory = parent.toString();
        return this.directory;
    }

    public IcyBufferedImage getSeqImage(int t, int z) {
        this.currentFrame = t;
        return this.seq.getImage(t, z);
    }

    public List<String> getListofFiles() {
        return this.imagesList;
    }

    public int getSizeT() {
        if (this.statusSequenceVirtual == EnumStatus.REGULAR || this.statusSequenceVirtual == EnumStatus.FILESTACK) {
            return this.seq.getSizeT();
        }
        return this.nTotalFrames;
    }

    public int getT() {
        return this.currentFrame;
    }

    public String getFileName(int t) {
        String csName = null;
        if (this.statusSequenceVirtual == EnumStatus.FILESTACK) {
            csName = this.imagesList.get(t);
        } else if (this.statusSequenceVirtual == EnumStatus.AVIFILE) {
            csName = this.csFileName;
        }
        return csName;
    }

    public boolean isFileStack() {
        return this.statusSequenceVirtual == EnumStatus.FILESTACK;
    }

    public void setSequenceImage(int t, int z, BufferedImage bimage) throws IllegalArgumentException {
        this.seq.setImage(t, z, bimage);
        this.currentFrame = t;
    }

    public void attachSequence(Sequence seq) {
        this.seq = seq;
        this.statusSequenceVirtual = EnumStatus.FILESTACK;
        this.analysisStart = 0;
    }

    public IcyBufferedImage imageIORead(String name) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(name));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return IcyBufferedImage.createFrom((BufferedImage)image);
    }
}

