/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.splitroitoarray;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.areatrack.splitroitoarray.DefineLinesManually;
import plugins.fmp.areatrack.tools.FmpTools;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class DetectLinesSTD {
    private static double[][] stdXArray = null;
    private static double[][] stdYArray = null;
    private static IcyFrame mainChartFrame = null;

    public static void buildAutoGrid(Sequence seq, int t, String choice, int threshold) {
        ROI2D roi = seq.getSelectedROI2D();
        if (!(roi instanceof ROI2DPolygon)) {
            new AnnounceFrame("The frame must be a ROI 2D POLYGON");
            return;
        }
        Polygon roiPolygon = FmpTools.orderVerticesofPolygon(((ROI2DPolygon)roi).getPolygon());
        seq.removeAllROI();
        seq.addROI((ROI)roi, true);
        int channel = 0;
        channel = choice.contains("R+B-2G") ? 3 : (choice.contains("R") ? 0 : (choice.contains("G") ? 1 : 2));
        DefineLinesManually lineTools = new DefineLinesManually();
        IcyBufferedImage image = seq.getImage(t, 0);
        List<List<Line2D>> linesArray = lineTools.buildLinesFromSTDProfile(image, roiPolygon, stdXArray, stdYArray, threshold, channel);
        lineTools.buildROIsFromLines(seq, linesArray);
    }

    public static void findLines(Sequence seq, int t) {
        ROI2D roi = seq.getSelectedROI2D();
        if (!(roi instanceof ROI2DPolygon)) {
            new AnnounceFrame("The frame must be a ROI2D POLYGON");
            return;
        }
        Polygon roiPolygon = FmpTools.orderVerticesofPolygon(((ROI2DPolygon)roi).getPolygon());
        seq.removeAllROI();
        seq.addROI((ROI)roi, true);
        DetectLinesSTD.getSTD(seq, t, roiPolygon.getBounds());
        DetectLinesSTD.getSTDRBminus2G();
        DetectLinesSTD.graphDisplay2Panels(seq, stdXArray, stdYArray);
    }

    private static void getSTDRBminus2G() {
        int i;
        for (i = 0; i < stdXArray.length; ++i) {
            DetectLinesSTD.stdXArray[i][3] = stdXArray[i][0] + stdXArray[i][2] - 2.0 * stdXArray[i][1];
        }
        for (i = 0; i < stdYArray.length; ++i) {
            DetectLinesSTD.stdYArray[i][3] = stdYArray[i][0] + stdYArray[i][2] - 2.0 * stdYArray[i][1];
        }
    }

    public static void getSTD(Sequence seq, int t, Rectangle rect) {
        int chan;
        Point2D.Double[] refpoint = new Point2D.Double[]{new Point2D.Double(rect.x, rect.y), new Point2D.Double(rect.x, rect.y + rect.height - 1), new Point2D.Double(rect.x + rect.width - 1, rect.y + rect.height - 1), new Point2D.Double(rect.x + rect.width - 1, rect.y)};
        int nYpoints = (int)(refpoint[1].y - refpoint[0].y + 1.0);
        int nXpoints = (int)(refpoint[3].x - refpoint[0].x + 1.0);
        double[][] sumXArray = new double[nXpoints][3];
        double[][] sum2XArray = new double[nXpoints][3];
        double[][] countXArray = new double[nXpoints][3];
        stdXArray = new double[nXpoints][4];
        double[][] sumYArray = new double[nYpoints][3];
        double[][] sum2YArray = new double[nYpoints][3];
        double[][] countYArray = new double[nYpoints][3];
        stdYArray = new double[nYpoints][4];
        for (chan = 0; chan < 3; ++chan) {
            IcyBufferedImage virtualImage = seq.getImage(t, 0, chan);
            if (virtualImage == null) {
                System.out.println("An error occurred while reading image: " + t);
                return;
            }
            int widthImage = virtualImage.getSizeX();
            double[] image1DArray = Array1DUtil.arrayToDoubleArray((Object)virtualImage.getDataXY(0), (boolean)virtualImage.isSignedDataType());
            double deltaXUp = refpoint[3].x - refpoint[0].x + 1.0;
            double deltaXDown = refpoint[2].x - refpoint[1].x + 1.0;
            double deltaYUp = refpoint[3].y - refpoint[0].y + 1.0;
            double deltaYDown = refpoint[2].y - refpoint[1].y + 1.0;
            for (int ix = 0; ix < nXpoints; ++ix) {
                double xUp = refpoint[0].x + deltaXUp * (double)ix / (double)nXpoints;
                double yUp = refpoint[0].y + deltaYUp * (double)ix / (double)nXpoints;
                double xDown = refpoint[1].x + deltaXDown * (double)ix / (double)nXpoints;
                double yDown = refpoint[1].y + deltaYDown * (double)ix / (double)nXpoints;
                for (int iy = 0; iy < nYpoints; ++iy) {
                    double x = xUp + (xDown - xUp + 1.0) * (double)iy / (double)nYpoints;
                    double y = yUp + (yDown - yUp + 1.0) * (double)iy / (double)nYpoints;
                    int index = (int)x + (int)y * widthImage;
                    double value = image1DArray[index];
                    double value2 = value * value;
                    sumXArray[ix][chan] = sumXArray[ix][chan] + value;
                    sum2XArray[ix][chan] = sum2XArray[ix][chan] + value2;
                    countXArray[ix][chan] = countXArray[ix][chan] + 1.0;
                    sumYArray[iy][chan] = sumYArray[iy][chan] + value;
                    sum2YArray[iy][chan] = sum2YArray[iy][chan] + value2;
                    countYArray[iy][chan] = countYArray[iy][chan] + 1.0;
                }
            }
        }
        for (chan = 0; chan < 3; ++chan) {
            double sumsum;
            double sum2;
            for (int ix = 0; ix < nXpoints; ++ix) {
                double n = countXArray[ix][chan];
                sum2 = sum2XArray[ix][chan];
                sumsum = sumXArray[ix][chan];
                sumsum = sumsum * sumXArray[ix][chan] / n;
                DetectLinesSTD.stdXArray[ix][chan] = (sum2 - sumsum) / (n - 1.0);
            }
            for (int iy = 0; iy < nYpoints; ++iy) {
                double n = countYArray[iy][chan];
                sum2 = sum2YArray[iy][chan];
                sumsum = sumYArray[iy][chan];
                sumsum = sumsum * sumYArray[iy][chan] / n;
                DetectLinesSTD.stdYArray[iy][chan] = (sum2 - sumsum) / (n - 1.0);
            }
        }
    }

    private static void graphDisplay2Panels(Sequence seq, double[][] arrayX, double[][] arrayY) {
        if (mainChartFrame != null) {
            mainChartFrame.removeAll();
            mainChartFrame.close();
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 2));
        String localtitle = "Variance along X and Y";
        mainChartFrame = GuiUtil.generateTitleFrame((String)localtitle, (JPanel)new JPanel(), (Dimension)new Dimension(1400, 800), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        int totalpoints = 0;
        ArrayList<XYSeriesCollection> xyDataSetList = new ArrayList<XYSeriesCollection>();
        XYSeriesCollection xyDataset = DetectLinesSTD.graphCreateXYDataSet(arrayX, "X chan ");
        xyDataSetList.add(xyDataset);
        totalpoints += xyDataset.getSeries(0).getItemCount();
        xyDataset = DetectLinesSTD.graphCreateXYDataSet(arrayY, "Y chan ");
        xyDataSetList.add(xyDataset);
        totalpoints += xyDataset.getSeries(0).getItemCount();
        for (int i = 0; i < xyDataSetList.size(); ++i) {
            xyDataset = (XYSeriesCollection)xyDataSetList.get(i);
            int npoints = xyDataset.getSeries(0).getItemCount();
            JFreeChart xyChart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            xyChart.setAntiAlias(true);
            xyChart.setTextAntiAlias(true);
            int drawWidth = npoints * 800 / totalpoints;
            int drawHeight = 400;
            ChartPanel xyChartPanel = new ChartPanel(xyChart, drawWidth, drawHeight, drawWidth, drawHeight, drawWidth, drawHeight, false, false, true, true, true, true);
            mainPanel.add((Component)xyChartPanel);
        }
        mainChartFrame.add((Component)mainPanel);
        mainChartFrame.pack();
        Viewer v = seq.getFirstViewer();
        Rectangle rectv = v.getBounds();
        Point pt = new Point((int)rectv.getX(), (int)rectv.getY() + 30);
        mainChartFrame.setLocation(pt);
        mainChartFrame.setVisible(true);
        mainChartFrame.addToDesktopPane();
        mainChartFrame.requestFocus();
    }

    private static XYSeriesCollection graphCreateXYDataSet(double[][] array, String rootName) {
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        for (int chan = 0; chan < 4; ++chan) {
            XYSeries seriesXY = new XYSeries((Comparable)((Object)(rootName + chan)));
            if (chan == 3) {
                seriesXY.setDescription("1-2 + 3-2");
            }
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                double value = array[i][chan];
                seriesXY.add((double)i, value);
            }
            xyDataset.addSeries(seriesXY);
        }
        return xyDataset;
    }
}

