/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.splitroitoarray;

import icy.gui.component.PopupPanel;
import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.areatrack.Areatrack;
import plugins.fmp.areatrack.sequence.SequenceVirtual;
import plugins.fmp.areatrack.splitroitoarray.DefineLinesManually;
import plugins.fmp.areatrack.splitroitoarray.DlgOutputData;

public class DlgDefineLinesManually
extends JPanel {
    private static final long serialVersionUID = -9143775308853070401L;
    JLabel txtSplitAsComboBox = new JLabel("Split polygon as ");
    JComboBox<String> splitAsComboBox = new JComboBox<String>(new String[]{"polygons", "ellipses"});
    JLabel txtNumberOfColumns = new JLabel("N columns ");
    JSpinner ezNumberOfColumns = new JSpinner(new SpinnerNumberModel(5, 1, 10000, 1));
    JLabel txtColumnWidth = new JLabel("column width");
    JSpinner columnWidth = new JSpinner(new SpinnerNumberModel(10, 0, 10000, 1));
    JLabel txtColumnSpan = new JLabel("space btw. col. ");
    JSpinner columnSpan = new JSpinner(new SpinnerNumberModel(1, 0, 10000, 1));
    JLabel txtNumberOfRows = new JLabel("N rows ");
    JSpinner ezNumberOfRows = new JSpinner(new SpinnerNumberModel(10, 1, 10000, 1));
    JLabel txtRowHeight = new JLabel("row height ");
    JSpinner rowHeight = new JSpinner(new SpinnerNumberModel(10, 0, 10000, 1));
    JLabel txtRowSpan = new JLabel("space btw. row ");
    JSpinner rowInterval = new JSpinner(new SpinnerNumberModel(1, 0, 10000, 1));
    JButton generateGridButton = new JButton("Create grid");
    Areatrack areatrack = null;
    private SequenceVirtual sequenceVirtual = null;
    private DlgOutputData dlgOutputData = null;

    public void init(Areatrack areatrack, final IcyFrame dialogFrame, JPanel mainPanel, DlgOutputData dlgOutputData) {
        this.areatrack = areatrack;
        this.dlgOutputData = dlgOutputData;
        this.sequenceVirtual = areatrack.vSequence;
        this.splitAsComboBox.setSelectedIndex(1);
        PopupPanel popuppanel2 = new PopupPanel("define lines manually");
        JPanel panel2 = popuppanel2.getMainPanel();
        panel2.setLayout(new GridLayout(8, 2));
        panel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.txtSplitAsComboBox, this.splitAsComboBox}));
        panel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.txtNumberOfColumns, this.ezNumberOfColumns}));
        panel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.txtColumnWidth, this.columnWidth}));
        panel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.txtColumnSpan, this.columnSpan}));
        panel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.txtNumberOfRows, this.ezNumberOfRows}));
        panel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.txtRowHeight, this.rowHeight}));
        panel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.txtRowSpan, this.rowInterval}));
        panel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.generateGridButton}));
        mainPanel.add((Component)popuppanel2);
        popuppanel2.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                dialogFrame.revalidate();
                dialogFrame.pack();
                dialogFrame.repaint();
            }
        });
        popuppanel2.collapse();
        this.addActionListeners();
    }

    void addActionListeners() {
        this.generateGridButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgDefineLinesManually.this.generateGrid();
            }
        });
    }

    protected void generateGrid() {
        Sequence seq = this.sequenceVirtual.seq;
        double colSpan = ((Integer)this.columnSpan.getValue()).intValue();
        double colSize = ((Integer)this.columnWidth.getValue()).intValue();
        double nbcols = ((Integer)this.ezNumberOfColumns.getValue()).intValue();
        double rowSpan = ((Integer)this.rowInterval.getValue()).intValue();
        double rowSize = ((Integer)this.rowHeight.getValue()).intValue();
        double nbrows = ((Integer)this.ezNumberOfRows.getValue()).intValue();
        String rootName = (String)this.dlgOutputData.ezRootnameComboBox.getSelectedItem();
        int choice = this.splitAsComboBox.getSelectedIndex();
        switch (choice) {
            case 1: {
                DefineLinesManually.createROISFromSelectedPolygon(seq, 2, rootName, colSpan, colSize, nbcols, rowSpan, rowSize, nbrows);
                break;
            }
            default: {
                DefineLinesManually.createROISFromSelectedPolygon(seq, 1, rootName, colSpan, colSize, nbcols, rowSpan, rowSize, nbrows);
            }
        }
    }
}

