/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.dlg;

import icy.gui.component.PopupPanel;
import icy.gui.frame.IcyFrame;
import icy.gui.util.FontUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import plugins.fmp.areatrack.Areatrack;
import plugins.fmp.areatrack.commons.ExportToXLS;
import plugins.fmp.areatrack.commons.GraphsOverlay;
import plugins.fmp.areatrack.commons.GraphsWindow;
import plugins.fmp.areatrack.tools.FmpTools;

public class Dlg6ResultsExport
extends JPanel {
    private static final long serialVersionUID = 487691225410920887L;
    JComboBox<String> filterComboBox = new JComboBox<String>(new String[]{"raw data"});
    public JTextField spanTextField = new JTextField("10");
    private JButton updateChartsButton = new JButton("Chart window");
    private JButton setGraphsOverlayButton = new JButton("Curves");
    private JButton exportToXLSButton = new JButton("Save XLS file..");
    Areatrack areatrack = null;

    public void init(Areatrack areatrack, final IcyFrame mainFrame, JPanel mainPanel, String title) {
        this.areatrack = areatrack;
        PopupPanel capPopupPanel = new PopupPanel(title);
        JPanel capPanel = capPopupPanel.getMainPanel();
        capPanel.setLayout(new GridLayout(2, 2));
        capPopupPanel.collapse();
        capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                mainFrame.revalidate();
                mainFrame.pack();
                mainFrame.repaint();
            }
        });
        mainPanel.add((Component)capPopupPanel);
        JLabel outputLabel = new JLabel("output ", 4);
        JLabel spanLabel = new JLabel("span ", 4);
        FlowLayout layoutLeft = new FlowLayout(0);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(this.updateChartsButton);
        panel1.add(this.setGraphsOverlayButton);
        this.setGraphsOverlayButton.setEnabled(false);
        panel1.add(outputLabel);
        panel1.add(this.filterComboBox);
        panel1.add(spanLabel);
        panel1.add(this.spanTextField);
        capPanel.add(panel1);
        FlowLayout layoutRight = new FlowLayout(2);
        JPanel panel3 = new JPanel(layoutRight);
        JLabel emptyText1 = new JLabel("-> File ", 4);
        emptyText1.setFont(FontUtil.setStyle((Font)emptyText1.getFont(), (int)2));
        panel3.add(emptyText1);
        panel3.add(this.exportToXLSButton);
        capPanel.add(panel3);
        this.filterComboBox.setSelectedIndex(0);
        this.declareActionListeners();
    }

    private void declareActionListeners() {
        this.updateChartsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg6ResultsExport.this.updateCharts();
            }
        });
        this.setGraphsOverlayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg6ResultsExport.this.setGraphsOverlay();
            }
        });
        this.exportToXLSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Dlg6ResultsExport.this.exportToXLS();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void updateCharts() {
        this.areatrack.displayCharts = new GraphsWindow();
        int span = Integer.parseInt(this.spanTextField.getText());
        int filteroption = this.filterComboBox.getSelectedIndex();
        this.areatrack.displayCharts.updateCharts(this.areatrack.vSequence, filteroption, span);
    }

    private void setGraphsOverlay() {
        GraphsOverlay displayGraphs = new GraphsOverlay();
        int span = Integer.parseInt(this.spanTextField.getText());
        int filteroption = this.filterComboBox.getSelectedIndex();
        displayGraphs.updateCharts(this.areatrack.vSequence, filteroption, span);
    }

    private void exportToXLS() throws InterruptedException {
        String file = FmpTools.saveFileAs(null, this.areatrack.vSequence.getDirectory(), "xls");
        if (file != null) {
            ExportToXLS exportToXLS = new ExportToXLS();
            String filename = file;
            exportToXLS.exportToXLS(this.areatrack, filename);
        }
    }
}

