/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.sequence;

import icy.file.FileUtil;
import icy.gui.dialog.LoaderDialog;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import plugins.fmp.areatrack.sequence.Directories;

public class ExperimentDirectories {
    public String cameraImagesDirectory = null;
    public List<String> cameraImagesList = null;
    public String resultsDirectory = null;
    public String binSubDirectory = null;
    public List<String> kymosImagesList = null;

    public static List<String> keepOnlyAcceptedNames_List(List<String> namesList, String strExtension) {
        int count = namesList.size();
        ArrayList<String> outList = new ArrayList<String>(count);
        String ext = strExtension.toLowerCase();
        for (String name : namesList) {
            String nameGeneric = FileUtil.getGenericPath((String)name);
            if (!nameGeneric.toLowerCase().endsWith(ext)) continue;
            outList.add(nameGeneric);
        }
        return outList;
    }

    public static List<String> getV2ImagesListFromPath(String strDirectory) {
        ArrayList<String> list = new ArrayList<String>();
        Path pathDir = Paths.get(strDirectory, new String[0]);
        if (Files.exists(pathDir, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(pathDir);){
                for (Path entry : stream) {
                    String toAdd = FileUtil.getGenericPath((String)entry.toString());
                    list.add(toAdd);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static List<String> getV2ImagesListFromDialog(String strPath) {
        File[] selectedFiles;
        List<String> list = new ArrayList<String>();
        LoaderDialog dialog = new LoaderDialog(false);
        if (strPath != null) {
            dialog.setCurrentDirectory(new File(strPath));
        }
        if ((selectedFiles = dialog.getSelectedFiles()).length == 0) {
            return null;
        }
        String strDirectory = Directories.getDirectoryFromName(selectedFiles[0].toString());
        if (strDirectory != null && selectedFiles.length == 1) {
            list = ExperimentDirectories.getV2ImagesListFromPath(strDirectory);
        }
        return list;
    }

    public boolean checkCameraImagesList() {
        boolean isOK = false;
        if (this.cameraImagesList != null) {
            boolean imageFound = false;
            String jpg = "jpg";
            String grabs = "grabs";
            String grabsDirectory = null;
            for (String name : this.cameraImagesList) {
                if (name.toLowerCase().endsWith(jpg)) {
                    imageFound = true;
                    break;
                }
                if (!name.toLowerCase().endsWith(grabs)) continue;
                grabsDirectory = name;
            }
            if (imageFound) {
                this.cameraImagesList = ExperimentDirectories.keepOnlyAcceptedNames_List(this.cameraImagesList, "jpg");
                isOK = true;
            } else if (grabsDirectory != null) {
                this.cameraImagesList = ExperimentDirectories.getV2ImagesListFromPath(grabsDirectory);
                isOK = this.checkCameraImagesList();
            }
        }
        return isOK;
    }

    public static String getParentIf(String filename, String filter) {
        if (filename.contains(filter)) {
            filename = Paths.get(filename, new String[0]).getParent().toString();
        }
        return filename;
    }

    public static String getImagesDirectoryAsParentFromFileName(String filename) {
        String RESULTS = "results";
        String BIN = "bin_";
        filename = ExperimentDirectories.getParentIf(filename, BIN);
        filename = ExperimentDirectories.getParentIf(filename, RESULTS);
        return filename;
    }
}

