/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.tools;

import icy.file.FileUtil;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import plugins.kernel.roi.roi2d.ROI2DLine;

public class FmpTools
extends Plugin {
    public static String saveFileAs(String defaultName, String directory, String csExt) {
        int returnValue;
        String csFile = null;
        JFileChooser fileChooser = new JFileChooser();
        if (directory != null) {
            fileChooser.setCurrentDirectory(new File(directory));
        }
        fileChooser.setFileSelectionMode(0);
        FileNameExtensionFilter xlsFilter = new FileNameExtensionFilter(csExt + " files", csExt, csExt);
        fileChooser.addChoosableFileFilter(xlsFilter);
        fileChooser.setFileFilter(xlsFilter);
        if (defaultName != null) {
            fileChooser.setSelectedFile(new File(defaultName));
        }
        if ((returnValue = fileChooser.showSaveDialog(null)) == 0) {
            int extensionOK;
            File f = fileChooser.getSelectedFile();
            csFile = f.getAbsolutePath();
            int dotOK = csExt.indexOf(".");
            if (dotOK < 0) {
                csExt = "." + csExt;
            }
            if ((extensionOK = csFile.indexOf(csExt)) < 0) {
                csFile = csFile + csExt;
                f = new File(csFile);
            }
            if (f.exists()) {
                if (ConfirmDialog.confirm((String)"Overwrite existing file ?")) {
                    FileUtil.delete((File)f, (boolean)true);
                } else {
                    csFile = null;
                }
            }
        }
        return csFile;
    }

    public static String[] selectFiles(String directory, String csExt) {
        JFileChooser fileChooser = new JFileChooser();
        String path = directory;
        fileChooser.setCurrentDirectory(new File(path));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(true);
        FileNameExtensionFilter csFilter = new FileNameExtensionFilter(csExt + " files", csExt, csExt);
        fileChooser.addChoosableFileFilter(csFilter);
        fileChooser.setFileFilter(csFilter);
        int returnValue = fileChooser.showDialog(null, "Load");
        String[] liststrings = null;
        if (returnValue == 0) {
            File[] files = fileChooser.getSelectedFiles();
            liststrings = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                liststrings[i] = files[i].getAbsolutePath();
            }
        }
        return liststrings;
    }

    public static int[] rank(double[] values) {
        int n = values.length;
        Integer[] indexes = new Integer[n];
        final Double[] data = new Double[n];
        for (int i = 0; i < n; ++i) {
            indexes[i] = i;
            data[i] = values[i];
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return data[o1].compareTo(data[o2]);
            }
        });
        int[] indexes2 = new int[n];
        for (int i = 0; i < n; ++i) {
            indexes2[i] = indexes[i];
        }
        return indexes2;
    }

    public static int[] rank(final String[] data) {
        int n = data.length;
        Integer[] indexes = new Integer[n];
        for (int i = 0; i < n; ++i) {
            indexes[i] = i;
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return data[o1].compareToIgnoreCase(data[o2]);
            }
        });
        int[] indexes2 = new int[n];
        for (int i = 0; i < n; ++i) {
            indexes2[i] = indexes[i];
        }
        return indexes2;
    }

    public static Polygon orderVerticesofPolygon(Polygon roiPolygon) {
        int i;
        if (roiPolygon.npoints > 4) {
            new AnnounceFrame("Only the first 4 points of the polygon will be used...");
        }
        Polygon extFrame = new Polygon();
        Rectangle rect = roiPolygon.getBounds();
        Rectangle rect1 = new Rectangle(rect);
        rect1.setSize(rect.width / 2, rect.height / 2);
        for (i = 0; i < roiPolygon.npoints; ++i) {
            if (!rect1.contains(roiPolygon.xpoints[i], roiPolygon.ypoints[i])) continue;
            extFrame.addPoint(roiPolygon.xpoints[i], roiPolygon.ypoints[i]);
            break;
        }
        rect1.translate(0, rect.height / 2 + 2);
        for (i = 0; i < roiPolygon.npoints; ++i) {
            if (!rect1.contains(roiPolygon.xpoints[i], roiPolygon.ypoints[i])) continue;
            extFrame.addPoint(roiPolygon.xpoints[i], roiPolygon.ypoints[i]);
            break;
        }
        rect1.translate(rect.width / 2 + 2, 0);
        for (i = 0; i < roiPolygon.npoints; ++i) {
            if (!rect1.contains(roiPolygon.xpoints[i], roiPolygon.ypoints[i])) continue;
            extFrame.addPoint(roiPolygon.xpoints[i], roiPolygon.ypoints[i]);
            break;
        }
        rect1.translate(0, -rect.height / 2 - 2);
        for (i = 0; i < roiPolygon.npoints; ++i) {
            if (!rect1.contains(roiPolygon.xpoints[i], roiPolygon.ypoints[i])) continue;
            extFrame.addPoint(roiPolygon.xpoints[i], roiPolygon.ypoints[i]);
            break;
        }
        return extFrame;
    }

    public static File chooseDirectory(String rootdirectory) {
        File dummy_selected = null;
        JFileChooser fc = new JFileChooser();
        if (rootdirectory != null) {
            fc.setCurrentDirectory(new File(rootdirectory));
        }
        fc.setDialogTitle("Select a root directory...");
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showOpenDialog(null) == 0) {
            dummy_selected = fc.getSelectedFile();
        } else {
            System.out.println("No directory selected ");
        }
        return dummy_selected;
    }

    public static class SequenceNameComparator
    implements Comparator<Sequence> {
        @Override
        public int compare(Sequence o1, Sequence o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class ROINameComparator
    implements Comparator<ROI> {
        @Override
        public int compare(ROI o1, ROI o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class ROI2DNameComparator
    implements Comparator<ROI2D> {
        @Override
        public int compare(ROI2D o1, ROI2D o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class ROI2DLineLeftYComparator
    implements Comparator<ROI2DLine> {
        @Override
        public int compare(ROI2DLine o1, ROI2DLine o2) {
            if (o1.getBounds().y == o2.getBounds().y) {
                return 0;
            }
            if (o1.getBounds().y > o2.getBounds().y) {
                return 1;
            }
            return -1;
        }
    }

    public static class ROI2DLineLeftXComparator
    implements Comparator<ROI2DLine> {
        @Override
        public int compare(ROI2DLine o1, ROI2DLine o2) {
            if (o1.getBounds().x == o2.getBounds().x) {
                return 0;
            }
            if (o1.getBounds().x > o2.getBounds().x) {
                return 1;
            }
            return -1;
        }
    }
}

