/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.tools;

import icy.image.IcyBufferedImage;
import java.awt.Color;
import java.util.ArrayList;
import plugins.fmp.areatrack.sequence.SequenceVirtual;
import plugins.fmp.areatrack.tools.EnumAreaDetection;
import plugins.fmp.areatrack.tools.EnumColorDistanceType;
import plugins.fmp.areatrack.tools.EnumImageOp;
import plugins.fmp.areatrack.tools.ImageOperationsStruct;
import plugins.fmp.areatrack.tools.ImageThresholdTools;
import plugins.fmp.areatrack.tools.ImageTransformTools;

public class ImageOperations {
    private SequenceVirtual seq = null;
    private ImageOperationsStruct opTransf = new ImageOperationsStruct();
    private ImageOperationsStruct opThresh = new ImageOperationsStruct();
    private ImageTransformTools imgTransf = new ImageTransformTools();
    private ImageThresholdTools imgThresh = new ImageThresholdTools();

    public ImageOperations(SequenceVirtual seq) {
        this.setSequence(seq);
    }

    public void setSequence(SequenceVirtual seq) {
        this.seq = seq;
        this.imgTransf.setSequence(seq);
    }

    public void setTransform(EnumImageOp transformop) {
        this.opTransf.transformop = transformop;
    }

    public void setThresholdToSingleValue(int threshold, boolean thresholdUp) {
        this.opThresh.thresholdtype = EnumAreaDetection.SINGLE;
        this.opThresh.simplethreshold = threshold;
        this.opThresh.thresholdUp = thresholdUp;
        this.imgThresh.setSingleThreshold(threshold, thresholdUp);
    }

    public void setThresholdToColorArray(ArrayList<Color> colorarray, EnumColorDistanceType distanceType, int colorthreshold) {
        this.opThresh.thresholdtype = EnumAreaDetection.COLORARRAY;
        this.opThresh.colorarray = colorarray;
        this.opThresh.colordistanceType = distanceType;
        this.opThresh.colorthreshold = colorthreshold;
        this.imgThresh.setColorArrayThreshold(distanceType, colorthreshold, colorarray);
    }

    public IcyBufferedImage run(int frame) {
        this.opTransf.fromFrame = frame;
        if (this.seq.cacheTransformedImage == null || !this.opTransf.isValidTransformCache(this.seq.cacheTransformOp)) {
            this.seq.cacheTransformedImage = this.imgTransf.transformImageFromVirtualSequence(frame, this.opTransf.transformop);
            if (this.seq.cacheTransformedImage == null) {
                return null;
            }
            this.opTransf.copyTransformOpTo(this.seq.cacheTransformOp);
            this.seq.cacheThresholdOp.fromFrame = -1;
        }
        this.opThresh.fromFrame = frame;
        if (!this.opThresh.isValidThresholdCache(this.seq.cacheThresholdOp)) {
            this.seq.cacheThresholdedImage = this.opThresh.thresholdtype == EnumAreaDetection.COLORARRAY ? this.imgThresh.getBinaryInt_FromColorsThreshold(this.seq.cacheTransformedImage) : this.imgThresh.getBinaryInt_FromThreshold(this.seq.cacheTransformedImage);
            this.opThresh.copyThresholdOpTo(this.seq.cacheThresholdOp);
        }
        return this.seq.cacheThresholdedImage;
    }

    public IcyBufferedImage run_nocache() {
        int frame = this.seq.currentFrame;
        IcyBufferedImage transformedImage = this.imgTransf.transformImageFromVirtualSequence(frame, this.opTransf.transformop);
        if (transformedImage == null) {
            return null;
        }
        IcyBufferedImage thresholdedImage = this.opThresh.thresholdtype == EnumAreaDetection.COLORARRAY ? this.imgThresh.getBinaryInt_FromColorsThreshold(transformedImage) : this.imgThresh.getBinaryInt_FromThreshold(transformedImage);
        return thresholdedImage;
    }

    public boolean[] convertToBoolean(IcyBufferedImage binaryMap) {
        return this.imgThresh.getBoolMap_FromBinaryInt(binaryMap);
    }
}

