/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.tools;

import java.awt.Color;
import java.util.ArrayList;
import plugins.fmp.areatrack.tools.EnumAreaDetection;
import plugins.fmp.areatrack.tools.EnumColorDistanceType;
import plugins.fmp.areatrack.tools.EnumImageOp;

public class ImageOperationsStruct {
    int fromFrame = -1;
    EnumColorDistanceType colordistanceType = EnumColorDistanceType.L1;
    boolean thresholdUp = true;
    int simplethreshold = 255;
    int colorthreshold = 0;
    ArrayList<Color> colorarray = null;
    EnumImageOp transformop = EnumImageOp.NONE;
    EnumAreaDetection thresholdtype = EnumAreaDetection.NONE;

    public ImageOperationsStruct() {
        this.fromFrame = -1;
        this.transformop = EnumImageOp.NONE;
        this.thresholdtype = EnumAreaDetection.NONE;
        this.colorthreshold = 0;
    }

    public ImageOperationsStruct(int framenumber, EnumImageOp transformop, EnumAreaDetection thresholdtype, boolean thresholdUp, int thresholdvalue) {
        this.fromFrame = framenumber;
        this.transformop = transformop;
        this.thresholdtype = thresholdtype;
        this.thresholdUp = thresholdUp;
        this.colorthreshold = thresholdvalue;
    }

    public ImageOperationsStruct(int framenumber, EnumImageOp transformop) {
        this.fromFrame = framenumber;
        this.transformop = transformop;
        this.thresholdtype = EnumAreaDetection.NONE;
        this.colorthreshold = 0;
    }

    public boolean isValidTransformCache(ImageOperationsStruct op) {
        if (op.fromFrame != this.fromFrame) {
            return false;
        }
        return op.transformop == this.transformop;
    }

    public void copyTransformOpTo(ImageOperationsStruct op) {
        op.transformop = this.transformop;
        op.fromFrame = this.fromFrame;
    }

    public void copyThresholdOpTo(ImageOperationsStruct op) {
        op.thresholdtype = this.thresholdtype;
        if (this.thresholdtype == EnumAreaDetection.SINGLE) {
            op.simplethreshold = this.simplethreshold;
            op.thresholdUp = this.thresholdUp;
        } else if (this.thresholdtype == EnumAreaDetection.COLORARRAY) {
            op.colorthreshold = this.colorthreshold;
            if (op.colorarray == null) {
                op.colorarray = new ArrayList();
            } else {
                op.colorarray.clear();
            }
            for (Color c : this.colorarray) {
                op.colorarray.add(c);
            }
            op.colordistanceType = this.colordistanceType;
        }
        op.fromFrame = this.fromFrame;
    }

    public boolean isValidThresholdCache(ImageOperationsStruct op) {
        if (op.fromFrame != this.fromFrame) {
            return false;
        }
        if (op.thresholdtype != this.thresholdtype) {
            return false;
        }
        if (op.thresholdtype == EnumAreaDetection.COLORARRAY) {
            if (op.colorthreshold != this.colorthreshold) {
                return false;
            }
            if (op.colordistanceType != this.colordistanceType) {
                return false;
            }
            if (op.colorarray.size() != this.colorarray.size()) {
                return false;
            }
        } else {
            if (op.simplethreshold != this.simplethreshold) {
                return false;
            }
            if (op.thresholdUp != this.thresholdUp) {
                return false;
            }
        }
        return true;
    }
}

