/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.DimensionId;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import plugins.fmp.areatrack.commons.DetectionParameters;
import plugins.fmp.areatrack.commons.GraphsWindow;
import plugins.fmp.areatrack.dlg.Dlg1Source;
import plugins.fmp.areatrack.dlg.Dlg2Grids;
import plugins.fmp.areatrack.dlg.Dlg3ParametersArea;
import plugins.fmp.areatrack.dlg.Dlg4ParametersMovements;
import plugins.fmp.areatrack.dlg.Dlg5AnalysisRun;
import plugins.fmp.areatrack.dlg.Dlg6ResultsExport;
import plugins.fmp.areatrack.sequence.SequencePlus;
import plugins.fmp.areatrack.tools.EnumAreaDetection;

public class Areatrack
extends PluginActionable
implements ViewerListener {
    public IcyFrame mainFrame = new IcyFrame("AreaTrack 9-Nov-2024", true, true, true, true);
    public GraphsWindow displayCharts = null;
    Dlg1Source dlg1Source = new Dlg1Source();
    Dlg2Grids dlg2Grids = new Dlg2Grids();
    Dlg3ParametersArea dlg3ParametersArea = new Dlg3ParametersArea();
    Dlg4ParametersMovements dlg4ParametersMovements = new Dlg4ParametersMovements();
    public Dlg5AnalysisRun dlg5AnalysisRun = new Dlg5AnalysisRun();
    public Dlg6ResultsExport dlg6ResultsExport = new Dlg6ResultsExport();
    public DetectionParameters detectionParameters = new DetectionParameters();
    public SequencePlus vSequence = null;

    public void run() {
        JPanel mainPanel = GuiUtil.generatePanelWithoutBorder();
        this.dlg1Source.init(this, this.mainFrame, mainPanel, "1 - Images stack");
        this.dlg2Grids.init(this, this.mainFrame, mainPanel, "2 - Cells grid define/load");
        this.dlg3ParametersArea.init(this, this.mainFrame, mainPanel, "3 - Area measure parameters");
        this.dlg4ParametersMovements.init(this, this.mainFrame, mainPanel, "4 - Movements detection parameters");
        this.dlg5AnalysisRun.init(this, this.mainFrame, mainPanel, "5 - Run analysis");
        this.dlg6ResultsExport.init(this, this.mainFrame, mainPanel, "6 - Display/export results");
        this.mainFrame.setLayout((LayoutManager)new BorderLayout());
        this.mainFrame.add((Component)mainPanel, (Object)"West");
        this.mainFrame.pack();
        this.mainFrame.center();
        this.mainFrame.setVisible(true);
        this.mainFrame.addToDesktopPane();
    }

    public void viewerChanged(ViewerEvent event) {
        if (event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED && event.getDim() == DimensionId.T) {
            this.vSequence.currentFrame = event.getSource().getPositionT();
        }
    }

    public void viewerClosed(Viewer viewer) {
        viewer.removeListener((ViewerListener)this);
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)Areatrack.class.getName()));
    }

    public void setOverlay(boolean displayOverlay) {
        if (this.vSequence == null) {
            return;
        }
        this.detectionParameters.displayOverlay = displayOverlay;
        this.vSequence.setThresholdOverlay(displayOverlay);
        if (displayOverlay) {
            if (this.detectionParameters.areaDetectionMode == EnumAreaDetection.SINGLE) {
                this.vSequence.setThresholdOverlayParametersSingle(this.detectionParameters);
            } else {
                this.vSequence.setThresholdOverlayParametersColors(this.detectionParameters);
            }
        }
    }
}

