/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.commons;

import icy.canvas.Canvas2D;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.JETColorMap;
import icy.main.Icy;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.system.profile.Chronometer;
import icy.system.thread.Processor;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.SwingWorker;
import plugins.fmp.areatrack.commons.MeasureAndName;
import plugins.fmp.areatrack.sequence.SequenceVirtual;
import plugins.fmp.areatrack.tools.EnumColorDistanceType;
import plugins.fmp.areatrack.tools.EnumImageOp;
import plugins.fmp.areatrack.tools.FmpTools;
import plugins.fmp.areatrack.tools.ImageOperations;

public class AreaAnalysisThread
extends SwingWorker<Integer, Integer> {
    public boolean stopFlag = false;
    public boolean threadRunning = false;
    SequenceVirtual vSequence = null;
    private ArrayList<ROI2D> roiList = null;
    private int startFrame = 0;
    private int endFrame = 1;
    private int analyzeStep = 1;
    private boolean measureROIsEvolution = false;
    private boolean measureROIsMove = false;
    public IcyBufferedImage resultOFFImage = null;
    public Sequence resultOFFSequence = null;
    public Viewer resultOFFViewer = null;
    public Canvas2D resultOFFCanvas = null;
    public IcyBufferedImage resultONImage = null;
    public Sequence resultONSequence = null;
    public Viewer resultONViewer = null;
    public Canvas2D resultONCanvas = null;
    public ArrayList<MeasureAndName> results = null;
    private ImageOperations imgOp1;
    private ImageOperations imgOp2;

    public void initAreaDetectionFromFunction(SequenceVirtual sequenceVirtual, ArrayList<ROI2D> roiList, EnumImageOp transformOpForOperation1, int thresholdForSurface, boolean thresholdUp) {
        this.vSequence = sequenceVirtual;
        this.roiList = roiList;
        this.startFrame = this.vSequence.analysisStart;
        this.endFrame = this.vSequence.analysisEnd;
        this.imgOp1 = new ImageOperations(sequenceVirtual);
        this.imgOp1.setTransform(transformOpForOperation1);
        this.imgOp1.setThresholdToSingleValue(thresholdForSurface, thresholdUp);
        this.measureROIsEvolution = true;
    }

    public void initAreaDetectionFromColors(SequenceVirtual sequenceVirtual, ArrayList<ROI2D> roiList, EnumColorDistanceType distanceType, int colorthreshold, ArrayList<Color> colorarray) {
        this.vSequence = sequenceVirtual;
        this.roiList = roiList;
        this.startFrame = this.vSequence.analysisStart;
        this.endFrame = this.vSequence.analysisEnd;
        this.imgOp1 = new ImageOperations(sequenceVirtual);
        this.imgOp1.setTransform(EnumImageOp.NONE);
        this.imgOp1.setThresholdToColorArray(colorarray, distanceType, colorthreshold);
        this.measureROIsEvolution = true;
    }

    public void initMovementDetection(SequenceVirtual sequenceVirtual, ArrayList<ROI2D> roiList, int thresholdForHeatMap) {
        this.prepareImagesForMovementDetection(sequenceVirtual, roiList, thresholdForHeatMap);
        this.measureROIsMove = true;
    }

    @Override
    protected Integer doInBackground() throws Exception {
        this.threadRunning = true;
        this.analyzeSequence();
        this.threadRunning = false;
        return 1;
    }

    protected void analyzeSequence() {
        this.analyzeStep = this.vSequence.analysisStep;
        this.roiList = this.vSequence.seq.getROI2Ds();
        Collections.sort(this.roiList, new FmpTools.ROI2DNameComparator());
        if (this.vSequence.nTotalFrames < this.endFrame + 1) {
            this.endFrame = this.vSequence.nTotalFrames - 1;
        }
        int nbframes = this.endFrame - this.startFrame + 1;
        int nrois = this.roiList.size();
        this.vSequence.data_raw = new int[nrois][nbframes];
        ArrayList<BooleanMask2D> areaMasks = this.getMasksFromRois();
        System.out.println("Computation over frames: " + this.startFrame + " - " + this.endFrame);
        Chronometer chrono = new Chronometer("Tracking computation");
        ProgressFrame progress = new ProgressFrame("Anayze images...");
        Viewer viewer = Icy.getMainInterface().getFirstViewer(this.vSequence.seq);
        if (!this.measureROIsEvolution) {
            viewer = this.resultOFFViewer;
        }
        this.vSequence.seq.beginUpdate();
        for (int iiframe = this.startFrame; iiframe <= this.endFrame; iiframe += this.analyzeStep) {
            IcyBufferedImage binaryMap;
            int iframe = iiframe;
            viewer.setPositionT(iframe);
            this.vSequence.currentFrame = iframe;
            this.updateDisplay(iframe, nbframes, chrono, progress);
            if (this.measureROIsEvolution) {
                binaryMap = this.imgOp1.run(iframe);
                boolean[] boolMap = this.imgOp1.convertToBoolean(binaryMap);
                BooleanMask2D maskAll2D = new BooleanMask2D(binaryMap.getBounds(), boolMap);
                for (int iiroi = 0; iiroi < areaMasks.size(); ++iiroi) {
                    BooleanMask2D areaMask = areaMasks.get(iiroi);
                    try {
                        BooleanMask2D intersectionMask = maskAll2D.getIntersection(areaMask);
                        int sum = intersectionMask.getNumberOfPoints();
                        int index = iframe - this.startFrame;
                        this.vSequence.data_raw[iiroi][index] = sum;
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!this.measureROIsMove || iframe >= this.startFrame + 20) continue;
            binaryMap = this.imgOp2.run_nocache();
            int[] binaryArray = Array1DUtil.arrayToIntArray((Object)binaryMap.getDataXY(0), (boolean)binaryMap.isSignedDataType());
            double[] resultOFFArray = this.resultOFFImage.getDataXYAsDouble(0);
            double[] resultONArray = this.resultONImage.getDataXYAsDouble(0);
            for (int i = 0; i < binaryArray.length; ++i) {
                if (binaryArray[i] == 0) {
                    int n = i;
                    resultOFFArray[n] = resultOFFArray[n] + 1.0;
                    continue;
                }
                int n = i;
                resultONArray[n] = resultONArray[n] + 1.0;
            }
        }
        progress.close();
        this.vSequence.seq.endUpdate();
        if (this.measureROIsMove) {
            try {
                this.detectMovements(areaMasks);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        chrono.displayInSeconds();
        System.out.println("Computation finished.");
    }

    private ArrayList<BooleanMask2D> getMasksFromRois() {
        ArrayList<BooleanMask2D> areaMasks = new ArrayList<BooleanMask2D>();
        int iroi = 0;
        int nrois = this.roiList.size();
        this.vSequence.seriesname = new String[nrois];
        for (ROI2D roi : this.roiList) {
            String csName;
            this.vSequence.seriesname[iroi] = csName = roi.getName();
            try {
                areaMasks.add(roi.getBooleanMask2D(0, 0, 1, true));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++iroi;
        }
        return areaMasks;
    }

    void updateDisplay(int t, int nbframes, Chronometer chrono, ProgressFrame progress) {
        int pos = (int)(100.0 * (double)t / (double)nbframes);
        progress.setPosition((double)pos);
        int nbSeconds = (int)((float)chrono.getNanos() / 1.0E9f);
        int timeleft = nbSeconds * nbframes / (t + 1) - nbSeconds;
        progress.setMessage("Processing: " + pos + " % - Elapsed time: " + nbSeconds + " s - Estimated time left: " + timeleft + " s");
    }

    private void detectMovements(ArrayList<BooleanMask2D> areaMasks) throws InterruptedException {
        this.resultOFFImage.dataChanged();
        this.resultOFFImage.setColorMap(0, (IcyColorMap)new JETColorMap(), true);
        this.resultOFFViewer.setVisible(true);
        this.resultOFFSequence.removeAllROI();
        this.resultOFFSequence.addROIs((Collection)this.vSequence.seq.getROI2Ds(), false);
        this.resultONImage.dataChanged();
        this.resultONImage.setColorMap(0, (IcyColorMap)new JETColorMap(), true);
        this.resultONViewer.setVisible(true);
        this.resultONSequence.removeAllROI();
        this.resultONSequence.addROIs((Collection)this.vSequence.seq.getROI2Ds(), false);
        ArrayList roiList2 = this.resultOFFSequence.getROI2Ds();
        double sumall = 0.0;
        double countall = 0.0;
        int cmax = this.resultOFFImage.getSizeC();
        for (int c = 0; c < cmax; ++c) {
            double[] resultDoubleArray = Array1DUtil.arrayToDoubleArray((Object)this.resultONImage.getDataXY(c), (boolean)this.resultONImage.isSignedDataType());
            for (int i = 0; i < resultDoubleArray.length; ++i) {
                sumall += resultDoubleArray[i];
            }
            countall += (double)resultDoubleArray.length;
        }
        for (ROI2D roi : roiList2) {
            areaMasks.add(roi.getBooleanMask2D(0, 0, 1, true));
        }
        this.results = new ArrayList();
        for (ROI2D roi : roiList2) {
            SequenceDataIterator iterator = new SequenceDataIterator(this.resultOFFSequence, (ROI)roi, true, 0, 0, -1);
            double sum = 0.0;
            double sample = 0.0;
            while (!iterator.done()) {
                sum += iterator.get();
                iterator.next();
                sample += 1.0;
            }
            sumall -= sum;
            countall -= sample;
            this.results.add(new MeasureAndName(roi.getName(), sum, sample));
        }
        this.results.add(new MeasureAndName("background", sumall, countall));
    }

    private void prepareImagesForMovementDetection(SequenceVirtual sequenceVirtual, ArrayList<ROI2D> roiList, int thresholdForHeatMap) {
        this.imgOp2 = new ImageOperations(sequenceVirtual);
        this.imgOp2.setTransform(EnumImageOp.REF_PREVIOUS);
        this.imgOp2.setThresholdToSingleValue(thresholdForHeatMap, true);
        IcyBufferedImage image = this.vSequence.seq.getImage(this.vSequence.currentFrame, 0);
        this.resultOFFImage = new IcyBufferedImage(image.getSizeX(), image.getSizeY(), 1, DataType.DOUBLE);
        this.resultOFFSequence = new Sequence(this.resultOFFImage);
        this.resultOFFSequence.setName("Heatmap OFF thresh:" + thresholdForHeatMap);
        this.resultOFFViewer = new Viewer(this.resultOFFSequence, false);
        this.resultOFFCanvas = new Canvas2D(this.resultOFFViewer);
        this.resultONImage = new IcyBufferedImage(image.getSizeX(), image.getSizeY(), 1, DataType.DOUBLE);
        this.resultONSequence = new Sequence(this.resultONImage);
        this.resultONSequence.setName("Heatmap ON thresh:" + thresholdForHeatMap);
        this.resultONViewer = new Viewer(this.resultONSequence, false);
        this.resultONCanvas = new Canvas2D(this.resultONViewer);
    }

    protected void waitFuturesCompletion(Processor processor, ArrayList<Future<?>> futuresArray, ProgressFrame progressBar) {
        int frame = 1;
        int nframes = futuresArray.size();
        while (!futuresArray.isEmpty()) {
            Future<?> f = futuresArray.get(futuresArray.size() - 1);
            if (progressBar != null) {
                progressBar.setMessage("Analyze frame: " + frame + "//" + nframes);
            }
            try {
                f.get();
            }
            catch (ExecutionException e) {
                System.out.println("series analysis - Warning: " + e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            futuresArray.remove(f);
            ++frame;
        }
    }

    @Override
    protected void done() {
        int statusMsg = 0;
        try {
            statusMsg = (Integer)this.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        if (!this.threadRunning || this.stopFlag) {
            this.firePropertyChange("thread_ended", null, statusMsg);
        } else {
            this.firePropertyChange("thread_done", null, statusMsg);
        }
    }
}

