/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.commons;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.areatrack.commons.FilterTimeSeries;
import plugins.fmp.areatrack.sequence.SequencePlus;

public class GraphsWindow {
    public IcyFrame mainChartFrame = null;
    JPanel mainChartPanel = null;

    public void updateCharts(SequencePlus vSequence, int filteroption, int span) {
        FilterTimeSeries.filterMeasures(vSequence, filteroption, span);
        String title = "Measures from " + vSequence.getFileName(0);
        Point pt = new Point(10, 10);
        if (this.mainChartFrame != null) {
            this.mainChartFrame.removeAll();
            this.mainChartFrame.close();
        }
        this.mainChartFrame = GuiUtil.generateTitleFrame((String)title, (JPanel)new JPanel(), (Dimension)new Dimension(300, 70), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.mainChartPanel = new JPanel();
        this.mainChartPanel.setLayout(new BoxLayout(this.mainChartPanel, 2));
        this.mainChartFrame.add((Component)this.mainChartPanel);
        this.mainChartPanel.removeAll();
        int rows = 1;
        int cols = 1;
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        this.mainChartPanel.setLayout(new GridLayout(rows, cols));
        int nrois = vSequence.data_filtered.length;
        XYSeries[] cropSeries = new XYSeries[nrois];
        int startFrame = vSequence.analysisStart;
        int endFrame = vSequence.analysisEnd;
        int step = vSequence.analysisStep;
        for (int iroi = 0; iroi < nrois; ++iroi) {
            cropSeries[iroi] = new XYSeries((Comparable)((Object)vSequence.seriesname[iroi]));
            cropSeries[iroi].clear();
            for (int t = startFrame; t <= endFrame; t += step) {
                int bin = (t - startFrame) / step;
                cropSeries[iroi].add((double)t, vSequence.data_filtered[iroi][bin]);
            }
            xyDataset.addSeries(cropSeries[iroi]);
        }
        String TitleString = "Results";
        boolean displayLegend = false;
        JFreeChart chart = ChartFactory.createXYLineChart((String)TitleString, (String)"time", (String)"pixels", (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)displayLegend, (boolean)true, (boolean)false);
        int minWidth = 800;
        int minHeight = 200;
        int width = 800;
        int height = 200;
        int maxWidth = 100000;
        int maxHeight = 100000;
        XYPlot plot = chart.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis.setRange((double)startFrame, (double)endFrame);
        LegendTitle legendTitle = chart.getLegend();
        if (legendTitle != null) {
            legendTitle.setPosition(RectangleEdge.RIGHT);
        }
        this.mainChartPanel.add((Component)new ChartPanel(chart, width, height, minWidth, minHeight, maxWidth, maxHeight, false, false, true, true, true, true));
        this.mainChartPanel.validate();
        this.mainChartPanel.repaint();
        this.mainChartFrame.pack();
        this.mainChartFrame.setLocation(pt);
        this.mainChartFrame.addToDesktopPane();
        this.mainChartFrame.setVisible(true);
        this.mainChartFrame.toFront();
    }
}

