/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.dlg;

import icy.gui.component.PopupPanel;
import icy.gui.frame.IcyFrame;
import icy.gui.util.FontUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.areatrack.Areatrack;
import plugins.fmp.areatrack.commons.LoadRois;
import plugins.fmp.areatrack.splitroitoarray.SplitRoiToArray;

public class Dlg2Grids
extends JPanel {
    private static final long serialVersionUID = 323538974587966282L;
    private JButton buildROISButton = new JButton("Build ROIs array...");
    private JButton openROIsButton = new JButton("Load...");
    private JButton addROIsButton = new JButton("Add...");
    private JButton saveROIsButton = new JButton("Save...");
    Areatrack areatrack = null;

    public void init(Areatrack areatrack, final IcyFrame mainFrame, JPanel mainPanel, String title) {
        this.areatrack = areatrack;
        PopupPanel capPopupPanel = new PopupPanel(title);
        capPopupPanel.collapse();
        capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                mainFrame.revalidate();
                mainFrame.pack();
                mainFrame.repaint();
            }
        });
        mainPanel.add((Component)capPopupPanel);
        JPanel capPanel = capPopupPanel.getMainPanel();
        capPanel.setLayout(new GridLayout(2, 2));
        JLabel emptyText0 = new JLabel("Draw Polygon and split into array: ", 4);
        FlowLayout layoutRight = new FlowLayout(2);
        JPanel panel1 = new JPanel(layoutRight);
        panel1.add(emptyText0);
        panel1.add(this.buildROISButton);
        capPanel.add(panel1);
        JLabel emptyText1 = new JLabel("-> File ", 4);
        emptyText1.setFont(FontUtil.setStyle((Font)emptyText1.getFont(), (int)2));
        JPanel panel2 = new JPanel(layoutRight);
        panel2.add(emptyText1);
        panel2.add(this.openROIsButton);
        panel2.add(this.addROIsButton);
        panel2.add(this.saveROIsButton);
        capPanel.add(panel2);
        this.declareActionListeners();
    }

    private void declareActionListeners() {
        this.buildROISButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitRoiToArray buildRois = new SplitRoiToArray();
                buildRois.initialize(Dlg2Grids.this.areatrack);
            }
        });
        this.openROIsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadRois loadRois = new LoadRois();
                loadRois.openROIs(Dlg2Grids.this.areatrack.vSequence);
                Dlg2Grids.this.updateStartAndEndFrameFromvSequence();
            }
        });
        this.saveROIsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadRois loadRois = new LoadRois();
                loadRois.saveROIs(Dlg2Grids.this.areatrack.vSequence);
            }
        });
        this.addROIsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadRois loadRois = new LoadRois();
                loadRois.addROIs(Dlg2Grids.this.areatrack.vSequence);
                Dlg2Grids.this.updateStartAndEndFrameFromvSequence();
            }
        });
    }

    private void updateStartAndEndFrameFromvSequence() {
        this.areatrack.dlg5AnalysisRun.updateStartAndEndFrameFromvSequence(this.areatrack.vSequence);
    }
}

