/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.dlg;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.areatrack.Areatrack;
import plugins.fmp.areatrack.commons.DetectionParameters;
import plugins.fmp.areatrack.tools.EnumImageOp;

public class Dlg3TabFilter
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 8921207247623517524L;
    private JLabel videochannel = new JLabel("filter  ");
    private JLabel thresholdLabel = new JLabel("threshold ");
    JComboBox<EnumImageOp> transformsComboBox = new JComboBox<EnumImageOp>(new EnumImageOp[]{EnumImageOp.R_RGB, EnumImageOp.G_RGB, EnumImageOp.B_RGB, EnumImageOp.R2MINUS_GB, EnumImageOp.G2MINUS_RB, EnumImageOp.B2MINUS_RG, EnumImageOp.NORM_BRMINUSG, EnumImageOp.RGB, EnumImageOp.H_HSB, EnumImageOp.S_HSB, EnumImageOp.B_HSB});
    private String[] directions = new String[]{" threshold >", " threshold <"};
    private JComboBox<String> directionComboBox = new JComboBox<String>(this.directions);
    JSpinner thresholdSpinner = new JSpinner(new SpinnerNumberModel(35, 0, 255, 1));
    Areatrack areatrack = null;

    public void init(JTabbedPane tab, GridLayout capLayout, Areatrack areatrack) {
        this.areatrack = areatrack;
        JPanel panel = new JPanel(false);
        panel.setLayout(capLayout);
        FlowLayout layoutLeft = new FlowLayout(0);
        JPanel panel0 = new JPanel(layoutLeft);
        panel0.add(this.videochannel);
        panel0.add(this.transformsComboBox);
        panel.add(panel0);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(this.thresholdLabel);
        panel1.add(this.directionComboBox);
        panel1.add(this.thresholdSpinner);
        panel.add(panel1);
        tab.addTab("Filters", null, panel, "Display parameters for thresholding a transformed image with different filters");
        this.transformsComboBox.setSelectedItem((Object)EnumImageOp.NORM_BRMINUSG);
        this.thresholdSpinner.addChangeListener(this);
        this.declareActionListeners();
    }

    private void declareActionListeners() {
        this.transformsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg3TabFilter.this.updateThresholdOverlayParameters();
            }
        });
        this.directionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg3TabFilter.this.updateThresholdOverlayParameters();
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.thresholdSpinner) {
            this.updateThresholdOverlayParameters();
        }
    }

    void updateThresholdOverlayParameters() {
        this.transferDialogToParameters(this.areatrack.detectionParameters);
        this.areatrack.setOverlay(this.areatrack.detectionParameters.displayOverlay);
    }

    public void transferParametersToDialog(DetectionParameters detectionParameters) {
        this.transformsComboBox.setSelectedItem((Object)detectionParameters.simpletransformop);
        this.directionComboBox.setSelectedItem(detectionParameters.thresholdUp ? 0 : 1);
        this.thresholdSpinner.setValue(detectionParameters.simplethreshold);
    }

    public void transferDialogToParameters(DetectionParameters detectionParameters) {
        detectionParameters.simpletransformop = (EnumImageOp)((Object)this.transformsComboBox.getSelectedItem());
        detectionParameters.thresholdUp = this.directionComboBox.getSelectedIndex() == 0;
        detectionParameters.simplethreshold = (Integer)this.thresholdSpinner.getValue();
    }
}

