/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.sequence;

import icy.gui.frame.progress.AnnounceFrame;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.geom.Polygon2D;
import icy.type.geom.Polyline2D;
import icy.util.XMLUtil;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.areatrack.sequence.Comparators;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class ROI2DUtilities {
    private static final String ID_ROIMC = "roiMC";

    public static void interpolateMissingPointsAlongXAxis(ROI2DPolyLine roiLine, int nintervals) {
        if (nintervals <= 1) {
            return;
        }
        Polyline2D polyline = roiLine.getPolyline2D();
        int roiLine_npoints = polyline.npoints;
        if (roiLine_npoints > nintervals) {
            roiLine_npoints = nintervals;
        }
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>(roiLine_npoints);
        double ylast = polyline.ypoints[roiLine_npoints - 1];
        int xfirst0 = (int)polyline.xpoints[0];
        for (int i = 1; i < roiLine_npoints; ++i) {
            int xlast;
            int xfirst = (int)polyline.xpoints[i - 1];
            if (xfirst < 0) {
                xfirst = 0;
            }
            if ((xlast = (int)polyline.xpoints[i]) > xfirst0 + nintervals - 1) {
                xlast = xfirst0 + nintervals - 1;
            }
            double yfirst = polyline.ypoints[i - 1];
            ylast = polyline.ypoints[i];
            for (int j = xfirst; j < xlast; ++j) {
                int val = (int)(yfirst + (ylast - yfirst) * (double)(j - xfirst) / (double)(xlast - xfirst));
                Point2D.Double pt = new Point2D.Double(j, val);
                pts.add(pt);
            }
        }
        Point2D.Double pt = new Point2D.Double(polyline.xpoints[roiLine_npoints - 1], ylast);
        pts.add(pt);
        roiLine.setPoints(pts);
    }

    private static List<Integer> transferROIYpointsToIntList(ROI2DPolyLine roiLine) {
        Polyline2D line = roiLine.getPolyline2D();
        ArrayList<Integer> intArray = new ArrayList<Integer>(line.npoints);
        for (int i = 0; i < line.npoints; ++i) {
            intArray.add((int)line.ypoints[i]);
        }
        return intArray;
    }

    public static void mergeROIsListNoDuplicate(List<ROI2D> seqList, List<ROI2D> listRois, Sequence seq) {
        if (seqList.isEmpty()) {
            seqList.addAll(listRois);
        }
        for (ROI2D seqRoi : seqList) {
            Iterator<ROI2D> iterator = listRois.iterator();
            while (iterator.hasNext()) {
                ROI2D roi = iterator.next();
                if (seqRoi == roi) {
                    iterator.remove();
                    continue;
                }
                if (!seqRoi.getName().equals(roi.getName())) continue;
                seqRoi.copyFrom((ROI)roi);
                iterator.remove();
            }
        }
    }

    public static void removeROIsMissingChar(List<ROI2D> listRois, char character) {
        Iterator<ROI2D> iterator = listRois.iterator();
        while (iterator.hasNext()) {
            ROI2D roi = iterator.next();
            if (roi.getName().indexOf(character) >= 0) continue;
            iterator.remove();
        }
    }

    public static ROI2DPolyLine transfertDataArrayToROI(List<Integer> intArray) {
        Polyline2D line = new Polyline2D();
        for (int i = 0; i < intArray.size(); ++i) {
            Point2D.Double pt = new Point2D.Double(i, intArray.get(i).intValue());
            line.addPoint((Point2D)pt);
        }
        return new ROI2DPolyLine(line);
    }

    public static void addROItoCumulatedSumArray(ROI2DPolyLine roi, ArrayList<Integer> sumArrayList) {
        Polyline2D roiline = roi.getPolyline2D();
        int width = (int)roiline.xpoints[roiline.npoints - 1] - (int)roiline.xpoints[0] + 1;
        ROI2DUtilities.interpolateMissingPointsAlongXAxis(roi, width);
        List<Integer> intArray = ROI2DUtilities.transferROIYpointsToIntList(roi);
        int jstart = (int)roiline.xpoints[0];
        int previousY = intArray.get(0);
        for (int i = 1; i < intArray.size(); ++i) {
            int val = intArray.get(i);
            int deltaY = val - previousY;
            previousY = val;
            for (int j = jstart + i; j < sumArrayList.size(); ++j) {
                sumArrayList.set(j, sumArrayList.get(j) + deltaY);
            }
        }
    }

    public static List<ROI2D> loadROIsFromXML(Document doc) {
        List localList = ROI.loadROIsFromXML((Node)XMLUtil.getRootElement((Document)doc));
        ArrayList<ROI2D> finalList = new ArrayList<ROI2D>(localList.size());
        for (ROI roi : localList) {
            finalList.add((ROI2D)roi);
        }
        return finalList;
    }

    public static Polygon2D orderVerticesofPolygon(Polygon roiPolygon) {
        int i;
        if (roiPolygon.npoints > 4) {
            new AnnounceFrame("Only the first 4 points of the polygon will be used...");
        }
        Polygon2D extFrame = new Polygon2D();
        Rectangle rect = roiPolygon.getBounds();
        Rectangle rect1 = new Rectangle(rect);
        rect1.setSize(rect.width / 2, rect.height / 2);
        for (i = 0; i < roiPolygon.npoints; ++i) {
            if (!rect1.contains(roiPolygon.xpoints[i], roiPolygon.ypoints[i])) continue;
            extFrame.addPoint((double)roiPolygon.xpoints[i], (double)roiPolygon.ypoints[i]);
            break;
        }
        rect1.translate(0, rect.height / 2 + 2);
        for (i = 0; i < roiPolygon.npoints; ++i) {
            if (!rect1.contains(roiPolygon.xpoints[i], roiPolygon.ypoints[i])) continue;
            extFrame.addPoint((double)roiPolygon.xpoints[i], (double)roiPolygon.ypoints[i]);
            break;
        }
        rect1.translate(rect.width / 2 + 2, 0);
        for (i = 0; i < roiPolygon.npoints; ++i) {
            if (!rect1.contains(roiPolygon.xpoints[i], roiPolygon.ypoints[i])) continue;
            extFrame.addPoint((double)roiPolygon.xpoints[i], (double)roiPolygon.ypoints[i]);
            break;
        }
        rect1.translate(0, -rect.height / 2 - 2);
        for (i = 0; i < roiPolygon.npoints; ++i) {
            if (!rect1.contains(roiPolygon.xpoints[i], roiPolygon.ypoints[i])) continue;
            extFrame.addPoint((double)roiPolygon.xpoints[i], (double)roiPolygon.ypoints[i]);
            break;
        }
        return extFrame;
    }

    public static Polygon2D inflate(Polygon2D roiPolygon, int ncolumns, int nrows, int width_cage, int width_interval) {
        double width_x_current = ncolumns * (width_cage + 2 * width_interval) - 2 * width_interval;
        double deltax_top = (roiPolygon.xpoints[3] - roiPolygon.xpoints[0]) * (double)width_interval / width_x_current;
        double deltax_bottom = (roiPolygon.xpoints[2] - roiPolygon.xpoints[1]) * (double)width_interval / width_x_current;
        double width_y_current = nrows * (width_cage + 2 * width_interval) - 2 * width_interval;
        double deltay_left = (roiPolygon.ypoints[1] - roiPolygon.ypoints[0]) * (double)width_interval / width_y_current;
        double deltay_right = (roiPolygon.ypoints[2] - roiPolygon.ypoints[3]) * (double)width_interval / width_y_current;
        double[] xpoints = new double[4];
        double[] ypoints = new double[4];
        int npoints = 4;
        xpoints[0] = roiPolygon.xpoints[0] - deltax_top;
        xpoints[1] = roiPolygon.xpoints[1] - deltax_bottom;
        xpoints[3] = roiPolygon.xpoints[3] + deltax_top;
        xpoints[2] = roiPolygon.xpoints[2] + deltax_bottom;
        ypoints[0] = roiPolygon.ypoints[0] - deltay_left;
        ypoints[3] = roiPolygon.ypoints[3] - deltay_right;
        ypoints[1] = roiPolygon.ypoints[1] + deltay_left;
        ypoints[2] = roiPolygon.ypoints[2] + deltay_right;
        Polygon2D result = new Polygon2D(xpoints, ypoints, npoints);
        return result;
    }

    public static Point2D lineIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double denom = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (denom == 0.0) {
            return null;
        }
        double ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / denom;
        double ub = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / denom;
        if (ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0) {
            return new Point2D.Double(x1 + ua * (x2 - x1), y1 + ua * (y2 - y1));
        }
        return null;
    }

    public static List<ROI2D> getROIs2DContainingString(String string, Sequence seq) {
        ArrayList roiList = seq.getROI2Ds();
        Collections.sort(roiList, new Comparators.ROI2D_Name_Comparator());
        ArrayList<ROI2D> capillaryRois = new ArrayList<ROI2D>();
        for (ROI2D roi : roiList) {
            if (!(roi instanceof ROI2DShape) || !roi.getName().contains(string)) continue;
            capillaryRois.add(roi);
        }
        return capillaryRois;
    }

    public static void removeRoisContainingString(int t, String string, Sequence seq) {
        for (ROI roi : seq.getROIs()) {
            if (!(roi instanceof ROI2D) || !roi.getName().contains(string) || t >= 0 && ((ROI2D)roi).getT() != t) continue;
            seq.removeROI(roi);
        }
    }

    public static Polygon2D getCapillariesFrame(ArrayList<ROI2D> listRois) {
        double xmin;
        ROI2D roi1 = listRois.get(0);
        ROI2D roi2 = listRois.get(listRois.size() - 1);
        double xmax = xmin = roi1.getBounds().getX();
        for (ROI2D roi : listRois) {
            if (!roi.getName().contains("line")) continue;
            double x = roi.getBounds().getX();
            if (x < xmin) {
                xmin = x;
                roi1 = roi;
                continue;
            }
            if (!(x > xmax)) continue;
            xmax = x;
            roi2 = roi;
        }
        return ROI2DUtilities.getPolygon2DFromROIs(roi1, roi2);
    }

    private static Polygon2D getPolygon2DFromROIs(ROI2D roi1, ROI2D roi2) {
        ArrayList<Point2D> listPoints = new ArrayList<Point2D>();
        listPoints.add(ROI2DUtilities.getFirstPoint(roi1));
        listPoints.add(ROI2DUtilities.getLastPoint(roi1));
        listPoints.add(ROI2DUtilities.getFirstPoint(roi2));
        listPoints.add(ROI2DUtilities.getLastPoint(roi2));
        Polygon2D polygon = new Polygon2D(listPoints);
        Polygon2D roiPolygon = ROI2DUtilities.orderVerticesofPolygon(polygon.getPolygon());
        return roiPolygon;
    }

    private static Point2D getFirstPoint(ROI2D roi) {
        Rectangle rect = roi.getBounds();
        return new Point2D.Double(rect.getX(), rect.getY());
    }

    private static Point2D getLastPoint(ROI2D roi) {
        Rectangle rect = roi.getBounds();
        return new Point2D.Double(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight());
    }

    public static ArrayList<Point2D> getCapillaryPoints(ROI2D roi) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        if (roi instanceof ROI2DPolyLine) {
            Polyline2D line = ((ROI2DPolyLine)roi).getPolyline2D();
            for (int i = 0; i < line.npoints; ++i) {
                Point2D.Double pt = new Point2D.Double(line.xpoints[i], line.ypoints[i]);
                points.add(pt);
            }
        } else if (roi instanceof ROI2DLine) {
            Line2D line = ((ROI2DLine)roi).getLine();
            Point2D.Double pt = new Point2D.Double(line.getP1().getX(), line.getP1().getY());
            points.add(pt);
            pt = new Point2D.Double(line.getP2().getX(), line.getP2().getY());
            points.add(pt);
        }
        return points;
    }

    public static void saveToXML_ROI(Node node, ROI2D roi) {
        Element nodeROI = XMLUtil.setElement((Node)node, (String)ID_ROIMC);
        if (!roi.saveToXML((Node)nodeROI)) {
            XMLUtil.removeNode((Node)node, (Node)nodeROI);
            System.err.println("Error: the roi " + roi.getName() + " was not correctly saved to XML !");
        }
    }

    public static ROI2D loadFromXML_ROI(Node node) {
        Element nodeROI = XMLUtil.getElement((Node)node, (String)ID_ROIMC);
        if (nodeROI != null) {
            ROI2D roi = (ROI2D)ROI2D.createFromXML((Node)nodeROI);
            return roi;
        }
        return null;
    }
}

