/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.sequence;

import icy.file.xml.XMLPersistent;
import icy.roi.ROI2D;
import icy.util.XMLUtil;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.areatrack.sequence.XYTaValue;
import plugins.fmp.areatrack.tools.EnumArrayListType;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class XYTaSeries
implements XMLPersistent {
    public ROI2DPolygon roi;
    public Double threshold = 50.0;
    public int lastTimeAlive = 0;
    public int lastIntervalAlive = 0;
    public ArrayList<XYTaValue> pointsList = new ArrayList();

    public XYTaSeries(ROI2D roi) {
        this.roi = (ROI2DPolygon)roi;
    }

    public XYTaSeries() {
        this.roi = new ROI2DPolygon();
    }

    public void ensureCapacity(int minCapacity) {
        this.pointsList.ensureCapacity(minCapacity);
    }

    public Point2D getPoint(int i) {
        return this.pointsList.get((int)i).point;
    }

    public int getTime(int i) {
        return this.pointsList.get((int)i).time;
    }

    public String getName() {
        return this.roi.getName();
    }

    public void add(Point2D point, int frame) {
        XYTaValue pos = new XYTaValue(point, frame);
        this.pointsList.add(pos);
    }

    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        Element node_roi = XMLUtil.getElement((Node)node, (String)"roi");
        this.roi.loadFromXML((Node)node_roi);
        Element node_lastime = XMLUtil.getElement((Node)node, (String)"lastTimeItMoved");
        this.lastTimeAlive = XMLUtil.getAttributeIntValue((Element)node_lastime, (String)"tlast", (int)-1);
        this.lastIntervalAlive = XMLUtil.getAttributeIntValue((Element)node_lastime, (String)"ilast", (int)-1);
        Element node_position_list = XMLUtil.getElement((Node)node, (String)"PositionsList");
        if (node_position_list == null) {
            return false;
        }
        this.pointsList.clear();
        int nb_items = XMLUtil.getAttributeIntValue((Element)node_position_list, (String)"nb_items", (int)0);
        for (int i = 0; i < nb_items; ++i) {
            String elementi = "i" + i;
            Element node_position_i = XMLUtil.getElement((Node)node_position_list, (String)elementi);
            XYTaValue pos = new XYTaValue();
            pos.loadFromXML(node_position_i);
            this.pointsList.add(pos);
        }
        return true;
    }

    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        Element node_roi = XMLUtil.addElement((Node)node, (String)"roi");
        this.roi.saveToXML((Node)node_roi);
        Element node_lastime = XMLUtil.addElement((Node)node, (String)"lastTimeAlive");
        XMLUtil.setAttributeIntValue((Element)node_lastime, (String)"tlast", (int)this.lastTimeAlive);
        XMLUtil.setAttributeIntValue((Element)node_lastime, (String)"ilast", (int)this.lastIntervalAlive);
        Element node_position_list = XMLUtil.addElement((Node)node, (String)"PositionsList");
        XMLUtil.setAttributeIntValue((Element)node_position_list, (String)"nb_items", (int)this.pointsList.size());
        int i = 0;
        for (XYTaValue pos : this.pointsList) {
            String elementi = "i" + i;
            Element node_position_i = XMLUtil.addElement((Node)node_position_list, (String)elementi);
            pos.saveToXML(node_position_i);
            ++i;
        }
        return true;
    }

    public ArrayList<Double> getDoubleArrayList(EnumArrayListType option) {
        if (this.pointsList.size() == 0) {
            return null;
        }
        ArrayList<Double> datai = null;
        switch (option) {
            case distance: {
                datai = this.getDistanceBetweenPoints();
                break;
            }
            case isalive: {
                datai = this.getDistanceBetweenPoints();
                this.computeIsAlive(datai, this.threshold);
                datai = this.getIsAliveAsDoubleArray();
                break;
            }
            default: {
                datai = this.getXYPositions();
            }
        }
        return datai;
    }

    public int computeLastIntervalAlive() {
        this.computeIsAlive(this.getDistanceBetweenPoints(), this.threshold);
        return this.lastIntervalAlive;
    }

    private ArrayList<Double> getDistanceBetweenPoints() {
        ArrayList<Double> dataArray = new ArrayList<Double>();
        dataArray.ensureCapacity(this.pointsList.size());
        Point2D previous = new Point2D.Double();
        previous = this.pointsList.get((int)0).point;
        for (XYTaValue pos : this.pointsList) {
            double distance = pos.point.distance(previous);
            dataArray.add(distance);
            previous = pos.point;
        }
        return dataArray;
    }

    public ArrayList<Double> getIsAliveAsDoubleArray() {
        ArrayList<Double> dataArray = new ArrayList<Double>();
        dataArray.ensureCapacity(this.pointsList.size());
        for (XYTaValue pos : this.pointsList) {
            dataArray.add(pos.alive ? 1.0 : 0.0);
        }
        return dataArray;
    }

    public ArrayList<Integer> getIsAliveAsIntegerArray() {
        ArrayList<Integer> dataArray = new ArrayList<Integer>();
        dataArray.ensureCapacity(this.pointsList.size());
        for (XYTaValue pos : this.pointsList) {
            dataArray.add(pos.alive ? 1 : 0);
        }
        return dataArray;
    }

    public void computeIsAlive(ArrayList<Double> data, Double threshold) {
        this.threshold = threshold;
        this.lastIntervalAlive = 0;
        boolean isalive = false;
        for (int i = data.size() - 1; i >= 0; --i) {
            if (data.get(i) > threshold && !isalive) {
                this.lastIntervalAlive = i;
                this.lastTimeAlive = this.pointsList.get((int)i).time;
                isalive = true;
            }
            this.pointsList.get((int)i).alive = isalive;
        }
    }

    private ArrayList<Double> getXYPositions() {
        ArrayList<Double> dataArray = new ArrayList<Double>();
        dataArray.ensureCapacity(this.pointsList.size() * 2);
        for (XYTaValue pos : this.pointsList) {
            double x = pos.point.getX();
            double y = pos.point.getY();
            dataArray.add(x);
            dataArray.add(y);
        }
        return dataArray;
    }

    public int getLastIntervalAlive() {
        if (this.lastIntervalAlive >= 0) {
            return this.lastIntervalAlive;
        }
        return this.computeLastIntervalAlive();
    }
}

