/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.tools;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.colormap.IcyColorMap;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import plugins.fmp.areatrack.sequence.SequenceVirtual;
import plugins.fmp.areatrack.tools.EnumColorDistanceType;
import plugins.fmp.areatrack.tools.EnumImageOp;
import plugins.fmp.areatrack.tools.ImageOperations;
import plugins.fmp.areatrack.tools.OverlayColorMask;

public class OverlayThreshold
extends Overlay {
    private ImageOperations imgOp = null;
    private float opacity = 0.3f;
    private OverlayColorMask map = new OverlayColorMask("", new Color(0xFF0000, true));

    public OverlayThreshold() {
        super("ThresholdOverlay");
    }

    public OverlayThreshold(SequenceVirtual seq) {
        super("ThresholdOverlay");
        this.setSequence(seq);
    }

    public void setSequence(SequenceVirtual seq) {
        if (seq == null) {
            return;
        }
        if (this.imgOp == null) {
            this.imgOp = new ImageOperations(seq);
        }
        this.imgOp.setSequence(seq);
    }

    public void setTransform(EnumImageOp transf) {
        this.imgOp.setTransform(transf);
    }

    public void setThresholdSingle(int threshold, boolean thresholdUp) {
        this.imgOp.setThresholdToSingleValue(threshold, thresholdUp);
    }

    public void setThresholdColor(ArrayList<Color> colorarray, EnumColorDistanceType distancetype, int threshold) {
        this.imgOp.setThresholdToColorArray(colorarray, distancetype, threshold);
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        IcyBufferedImage thresholdedImage;
        if (canvas instanceof IcyCanvas2D && g != null && (thresholdedImage = this.imgOp.run(canvas.getPositionT())) != null) {
            thresholdedImage.setColorMap(0, (IcyColorMap)this.map);
            try {
                BufferedImage bufferedImage = IcyBufferedImageUtil.getARGBImage((IcyBufferedImage)thresholdedImage);
                Composite bck = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, this.opacity));
                g.drawImage((Image)bufferedImage, 0, 0, null);
                g.setComposite(bck);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

