/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.tools;

import plugins.fmp.areatrack.tools.FmpTools;

public class StringSorter {
    public static void sort(String[] a) {
        if (!StringSorter.alreadySorted(a)) {
            StringSorter.sort(a, 0, a.length - 1);
        }
    }

    static void sort(String[] a, int from, int to) {
        int i = from;
        int j = to;
        String center = a[(from + to) / 2];
        while (true) {
            if (i < to && center.compareTo(a[i]) > 0) {
                ++i;
                continue;
            }
            while (j > from && center.compareTo(a[j]) < 0) {
                --j;
            }
            if (i < j) {
                String temp = a[i];
                a[i] = a[j];
                a[j] = temp;
            }
            if (i <= j) {
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (from < j) {
            StringSorter.sort(a, from, j);
        }
        if (i < to) {
            StringSorter.sort(a, i, to);
        }
    }

    static boolean alreadySorted(String[] a) {
        for (int i = 1; i < a.length; ++i) {
            if (a[i].compareTo(a[i - 1]) >= 0) continue;
            return false;
        }
        return true;
    }

    public static String[] sortNumerically(String[] list) {
        int n = list.length;
        String[] paddedList = StringSorter.getPaddedNames(list);
        String[] sortedList = new String[n];
        int[] indexes = FmpTools.rank(paddedList);
        for (int i = 0; i < n; ++i) {
            sortedList[i] = list[indexes[i]];
        }
        return sortedList;
    }

    private static String[] getPaddedNames(String[] names) {
        String name;
        int jj;
        int nNames = names.length;
        String[] paddedNames = new String[nNames];
        int maxLen = 0;
        for (int jj2 = 0; jj2 < nNames; ++jj2) {
            if (names[jj2].length() <= maxLen) continue;
            maxLen = names[jj2].length();
        }
        int maxNums = maxLen / 2 + 1;
        int[][] numberStarts = new int[names.length][maxNums];
        int[][] numberLengths = new int[names.length][maxNums];
        int[] maxDigits = new int[maxNums];
        for (jj = 0; jj < names.length; ++jj) {
            name = names[jj];
            boolean inNumber = false;
            int nNumbers = 0;
            int nDigits = 0;
            for (int pos = 0; pos < name.length(); ++pos) {
                boolean isDigit;
                boolean bl = isDigit = name.charAt(pos) >= '0' && name.charAt(pos) <= '9';
                if (isDigit) {
                    ++nDigits;
                    if (!inNumber) {
                        numberStarts[jj][nNumbers] = pos;
                        inNumber = true;
                    }
                }
                if (!inNumber || isDigit && pos != name.length() - 1) continue;
                inNumber = false;
                if (maxDigits[nNumbers] < nDigits) {
                    maxDigits[nNumbers] = nDigits;
                }
                numberLengths[jj][nNumbers] = nDigits;
                ++nNumbers;
                nDigits = 0;
            }
        }
        for (jj = 0; jj < names.length; ++jj) {
            name = names[jj];
            int numIndex = 0;
            StringBuilder destName = new StringBuilder();
            for (int srcPtr = 0; srcPtr < name.length(); ++srcPtr) {
                if (srcPtr == numberStarts[jj][numIndex]) {
                    int numLen = numberLengths[jj][numIndex];
                    if (numLen > 0) {
                        for (int pad = 0; pad < maxDigits[numIndex] - numLen; ++pad) {
                            destName.append('0');
                        }
                    }
                    ++numIndex;
                }
                destName.append(name.charAt(srcPtr));
            }
            paddedNames[jj] = destName.toString();
        }
        return paddedNames;
    }
}

