/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.DimensionId;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import plugins.fmp.areatrack.commons.DetectionParameters;
import plugins.fmp.areatrack.commons.GraphsWindow;
import plugins.fmp.areatrack.dlg.Dlg1_Source;
import plugins.fmp.areatrack.dlg.Dlg2_Grids;
import plugins.fmp.areatrack.dlg.Dlg3_ParametersArea;
import plugins.fmp.areatrack.dlg.Dlg4_ParametersMovements;
import plugins.fmp.areatrack.dlg.Dlg5_AnalysisRun;
import plugins.fmp.areatrack.dlg.Dlg6_ResultsExport;
import plugins.fmp.areatrack.sequence.SequencePlus;
import plugins.fmp.areatrack.tools.EnumAreaDetection;

public class Areatrack
extends PluginActionable
implements ViewerListener {
    public IcyFrame mainFrame = new IcyFrame("AreaTrack 17-Nov-2024", true, true, true, true);
    public GraphsWindow displayCharts = null;
    Dlg1_Source dlg1_Source = new Dlg1_Source();
    Dlg2_Grids dlg2_Grids = new Dlg2_Grids();
    Dlg3_ParametersArea dlg3_ParametersArea = new Dlg3_ParametersArea();
    Dlg4_ParametersMovements dlg4_ParametersMovements = new Dlg4_ParametersMovements();
    public Dlg5_AnalysisRun dlg5_AnalysisRun = new Dlg5_AnalysisRun();
    public Dlg6_ResultsExport dlg6_ResultsExport = new Dlg6_ResultsExport();
    public DetectionParameters detectionParameters = new DetectionParameters();
    public SequencePlus vSequence = null;

    public void run() {
        JPanel mainPanel = GuiUtil.generatePanelWithoutBorder();
        this.dlg1_Source.init(this, this.mainFrame, mainPanel, "1 - Images stack");
        this.dlg2_Grids.init(this, this.mainFrame, mainPanel, "2 - Cells grid define/load");
        this.dlg3_ParametersArea.init(this, this.mainFrame, mainPanel, "3 - Area measure parameters");
        this.dlg4_ParametersMovements.init(this, this.mainFrame, mainPanel, "4 - Movements detection parameters");
        this.dlg5_AnalysisRun.init(this, this.mainFrame, mainPanel, "5 - Run analysis");
        this.dlg6_ResultsExport.init(this, this.mainFrame, mainPanel, "6 - Display/export results");
        this.mainFrame.setLayout((LayoutManager)new BorderLayout());
        this.mainFrame.add((Component)mainPanel, (Object)"West");
        this.mainFrame.pack();
        this.mainFrame.center();
        this.mainFrame.setVisible(true);
        this.mainFrame.addToDesktopPane();
    }

    public void viewerChanged(ViewerEvent event) {
        if (event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED && event.getDim() == DimensionId.T) {
            this.vSequence.currentFrame = event.getSource().getPositionT();
        }
    }

    public void viewerClosed(Viewer viewer) {
        viewer.removeListener((ViewerListener)this);
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)Areatrack.class.getName()));
    }

    public void setOverlay(boolean displayOverlay) {
        if (this.vSequence == null) {
            return;
        }
        this.detectionParameters.displayOverlay = displayOverlay;
        this.vSequence.setThresholdOverlay(displayOverlay);
        if (displayOverlay) {
            if (this.detectionParameters.areaDetectionMode == EnumAreaDetection.SINGLE) {
                this.vSequence.setThresholdOverlayParametersSingle(this.detectionParameters);
            } else {
                this.vSequence.setThresholdOverlayParametersColors(this.detectionParameters);
            }
        }
    }
}

