/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.dlg;

import icy.gui.component.PopupPanel;
import icy.gui.frame.IcyFrame;
import icy.gui.util.FontUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.areatrack.Areatrack;
import plugins.fmp.areatrack.commons.DetectionParameters;
import plugins.fmp.areatrack.dlg.Dlg3_TabColors;
import plugins.fmp.areatrack.dlg.Dlg3_TabFilter;
import plugins.fmp.areatrack.dlg.Dlg3_TabOverlay;
import plugins.fmp.areatrack.tools.EnumAreaDetection;

public class Dlg3_ParametersArea
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -359095233032653215L;
    Dlg3_TabColors dlgTabThresholdColors = new Dlg3_TabColors();
    Dlg3_TabFilter dlgTabThresholdFunction = new Dlg3_TabFilter();
    Dlg3_TabOverlay dlgTabOverlay = new Dlg3_TabOverlay();
    JCheckBox detectAreaCheckBox = new JCheckBox("Detect ");
    JRadioButton rbFilterbyColor = new JRadioButton("color array");
    JRadioButton rbFilterbyFunction = new JRadioButton("filters");
    JCheckBox overlayCheckBox = new JCheckBox("overlay");
    JButton loadButton = new JButton("Load...");
    JButton saveButton = new JButton("Save...");
    JTabbedPane tabbedPane = new JTabbedPane(1, 1);
    Areatrack areatrack = null;

    public void init(Areatrack areatrack, final IcyFrame mainFrame, JPanel mainPanel, String title) {
        this.areatrack = areatrack;
        PopupPanel capPopupPanel = new PopupPanel(title);
        JPanel capPanel = capPopupPanel.getMainPanel();
        capPanel.setLayout(new BorderLayout());
        capPopupPanel.collapse();
        capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                mainFrame.revalidate();
                mainFrame.pack();
                mainFrame.repaint();
            }
        });
        mainPanel.add((Component)capPopupPanel);
        FlowLayout layoutLeft = new FlowLayout(0);
        JPanel panel0 = new JPanel(layoutLeft);
        ((FlowLayout)panel0.getLayout()).setVgap(0);
        panel0.add(this.detectAreaCheckBox);
        panel0.add(this.rbFilterbyColor);
        panel0.add(this.rbFilterbyFunction);
        ButtonGroup bgchoice = new ButtonGroup();
        bgchoice.add(this.rbFilterbyColor);
        bgchoice.add(this.rbFilterbyFunction);
        panel0.add(this.overlayCheckBox);
        capPanel.add((Component)panel0, "First");
        GridLayout capLayout = new GridLayout(3, 2);
        this.dlgTabThresholdColors.init(this.tabbedPane, capLayout, areatrack);
        this.dlgTabThresholdFunction.init(this.tabbedPane, capLayout, areatrack);
        this.dlgTabOverlay.init(this.tabbedPane, capLayout);
        capPanel.add((Component)this.tabbedPane, "Center");
        JLabel loadsaveText1 = new JLabel("-> File (xml) ");
        loadsaveText1.setHorizontalAlignment(4);
        loadsaveText1.setFont(FontUtil.setStyle((Font)loadsaveText1.getFont(), (int)2));
        FlowLayout layoutRight = new FlowLayout(2);
        JPanel panel2 = new JPanel(layoutRight);
        panel2.add(loadsaveText1);
        panel2.add(this.loadButton);
        panel2.add(this.saveButton);
        capPanel.add((Component)panel2, "Last");
        this.detectAreaCheckBox.setSelected(true);
        this.tabbedPane.setSelectedIndex(0);
        this.rbFilterbyColor.setSelected(true);
        this.declareActionListeners();
        this.tabbedPane.addChangeListener(this);
    }

    private void declareActionListeners() {
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg3_ParametersArea.this.loadParameters();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg3_ParametersArea.this.saveParameters();
            }
        });
        this.rbFilterbyColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Dlg3_ParametersArea.this.rbFilterbyColor.isSelected()) {
                    Dlg3_ParametersArea.this.selectTab(0);
                }
            }
        });
        this.rbFilterbyFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Dlg3_ParametersArea.this.rbFilterbyFunction.isSelected()) {
                    Dlg3_ParametersArea.this.selectTab(1);
                }
            }
        });
        this.overlayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dlg3_ParametersArea.this.areatrack.setOverlay(Dlg3_ParametersArea.this.overlayCheckBox.isSelected());
            }
        });
    }

    private void selectTab(int index) {
        this.tabbedPane.setSelectedIndex(index);
    }

    private void loadParameters() {
        if (this.areatrack.detectionParameters.xmlLoadAreaTrackParameters(this.areatrack.vSequence)) {
            this.transferParametersToDialog(this.areatrack.detectionParameters);
            this.updateThresholdOverlayParameters(this.tabbedPane.getSelectedIndex());
        }
    }

    private void saveParameters() {
        this.transferDialogToParameters(this.areatrack.detectionParameters);
        this.areatrack.detectionParameters.xmlSaveAreaTrackParameters(this.areatrack.vSequence);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.tabbedPane) {
            int selectedTab = this.tabbedPane.getSelectedIndex();
            this.updateThresholdOverlayParameters(selectedTab);
            if (selectedTab == 0) {
                this.rbFilterbyColor.setSelected(true);
                this.areatrack.detectionParameters.areaDetectionMode = EnumAreaDetection.COLORARRAY;
            } else if (selectedTab == 1) {
                this.rbFilterbyFunction.setSelected(true);
                this.areatrack.detectionParameters.areaDetectionMode = EnumAreaDetection.SINGLE;
            }
        }
    }

    public void updateThresholdOverlayParameters(int selectedTab) {
        switch (selectedTab) {
            case 1: {
                this.areatrack.detectionParameters.areaDetectionMode = EnumAreaDetection.SINGLE;
                this.dlgTabThresholdFunction.updateThresholdOverlayParameters();
                break;
            }
            default: {
                this.areatrack.detectionParameters.areaDetectionMode = EnumAreaDetection.COLORARRAY;
                this.dlgTabThresholdColors.updateThresholdOverlayParameters();
            }
        }
    }

    public void transferParametersToDialog(DetectionParameters detectionParameters) {
        this.dlgTabThresholdColors.transferParametersToDialog(detectionParameters);
        this.dlgTabThresholdFunction.transferParametersToDialog(detectionParameters);
        if (detectionParameters.areaDetectionMode == EnumAreaDetection.COLORARRAY) {
            this.rbFilterbyColor.setSelected(true);
        } else {
            this.rbFilterbyFunction.setSelected(true);
        }
        this.detectAreaCheckBox.setSelected(detectionParameters.detectArea);
        this.overlayCheckBox.setSelected(detectionParameters.displayOverlay);
    }

    public void transferDialogToParameters(DetectionParameters detectionParameters) {
        this.dlgTabThresholdColors.transferDialogToParameters(detectionParameters);
        this.dlgTabThresholdFunction.transferDialogToParameters(detectionParameters);
        detectionParameters.detectArea = this.detectAreaCheckBox.isSelected();
        detectionParameters.areaDetectionMode = this.rbFilterbyColor.isSelected() ? EnumAreaDetection.COLORARRAY : EnumAreaDetection.SINGLE;
        detectionParameters.displayOverlay = this.overlayCheckBox.isSelected();
    }
}

