/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.dlg;

import icy.gui.component.PopupPanel;
import icy.gui.frame.IcyFrame;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.areatrack.Areatrack;
import plugins.fmp.areatrack.commons.DetectionParameters;

public class Dlg4_ParametersMovements
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -2921692090190746442L;
    JCheckBox detectCheckBox = new JCheckBox("Detect ");
    JSpinner threshold2Spinner = new JSpinner(new SpinnerNumberModel(20, 0, 255, 1));
    Areatrack areatrack = null;

    public void init(Areatrack areatrack, final IcyFrame mainFrame, JPanel mainPanel, String title) {
        this.areatrack = areatrack;
        PopupPanel capPopupPanel = new PopupPanel(title);
        capPopupPanel.collapse();
        capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                mainFrame.revalidate();
                mainFrame.pack();
                mainFrame.repaint();
            }
        });
        mainPanel.add((Component)capPopupPanel);
        JPanel capPanel = capPopupPanel.getMainPanel();
        capPanel.setLayout(new GridLayout(1, 1));
        FlowLayout layoutRight = new FlowLayout(0);
        JPanel panel1 = new JPanel(layoutRight);
        JLabel thresholdLabel2 = new JLabel("'move' threshold ");
        panel1.add(this.detectCheckBox);
        panel1.add(thresholdLabel2);
        panel1.add(this.threshold2Spinner);
        capPanel.add(panel1);
        this.threshold2Spinner.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.threshold2Spinner) {
            this.updateThresholdOverlayParameters();
        }
    }

    void updateThresholdOverlayParameters() {
        this.areatrack.detectionParameters.thresholdmovement = (Integer)this.threshold2Spinner.getValue();
    }

    public void transferParametersToDialog(DetectionParameters detectionParameters) {
        this.detectCheckBox.setSelected(detectionParameters.detectMovement);
        this.threshold2Spinner.setValue(detectionParameters.thresholdmovement);
    }

    public void transferDialogToParameters(DetectionParameters detectionParameters) {
        detectionParameters.thresholdmovement = (Integer)this.threshold2Spinner.getValue();
        detectionParameters.detectMovement = this.detectCheckBox.isSelected();
    }
}

