/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.sequence;

import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.edit.ROIAddsSequenceEdit;
import icy.undo.IcyUndoableEdit;
import icy.util.XMLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.areatrack.sequence.SequenceVirtual;
import plugins.fmp.areatrack.tools.FmpTools;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Capillaries {
    public String sourceName = null;
    public ArrayList<ROI2DShape> capillariesArrayList = new ArrayList();
    public long analysisStart = 0L;
    public long analysisEnd = 0L;
    public int analysisStep = 1;

    public boolean xmlReadCapillaryParameters(Document doc) {
        String nodeName = "capillaryTrack";
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)nodeName);
        if (node == null) {
            return false;
        }
        Element xmlElement = XMLUtil.getElement((Node)node, (String)"Parameters");
        if (xmlElement == null) {
            return false;
        }
        Element xmlVal = XMLUtil.getElement((Node)xmlElement, (String)"file");
        this.sourceName = XMLUtil.getAttributeValue((Element)xmlVal, (String)"ID", null);
        xmlVal = XMLUtil.getElement((Node)xmlElement, (String)"analysis");
        if (xmlVal != null) {
            this.analysisStart = XMLUtil.getAttributeLongValue((Element)xmlVal, (String)"start", (long)0L);
            this.analysisEnd = XMLUtil.getAttributeLongValue((Element)xmlVal, (String)"end", (long)0L);
            this.analysisStep = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"step", (int)1);
        }
        return true;
    }

    private boolean xmlWriteCapillaryParameters(Document doc, SequenceVirtual sequenceVirtual) {
        String nodeName = "capillaryTrack";
        Element node = XMLUtil.addElement((Node)XMLUtil.getRootElement((Document)doc), (String)nodeName);
        if (node == null) {
            return false;
        }
        Element xmlElement = XMLUtil.addElement((Node)node, (String)"Parameters");
        Element xmlVal = XMLUtil.addElement((Node)xmlElement, (String)"file");
        this.sourceName = sequenceVirtual.getFileName(0);
        XMLUtil.setAttributeValue((Element)xmlVal, (String)"ID", (String)this.sourceName);
        xmlVal = XMLUtil.addElement((Node)xmlElement, (String)"analysis");
        XMLUtil.setAttributeLongValue((Element)xmlVal, (String)"start", (long)sequenceVirtual.analysisStart);
        XMLUtil.setAttributeLongValue((Element)xmlVal, (String)"end", (long)sequenceVirtual.analysisEnd);
        XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"step", (int)sequenceVirtual.analysisStep);
        return true;
    }

    public void extractLinesFromSequence(SequenceVirtual sequenceVirtual) {
        this.capillariesArrayList.clear();
        ArrayList list = sequenceVirtual.seq.getROI2Ds();
        for (ROI2D roi : list) {
            if (!(roi instanceof ROI2DShape) || !roi.getName().contains("line") || !(roi instanceof ROI2DLine) && !(roi instanceof ROI2DPolyLine)) continue;
            this.capillariesArrayList.add((ROI2DShape)roi);
        }
        Collections.sort(this.capillariesArrayList, new FmpTools.ROI2DNameComparator());
    }

    public void extractROIsWithPattern(SequenceVirtual sequenceVirtual, String pattern) {
        this.capillariesArrayList.clear();
        ArrayList list = sequenceVirtual.seq.getROI2Ds();
        for (ROI2D roi : list) {
            if (!(roi instanceof ROI2DShape) || !roi.getName().contains(pattern) || !(roi instanceof ROI2DLine) && !(roi instanceof ROI2DPolyLine)) continue;
            this.capillariesArrayList.add((ROI2DShape)roi);
        }
        Collections.sort(this.capillariesArrayList, new FmpTools.ROI2DNameComparator());
    }

    public boolean xmlWriteROIsAndData(String name, SequenceVirtual seq) {
        String csFile = FmpTools.saveFileAs(name, seq.getDirectory(), "xml");
        csFile.toLowerCase();
        if (!csFile.contains(".xml")) {
            csFile = csFile + ".xml";
        }
        return this.xmlWriteROIsAndDataNoQuestion(csFile, seq);
    }

    public boolean xmlWriteROIsAndDataNoQuestion(String csFile, SequenceVirtual seq) {
        if (csFile != null) {
            Document doc;
            this.extractLinesFromSequence(seq);
            if (this.capillariesArrayList.size() > 0 && (doc = XMLUtil.createDocument((boolean)true)) != null) {
                ArrayList<ROI> roisList = new ArrayList<ROI>();
                for (ROI rOI : this.capillariesArrayList) {
                    roisList.add(rOI);
                }
                ROI.saveROIsToXML((Node)XMLUtil.getRootElement((Document)doc), roisList);
                this.xmlWriteCapillaryParameters(doc, seq);
                XMLUtil.saveDocument((Document)doc, (String)csFile);
                return true;
            }
        }
        return false;
    }

    public boolean xmlWriteROIsAndDataNoFilter(String name, SequenceVirtual sequenceVirtual) {
        Document doc;
        String csFile = FmpTools.saveFileAs(name, sequenceVirtual.getDirectory(), "xml");
        csFile.toLowerCase();
        if (!csFile.contains(".xml")) {
            csFile = csFile + ".xml";
        }
        if ((doc = XMLUtil.createDocument((boolean)true)) != null) {
            ArrayList roisList = sequenceVirtual.seq.getROIs();
            ROI.saveROIsToXML((Node)XMLUtil.getRootElement((Document)doc), (List)roisList);
            this.xmlWriteCapillaryParameters(doc, sequenceVirtual);
            XMLUtil.saveDocument((Document)doc, (String)csFile);
            return true;
        }
        return false;
    }

    public boolean xmlReadROIsAndData(SequenceVirtual sequenceVirtual) {
        String directory = sequenceVirtual.getDirectory();
        if (directory == null) {
            return false;
        }
        String[] filedummy = FmpTools.selectFiles(directory, "xml");
        boolean wasOk = false;
        if (filedummy != null) {
            for (int i = 0; i < filedummy.length; ++i) {
                String csFile = filedummy[i];
                wasOk &= this.xmlReadROIsAndData(csFile, sequenceVirtual);
            }
        }
        return wasOk;
    }

    public boolean xmlReadROIsAndData(String csFileName, SequenceVirtual sequenceVirtual) {
        Document doc;
        if (csFileName != null && (doc = XMLUtil.loadDocument((String)csFileName)) != null) {
            this.xmlReadCapillaryParameters(doc);
            List listOfROIs = ROI.loadROIsFromXML((Node)XMLUtil.getRootElement((Document)doc));
            this.capillariesArrayList.clear();
            for (ROI rOI : listOfROIs) {
                this.capillariesArrayList.add((ROI2DShape)rOI);
            }
            Collections.sort(this.capillariesArrayList, new FmpTools.ROINameComparator());
            for (ROI rOI : this.capillariesArrayList) {
                sequenceVirtual.seq.addROI(rOI);
            }
            sequenceVirtual.seq.addUndoableEdit((IcyUndoableEdit)new ROIAddsSequenceEdit(sequenceVirtual.seq, listOfROIs){

                public String getPresentationName() {
                    return this.getROIs().size() + " ROI(s) loaded from XML file";
                }
            });
            return true;
        }
        return false;
    }
}

