/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.areatrack.tools;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Color;
import java.util.ArrayList;
import plugins.fmp.areatrack.tools.EnumColorDistanceType;
import plugins.fmp.areatrack.tools.NHColorDistance;
import plugins.fmp.areatrack.tools.NHColorDistanceL1;
import plugins.fmp.areatrack.tools.NHColorDistanceL2;

public class ImageThresholdTools {
    private int colorthreshold;
    private EnumColorDistanceType colordistanceType = EnumColorDistanceType.L1;
    private int simplethreshold = 255;
    private boolean thresholdUp = true;
    private final byte byteFALSE = 0;
    private final byte byteTRUE = (byte)-1;
    private ArrayList<Color> colorarray = null;

    public void setSingleThreshold(int simplethreshold, boolean thresholdUp) {
        this.simplethreshold = simplethreshold;
        this.thresholdUp = thresholdUp;
    }

    public void setColorArrayThreshold(EnumColorDistanceType colordistanceType, int colorthreshold, ArrayList<Color> colorarray) {
        this.colordistanceType = colordistanceType;
        this.colorthreshold = colorthreshold;
        this.colorarray = colorarray;
    }

    public IcyBufferedImage getBinaryInt_FromThreshold(IcyBufferedImage sourceImage) {
        if (sourceImage == null) {
            return null;
        }
        IcyBufferedImage binaryMap = new IcyBufferedImage(sourceImage.getSizeX(), sourceImage.getSizeY(), 1, DataType.UBYTE);
        byte[] binaryMapDataBuffer = binaryMap.getDataXYAsByte(0);
        int[] imageSourceDataBuffer = null;
        DataType datatype = sourceImage.getDataType_();
        if (datatype != DataType.INT) {
            Object sourceArray = sourceImage.getDataXY(0);
            imageSourceDataBuffer = Array1DUtil.arrayToIntArray((Object)sourceArray, (boolean)sourceImage.isSignedDataType());
        } else {
            imageSourceDataBuffer = sourceImage.getDataXYAsInt(0);
        }
        int bUp = this.thresholdUp ? 0 : -1;
        int bDown = this.thresholdUp ? -1 : 0;
        for (int x = 0; x < binaryMapDataBuffer.length; ++x) {
            binaryMapDataBuffer[x] = (imageSourceDataBuffer[x] & 0xFF) > this.simplethreshold ? bUp : bDown;
        }
        return binaryMap;
    }

    public IcyBufferedImage getBinaryInt_FromColorsThreshold(IcyBufferedImage sourceImage) {
        if (this.colorarray.size() == 0) {
            return null;
        }
        if (sourceImage.getSizeC() < 3) {
            System.out.print("Failed operation: attempt to compute threshold from image with less than 3 color channels");
            return null;
        }
        NHColorDistance distance = this.colordistanceType == EnumColorDistanceType.L1 ? new NHColorDistanceL1() : new NHColorDistanceL2();
        IcyBufferedImage binaryResultBuffer = new IcyBufferedImage(sourceImage.getSizeX(), sourceImage.getSizeY(), 1, DataType.UBYTE);
        IcyBufferedImage dummy = sourceImage;
        if (sourceImage.getDataType_() == DataType.DOUBLE) {
            dummy = IcyBufferedImageUtil.convertToType((IcyBufferedImage)sourceImage, (DataType)DataType.BYTE, (boolean)false);
        }
        byte[][] sourceBuffer = dummy.getDataXYCAsByte();
        byte[] binaryResultArray = binaryResultBuffer.getDataXYAsByte(0);
        int npixels = binaryResultArray.length;
        Color pixel = new Color(0, 0, 0);
        for (int ipixel = 0; ipixel < npixels; ++ipixel) {
            int val = 0;
            pixel = new Color(sourceBuffer[0][ipixel] & 0xFF, sourceBuffer[1][ipixel] & 0xFF, sourceBuffer[2][ipixel] & 0xFF);
            for (int k = 0; k < this.colorarray.size(); ++k) {
                Color color = this.colorarray.get(k);
                if (!(distance.computeDistance(pixel, color) <= (double)this.colorthreshold)) continue;
                val = -1;
                break;
            }
            binaryResultArray[ipixel] = val;
        }
        return binaryResultBuffer;
    }

    public boolean[] getBoolMap_FromBinaryInt(IcyBufferedImage img) {
        boolean[] boolMap = new boolean[img.getSizeX() * img.getSizeY()];
        byte[] imageSourceDataBuffer = null;
        DataType datatype = img.getDataType_();
        if (datatype != DataType.BYTE && datatype != DataType.UBYTE) {
            Object sourceArray = img.getDataXY(0);
            imageSourceDataBuffer = Array1DUtil.arrayToByteArray((Object)sourceArray);
        } else {
            imageSourceDataBuffer = img.getDataXYAsByte(0);
        }
        for (int x = 0; x < boolMap.length; ++x) {
            boolMap[x] = imageSourceDataBuffer[x] != 0;
        }
        return boolMap;
    }
}

