/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fft;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.algorithm.fft.FFTFunctions;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorExpWindowingFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;

@Deprecated
public class FourierTransform<T extends RealType<T>, S extends ComplexType<S>>
implements MultiThreaded,
OutputAlgorithm<Img<S>>,
Benchmark {
    final RandomAccessibleInterval<T> input;
    final Interval interval;
    final int numDimensions;
    final T inputType;
    final ImgFactory<S> imgFactory;
    Img<S> fftImage;
    OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds;
    PreProcessing preProcessing;
    Rearrangement rearrangement;
    FFTOptimization fftOptimization;
    float relativeImageExtensionRatio;
    int[] imageExtension;
    float relativeFadeOutDistance;
    int minExtension;
    int[] originalSize;
    int[] originalOffset;
    int[] extendedSize;
    int[] extendedZeroPaddedSize;
    int[] inputSize = null;
    int[] inputSizeOffset = null;
    final S complexType;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public FourierTransform(RandomAccessibleInterval<T> input, ImgFactory<S> imgFactory, S complexType, PreProcessing preProcessing, Rearrangement rearrangement, FFTOptimization fftOptimization, float relativeImageExtension, float relativeFadeOutDistance, int minExtension) {
        this.input = input;
        this.imgFactory = imgFactory;
        this.interval = input;
        this.complexType = complexType;
        this.numDimensions = input.numDimensions();
        this.extendedSize = new int[this.numDimensions];
        this.extendedZeroPaddedSize = new int[this.numDimensions];
        this.imageExtension = new int[this.numDimensions];
        this.inputType = (RealType)Util.getTypeFromInterval(input);
        this.setPreProcessing(preProcessing);
        this.setRearrangement(rearrangement);
        this.setFFTOptimization(fftOptimization);
        this.setRelativeFadeOutDistance(relativeFadeOutDistance);
        this.setRelativeImageExtension(relativeImageExtension);
        this.setMinExtension(minExtension);
        this.originalSize = new int[this.numDimensions];
        this.originalOffset = new int[this.numDimensions];
        for (int d = 0; d < this.numDimensions; ++d) {
            if (this.interval.dimension(d) > 0x7FFFFFFEL) {
                throw new RuntimeException("FFT only supports a maximum size in each dimensions of 2147483646, but in dimension " + d + " it is " + this.interval.dimension(d));
            }
            this.originalSize[d] = (int)this.interval.dimension(d);
        }
        this.processingTime = -1L;
        this.setNumThreads();
    }

    public FourierTransform(RandomAccessibleInterval<T> input, ImgFactory<S> imgFactory, S complexType) {
        this(input, imgFactory, complexType, PreProcessing.EXTEND_MIRROR_FADING, Rearrangement.REARRANGE_QUADRANTS, FFTOptimization.SPEED, 0.25f, 0.25f, 12);
    }

    public FourierTransform(RandomAccessibleInterval<T> input, ImgFactory<S> imgFactory, S complexType, Rearrangement rearrangement) {
        this(input, imgFactory, complexType);
        this.setRearrangement(rearrangement);
    }

    public FourierTransform(RandomAccessibleInterval<T> input, ImgFactory<S> imgFactory, S complexType, FFTOptimization fftOptimization) {
        this(input, imgFactory, complexType);
        this.setFFTOptimization(fftOptimization);
    }

    public FourierTransform(RandomAccessibleInterval<T> input, ImgFactory<S> imgFactory, S complexType, PreProcessing preProcessing) {
        this(input, imgFactory, complexType);
        this.setPreProcessing(preProcessing);
    }

    public FourierTransform(Img<T> input, S complexType) throws IncompatibleTypeException {
        this(input, input.factory().imgFactory(complexType), complexType, PreProcessing.EXTEND_MIRROR_FADING, Rearrangement.REARRANGE_QUADRANTS, FFTOptimization.SPEED, 0.25f, 0.25f, 12);
    }

    public FourierTransform(Img<T> input, S complexType, Rearrangement rearrangement) throws IncompatibleTypeException {
        this(input, input.factory().imgFactory(complexType), complexType);
        this.setRearrangement(rearrangement);
    }

    public FourierTransform(Img<T> input, S complexType, PreProcessing preProcessing) throws IncompatibleTypeException {
        this(input, input.factory().imgFactory(complexType), complexType);
        this.setPreProcessing(preProcessing);
    }

    public FourierTransform(Img<T> input, S complexType, FFTOptimization fftOptimization) throws IncompatibleTypeException {
        this(input, input.factory().imgFactory(complexType), complexType);
        this.setFFTOptimization(fftOptimization);
    }

    public FourierTransform(Img<T> input, S complexType, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds) throws IncompatibleTypeException {
        this(input, input.factory().imgFactory(complexType), complexType);
        this.outOfBounds = outOfBounds;
        this.setPreProcessing(PreProcessing.USE_GIVEN_OUTOFBOUNDSSTRATEGY);
    }

    public FourierTransform(RandomAccessibleInterval<T> input, ImgFactory<S> imgFactory, S complexType, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds) {
        this(input, imgFactory, complexType);
        this.outOfBounds = outOfBounds;
        this.setPreProcessing(PreProcessing.USE_GIVEN_OUTOFBOUNDSSTRATEGY);
    }

    public void setPreProcessing(PreProcessing preProcessing) {
        this.preProcessing = preProcessing;
    }

    public void setCustomOutOfBoundsStrategy(OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds) {
        this.outOfBounds = outOfBounds;
        this.setPreProcessing(PreProcessing.USE_GIVEN_OUTOFBOUNDSSTRATEGY);
    }

    public void setRearrangement(Rearrangement rearrangement) {
        this.rearrangement = rearrangement;
    }

    public void setFFTOptimization(FFTOptimization fftOptimization) {
        this.fftOptimization = fftOptimization;
    }

    public void setRelativeFadeOutDistance(float relativeFadeOutDistance) {
        this.relativeFadeOutDistance = relativeFadeOutDistance;
    }

    public void setMinExtension(int minExtension) {
        this.minExtension = minExtension;
    }

    public void setImageExtension(int[] imageExtension) {
        this.imageExtension = (int[])imageExtension.clone();
    }

    public boolean setExtendedOriginalImageSize(int[] inputSize) {
        for (int d = 0; d < this.numDimensions; ++d) {
            if (inputSize[d] >= this.originalSize[d]) continue;
            this.errorMessage = "Cannot set extended original image size smaller than image size";
            return false;
        }
        this.inputSize = (int[])inputSize.clone();
        this.inputSizeOffset = new int[this.numDimensions];
        this.setRelativeImageExtension(this.relativeImageExtensionRatio);
        return true;
    }

    public void setRelativeImageExtension(float extensionRatio) {
        this.relativeImageExtensionRatio = extensionRatio;
        for (int d = 0; d < this.interval.numDimensions(); ++d) {
            this.imageExtension[d] = this.inputSize == null ? Util.round((float)this.interval.dimension(d) * (1.0f + extensionRatio)) - (int)this.interval.dimension(d) : Util.round((float)this.inputSize[d] * (1.0f + extensionRatio)) - (int)this.interval.dimension(d);
            if (this.imageExtension[d] < this.minExtension) {
                this.imageExtension[d] = this.minExtension;
            }
            this.extendedSize[d] = this.imageExtension[d] + (int)this.interval.dimension(d);
        }
    }

    public T getImageType() {
        return this.inputType;
    }

    public int[] getExtendedSize() {
        return (int[])this.extendedSize.clone();
    }

    public PreProcessing getPreProcessing() {
        return this.preProcessing;
    }

    public Rearrangement getRearrangement() {
        return this.rearrangement;
    }

    public FFTOptimization getFFOptimization() {
        return this.fftOptimization;
    }

    public float getRelativeImageExtension() {
        return this.relativeImageExtensionRatio;
    }

    public int[] getImageExtension() {
        return (int[])this.imageExtension.clone();
    }

    public float getRelativeFadeOutDistance() {
        return this.relativeFadeOutDistance;
    }

    public OutOfBoundsFactory<T, RandomAccessibleInterval<T>> getCustomOutOfBoundsStrategy() {
        return this.outOfBounds;
    }

    public int getMinExtension() {
        return this.minExtension;
    }

    public int[] getOriginalSize() {
        return (int[])this.originalSize.clone();
    }

    public int[] getOriginalOffset() {
        return (int[])this.originalOffset.clone();
    }

    public int[] getFFTInputOffset() {
        if (this.inputSize == null) {
            return this.originalOffset;
        }
        return this.inputSizeOffset;
    }

    public int[] getFFTInputSize() {
        if (this.inputSize == null) {
            return (int[])this.originalSize.clone();
        }
        return (int[])this.inputSize.clone();
    }

    @Override
    public boolean process() {
        OutOfBoundsFactory outOfBoundsFactory;
        long startTime = System.currentTimeMillis();
        switch (this.preProcessing) {
            case USE_GIVEN_OUTOFBOUNDSSTRATEGY: {
                if (this.outOfBounds == null) {
                    this.errorMessage = "Custom OutOfBoundsStrategyFactory is null, cannot use custom strategy";
                    return false;
                }
                this.extendedZeroPaddedSize = this.getZeroPaddingSize(this.getExtendedImageSize(this.input, this.imageExtension), this.fftOptimization);
                outOfBoundsFactory = this.outOfBounds;
                break;
            }
            case EXTEND_MIRROR: {
                this.extendedZeroPaddedSize = this.getZeroPaddingSize(this.getExtendedImageSize(this.input, this.imageExtension), this.fftOptimization);
                outOfBoundsFactory = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
                break;
            }
            case EXTEND_MIRROR_FADING: {
                this.extendedZeroPaddedSize = this.getZeroPaddingSize(this.getExtendedImageSize(this.input, this.imageExtension), this.fftOptimization);
                outOfBoundsFactory = new OutOfBoundsMirrorExpWindowingFactory(this.relativeFadeOutDistance);
                break;
            }
            default: {
                if (this.inputSize == null) {
                    int[] tmp = new int[this.input.numDimensions()];
                    for (int d = 0; d < this.numDimensions; ++d) {
                        tmp[d] = (int)this.input.dimension(d);
                    }
                    this.extendedZeroPaddedSize = this.getZeroPaddingSize(tmp, this.fftOptimization);
                } else {
                    this.extendedZeroPaddedSize = this.getZeroPaddingSize(this.inputSize, this.fftOptimization);
                }
                outOfBoundsFactory = new OutOfBoundsConstantValueFactory(this.inputType.createVariable());
            }
        }
        this.originalOffset = new int[this.numDimensions];
        for (int d = 0; d < this.numDimensions; ++d) {
            if (this.inputSize != null) {
                this.inputSizeOffset[d] = (this.extendedZeroPaddedSize[d] - this.inputSize[d]) / 2;
            }
            this.originalOffset[d] = (this.extendedZeroPaddedSize[d] - (int)this.input.dimension(d)) / 2;
        }
        this.fftImage = FFTFunctions.computeFFT(this.input, this.imgFactory, this.complexType, outOfBoundsFactory, this.originalOffset, this.extendedZeroPaddedSize, this.getNumThreads(), false);
        if (this.fftImage == null) {
            this.errorMessage = "Could not compute the FFT transformation, most likely out of memory";
            return false;
        }
        if (this.rearrangement == Rearrangement.REARRANGE_QUADRANTS) {
            FFTFunctions.rearrangeFFTQuadrants(this.fftImage, true, this.getNumThreads());
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    protected int[] getExtendedImageSize(RandomAccessibleInterval<?> input, int[] imageExtension) {
        int[] extendedSize = new int[input.numDimensions()];
        for (int d = 0; d < input.numDimensions(); ++d) {
            extendedSize[d] = imageExtension[d] + (int)input.dimension(d);
        }
        return extendedSize;
    }

    protected int[] getZeroPaddingSize(int[] imageSize, FFTOptimization fftOptimization) {
        int[] fftSize = new int[imageSize.length];
        fftSize[0] = fftOptimization == FFTOptimization.SPEED ? FftReal.nfftFast((int)imageSize[0]) : FftReal.nfftSmall((int)imageSize[0]);
        for (int d = 1; d < fftSize.length; ++d) {
            fftSize[d] = fftOptimization == FFTOptimization.SPEED ? FftComplex.nfftFast((int)imageSize[d]) : FftComplex.nfftSmall((int)imageSize[d]);
        }
        return fftSize;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public Img<S> getResult() {
        return this.fftImage;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.input == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static enum FFTOptimization {
        SPEED,
        MEMORY;

    }

    public static enum Rearrangement {
        REARRANGE_QUADRANTS,
        UNCHANGED;

    }

    public static enum PreProcessing {
        NONE,
        EXTEND_MIRROR,
        EXTEND_MIRROR_FADING,
        USE_GIVEN_OUTOFBOUNDSSTRATEGY;

    }
}

