/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss3;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.ConvolverFactory;
import net.imglib2.algorithm.gauss3.ConvolverNativeType;
import net.imglib2.algorithm.gauss3.ConvolverNativeTypeBuffered;
import net.imglib2.algorithm.gauss3.ConvolverNumericType;
import net.imglib2.algorithm.gauss3.DoubleConvolverRealType;
import net.imglib2.algorithm.gauss3.DoubleConvolverRealTypeBuffered;
import net.imglib2.algorithm.gauss3.FloatConvolverRealType;
import net.imglib2.algorithm.gauss3.FloatConvolverRealTypeBuffered;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.list.ListImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Util;

public final class SeparableSymmetricConvolution {
    public static <S extends NumericType<S>, T extends NumericType<T>> void convolve(double[][] halfkernels, RandomAccessible<S> source, RandomAccessibleInterval<T> target, ExecutorService service) throws IncompatibleTypeException {
        NumericType targetType = (NumericType)Util.getTypeFromInterval(target);
        S sourceType = SeparableSymmetricConvolution.getType(source, target);
        if (targetType instanceof RealType) {
            if (!(sourceType instanceof RealType)) {
                throw new IncompatibleTypeException(sourceType, "RealType source required for convolving into a RealType target");
            }
            NumericType oTargetType = targetType;
            if (oTargetType instanceof DoubleType) {
                SeparableSymmetricConvolution.convolveRealTypeDouble(halfkernels, source, target, service);
            } else {
                SeparableSymmetricConvolution.convolveRealTypeFloat(halfkernels, source, target, service);
            }
        } else {
            if (!targetType.getClass().isInstance(sourceType)) {
                throw new IncompatibleTypeException(sourceType, targetType.getClass().getCanonicalName() + " source required for convolving into a " + targetType.getClass().getCanonicalName() + " target");
            }
            if (targetType instanceof NativeType) {
                SeparableSymmetricConvolution.convolveNativeType(halfkernels, source, target, service);
            } else {
                SeparableSymmetricConvolution.convolveNumericType(halfkernels, source, target, service);
            }
        }
    }

    private static <S extends RealType<S>, T extends RealType<T>> void convolveRealTypeFloat(double[][] halfkernels, RandomAccessible<S> source, RandomAccessibleInterval<T> target, ExecutorService service) {
        FloatType type = new FloatType();
        ImgFactory<FloatType> imgfac = SeparableSymmetricConvolution.getImgFactory(target, halfkernels, type);
        if (SeparableSymmetricConvolution.canUseBufferedConvolver(target, halfkernels)) {
            SeparableSymmetricConvolution.convolve(halfkernels, source, target, FloatConvolverRealTypeBuffered.factory(), FloatConvolverRealTypeBuffered.factory(), FloatConvolverRealTypeBuffered.factory(), FloatConvolverRealTypeBuffered.factory(), imgfac, service);
        } else {
            SeparableSymmetricConvolution.convolve(halfkernels, source, target, FloatConvolverRealType.factory(), FloatConvolverRealType.factory(), FloatConvolverRealType.factory(), FloatConvolverRealType.factory(), imgfac, service);
        }
    }

    private static <S extends RealType<S>, T extends RealType<T>> void convolveRealTypeDouble(double[][] halfkernels, RandomAccessible<S> source, RandomAccessibleInterval<T> target, ExecutorService service) {
        DoubleType type = new DoubleType();
        ImgFactory<DoubleType> imgfac = SeparableSymmetricConvolution.getImgFactory(target, halfkernels, type);
        if (SeparableSymmetricConvolution.canUseBufferedConvolver(target, halfkernels)) {
            SeparableSymmetricConvolution.convolve(halfkernels, source, target, DoubleConvolverRealTypeBuffered.factory(), DoubleConvolverRealTypeBuffered.factory(), DoubleConvolverRealTypeBuffered.factory(), DoubleConvolverRealTypeBuffered.factory(), imgfac, service);
        } else {
            SeparableSymmetricConvolution.convolve(halfkernels, source, target, DoubleConvolverRealType.factory(), DoubleConvolverRealType.factory(), DoubleConvolverRealType.factory(), DoubleConvolverRealType.factory(), imgfac, service);
        }
    }

    private static <T extends NumericType<T> & NativeType<T>> void convolveNativeType(double[][] halfkernels, RandomAccessible<T> source, RandomAccessibleInterval<T> target, ExecutorService service) {
        NumericType type = (NumericType)Util.getTypeFromInterval(target);
        ConvolverFactory convfac = SeparableSymmetricConvolution.canUseBufferedConvolver(target, halfkernels) ? ConvolverNativeTypeBuffered.factory(type) : ConvolverNativeType.factory(type);
        ImgFactory<NativeType> imgfac = SeparableSymmetricConvolution.getImgFactory(target, halfkernels, (NativeType)((Object)type));
        SeparableSymmetricConvolution.convolve(halfkernels, source, target, convfac, convfac, convfac, convfac, imgfac, service);
    }

    private static <T extends NumericType<T>> void convolveNumericType(double[][] halfkernels, RandomAccessible<T> source, RandomAccessibleInterval<T> target, ExecutorService service) {
        NumericType type = (NumericType)Util.getTypeFromInterval(target);
        ConvolverNumericType.ConvolverNumericTypeFactory<NumericType> convfac = ConvolverNumericType.factory(type);
        SeparableSymmetricConvolution.convolve(halfkernels, source, target, convfac, convfac, convfac, convfac, new ListImgFactory<NumericType>(type), service);
    }

    private static <T extends NumericType<T>> T getType(RandomAccessible<T> accessible, Interval interval) {
        RandomAccess<T> a = accessible.randomAccess();
        interval.min(a);
        return (T)((NumericType)a.get());
    }

    public static <S, T> void convolve1d(double[] halfkernel, RandomAccessible<S> source, RandomAccessibleInterval<T> target, ConvolverFactory<S, T> convolverFactoryST, ExecutorService service) {
        long[] sourceOffset = new long[]{1 - halfkernel.length};
        SeparableSymmetricConvolution.convolveOffset(halfkernel, source, sourceOffset, target, target, 0, convolverFactoryST, service, 1);
    }

    public static <S, I, T> void convolve(double[][] halfkernels, RandomAccessible<S> source, RandomAccessibleInterval<T> target, ConvolverFactory<S, I> convolverFactorySI, ConvolverFactory<I, I> convolverFactoryII, ConvolverFactory<I, T> convolverFactoryIT, ConvolverFactory<S, T> convolverFactoryST, ImgFactory<I> imgFactory, ExecutorService service) {
        int n = source.numDimensions();
        if (n == 1) {
            SeparableSymmetricConvolution.convolve1d(halfkernels[0], source, target, convolverFactoryST, service);
        } else {
            int numThreads = Runtime.getRuntime().availableProcessors();
            int numTasks = numThreads > 1 ? numThreads * 4 : 1;
            long[] sourceOffset = new long[n];
            long[] targetOffset = new long[n];
            target.min(sourceOffset);
            for (int d = 0; d < n; ++d) {
                targetOffset[d] = -sourceOffset[d];
                int n2 = d;
                sourceOffset[n2] = sourceOffset[n2] + (long)(1 - halfkernels[d].length);
            }
            long[][] tmpdims = SeparableSymmetricConvolution.getTempImageDimensions(target, halfkernels);
            Img<I> tmp1 = imgFactory.create(tmpdims[0]);
            if (n == 2) {
                SeparableSymmetricConvolution.convolveOffset(halfkernels[0], source, sourceOffset, tmp1, tmp1, 0, convolverFactorySI, service, numTasks);
                SeparableSymmetricConvolution.convolveOffset(halfkernels[1], tmp1, targetOffset, target, target, 1, convolverFactoryIT, service, numTasks);
            } else {
                Img<I> tmp2 = imgFactory.create(tmpdims[1]);
                long[] zeroOffset = new long[n];
                SeparableSymmetricConvolution.convolveOffset(halfkernels[0], source, sourceOffset, tmp1, new FinalInterval(tmpdims[0]), 0, convolverFactorySI, service, numTasks);
                for (int d = 1; d < n - 1; ++d) {
                    SeparableSymmetricConvolution.convolveOffset(halfkernels[d], tmp1, zeroOffset, tmp2, new FinalInterval(tmpdims[d]), d, convolverFactoryII, service, numTasks);
                    Img<I> tmp = tmp2;
                    tmp2 = tmp1;
                    tmp1 = tmp;
                }
                SeparableSymmetricConvolution.convolveOffset(halfkernels[n - 1], tmp1, targetOffset, target, target, n - 1, convolverFactoryIT, service, numTasks);
            }
        }
    }

    static <S, T> void convolveOffset(final double[] halfkernel, final RandomAccessible<S> source, long[] sourceOffset, final RandomAccessible<T> target, final Interval targetInterval, final int d, final ConvolverFactory<S, T> factory, ExecutorService service, int numTasks) {
        final int n = source.numDimensions();
        int k1 = halfkernel.length - 1;
        long tmp = 1L;
        for (int i = 0; i < n; ++i) {
            if (i == d) continue;
            tmp *= targetInterval.dimension(i);
        }
        long endIndex = tmp;
        long taskSize = tmp / (long)numTasks;
        final long[] min = new long[n];
        final long[] max = new long[n];
        final long[] dim = new long[n];
        targetInterval.min(min);
        targetInterval.max(max);
        targetInterval.dimensions(dim);
        dim[d] = 1L;
        final long[] srcmin = new long[n];
        final long[] srcmax = new long[n];
        for (int i = 0; i < n; ++i) {
            srcmin[i] = min[i] + sourceOffset[i];
            srcmax[i] = max[i] + sourceOffset[i];
        }
        int n2 = d;
        srcmax[n2] = srcmax[n2] + (long)(2 * k1);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (int taskNum = 0; taskNum < numTasks; ++taskNum) {
            final long l = (long)taskNum * taskSize;
            final long myEndIndex = taskNum == numTasks - 1 ? endIndex : l + taskSize;
            Callable<Void> r = new Callable<Void>(){

                @Override
                public Void call() {
                    RandomAccess in = source.randomAccess(new FinalInterval(srcmin, srcmax));
                    RandomAccess out = target.randomAccess(targetInterval);
                    Runnable convolver = factory.create(halfkernel, in, out, d, targetInterval.dimension(d));
                    out.setPosition(min);
                    in.setPosition(srcmin);
                    long[] moveToStart = new long[n];
                    IntervalIndexer.indexToPosition(l, dim, moveToStart);
                    out.move(moveToStart);
                    in.move(moveToStart);
                    block0: for (long index = l; index < myEndIndex; ++index) {
                        convolver.run();
                        out.setPosition(min[d], d);
                        in.setPosition(srcmin[d], d);
                        for (int i = 0; i < n; ++i) {
                            if (i == d) continue;
                            out.fwd(i);
                            if (out.getLongPosition(i) > max[i]) {
                                out.setPosition(min[i], i);
                                in.setPosition(srcmin[i], i);
                                continue;
                            }
                            in.fwd(i);
                            continue block0;
                        }
                    }
                    return null;
                }
            };
            futures.add(service.submit(r));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    static long[][] getTempImageDimensions(Dimensions targetsize, double[][] halfkernels) {
        int n = targetsize.numDimensions();
        long[][] tmpdims = new long[n][];
        tmpdims[n - 1] = new long[n];
        targetsize.dimensions(tmpdims[n - 1]);
        for (int d = n - 2; d >= 0; --d) {
            tmpdims[d] = (long[])tmpdims[d + 1].clone();
            long[] lArray = tmpdims[d];
            int n2 = d + 1;
            lArray[n2] = lArray[n2] + (long)(2 * halfkernels[d + 1].length - 2);
        }
        return tmpdims;
    }

    static boolean canUseBufferedConvolver(Dimensions targetsize, double[][] halfkernels) {
        int n = targetsize.numDimensions();
        for (int d = 0; d < n; ++d) {
            if (targetsize.dimension(d) + (long)(4 * halfkernels[d].length) - 4L <= Integer.MAX_VALUE) continue;
            return false;
        }
        return true;
    }

    static boolean canUseArrayImgFactory(Dimensions targetsize, double[][] halfkernels) {
        int n = targetsize.numDimensions();
        long size = targetsize.dimension(0);
        for (int d = 1; d < n; ++d) {
            size *= targetsize.dimension(d) + (long)(2 * halfkernels[d].length);
        }
        return size <= Integer.MAX_VALUE;
    }

    static <T extends NativeType<T>> ImgFactory<T> getImgFactory(Dimensions targetsize, double[][] halfkernels, T type) {
        if (SeparableSymmetricConvolution.canUseArrayImgFactory(targetsize, halfkernels)) {
            return new ArrayImgFactory<T>(type);
        }
        int cellSize = (int)Math.pow(2.147483647E9 / type.getEntitiesPerPixel().getRatio(), 1.0 / (double)targetsize.numDimensions());
        return new CellImgFactory<T>(type, cellSize);
    }

    @Deprecated
    public static <S, I, T> void convolve(double[][] halfkernels, RandomAccessible<S> source, RandomAccessibleInterval<T> target, ConvolverFactory<S, I> convolverFactorySI, ConvolverFactory<I, I> convolverFactoryII, ConvolverFactory<I, T> convolverFactoryIT, ConvolverFactory<S, T> convolverFactoryST, ImgFactory<I> imgFactory, I type, ExecutorService service) {
        SeparableSymmetricConvolution.convolve(halfkernels, source, target, convolverFactorySI, convolverFactoryII, convolverFactoryIT, convolverFactoryST, imgFactory.imgFactory(type), service);
    }
}

