/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.localization;

import java.util.Random;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.localization.EllipticGaussianOrtho;
import net.imglib2.algorithm.localization.Gaussian;
import net.imglib2.algorithm.localization.Observation;
import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhoodCursor;
import net.imglib2.algorithm.region.localneighborhood.RectangleCursor;
import net.imglib2.algorithm.region.localneighborhood.RectangleNeighborhoodGPL;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class LocalizationUtils {
    private static final EllipticGaussianOrtho ellipticGaussian = new EllipticGaussianOrtho();
    private static final Gaussian gaussian = new Gaussian();
    private static final Random ran = new Random();

    public static final <T extends RealType<T>> void addEllipticGaussianSpotToImage(RandomAccessibleInterval<T> img, double[] params) {
        IterableInterval<T> iterImg = Views.iterable(img);
        RealCursor lc = iterImg.localizingCursor();
        double[] position = new double[img.numDimensions()];
        RealType var = (RealType)((RealType)iterImg.firstElement()).createVariable();
        while (lc.hasNext()) {
            lc.fwd();
            position[0] = lc.getDoublePosition(0);
            position[1] = lc.getDoublePosition(1);
            double val = ellipticGaussian.val(position, params);
            var.setReal(val);
            ((RealType)lc.get()).add(var);
        }
    }

    public static final <T extends RealType<T>> void addGaussianSpotToImage(RandomAccessibleInterval<T> img, double[] params) {
        IterableInterval<T> iterImg = Views.iterable(img);
        RealCursor lc = iterImg.localizingCursor();
        int nDims = img.numDimensions();
        double[] position = new double[nDims];
        RealType var = (RealType)((RealType)iterImg.firstElement()).createVariable();
        while (lc.hasNext()) {
            lc.fwd();
            lc.localize(position);
            double val = gaussian.val(position, params);
            var.setReal(val);
            ((RealType)lc.get()).add(var);
        }
    }

    public static final <T extends RealType<T>> void addGaussianNoiseToImage(RandomAccessibleInterval<T> img, double sigma_noise) {
        IterableInterval<T> iterImg = Views.iterable(img);
        RealCursor lc = iterImg.localizingCursor();
        RealType var = (RealType)((RealType)iterImg.firstElement()).createVariable();
        while (lc.hasNext()) {
            lc.fwd();
            double val = Math.max(0.0, sigma_noise * ran.nextGaussian());
            var.setReal(val);
            ((RealType)lc.get()).add(var);
        }
    }

    public static final <T extends RealType<T>> Observation gatherObservationData(RandomAccessibleInterval<T> image, Localizable point, long[] span) {
        int ndims = image.numDimensions();
        RectangleNeighborhoodGPL<T> neighborhood = new RectangleNeighborhoodGPL<T>(image);
        neighborhood.setSpan(span);
        neighborhood.setPosition(point);
        int n_pixels = (int)neighborhood.size();
        double[] tmp_I = new double[n_pixels];
        double[][] tmp_X = new double[n_pixels][ndims];
        Cursor cursor = neighborhood.localizingCursor();
        long[] pos = new long[image.numDimensions()];
        int index = 0;
        while (((RectangleCursor)cursor).hasNext()) {
            ((RectangleCursor)cursor).fwd();
            ((AbstractNeighborhoodCursor)cursor).localize(pos);
            if (((AbstractNeighborhoodCursor)cursor).isOutOfBounds()) continue;
            for (int i = 0; i < ndims; ++i) {
                tmp_X[index][i] = pos[i];
            }
            tmp_I[index] = ((RealType)((AbstractNeighborhoodCursor)cursor).get()).getRealDouble();
            ++index;
        }
        double[][] X = null;
        double[] I = null;
        if (index == n_pixels) {
            X = tmp_X;
            I = tmp_I;
        } else {
            X = new double[index][ndims];
            I = new double[index];
            System.arraycopy(tmp_X, 0, X, 0, index);
            System.arraycopy(tmp_I, 0, I, 0, index);
        }
        Observation obs = new Observation();
        obs.I = I;
        obs.X = X;
        return obs;
    }
}

