/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.localization;

import net.imglib2.Localizable;
import net.imglib2.algorithm.localization.Observation;
import net.imglib2.algorithm.localization.StartPointEstimator;

public class MLGaussianEstimator
implements StartPointEstimator {
    private final double sigma;
    private final int nDims;
    private final long[] span;

    public MLGaussianEstimator(double typicalSigma, int nDims) {
        this.sigma = typicalSigma;
        this.nDims = nDims;
        this.span = new long[nDims];
        for (int i = 0; i < nDims; ++i) {
            this.span[i] = (long)Math.ceil(2.0 * this.sigma) + 1L;
        }
    }

    public String toString() {
        return "Maximum-likelihood estimator for symetric gaussian peaks";
    }

    @Override
    public long[] getDomainSpan() {
        return this.span;
    }

    @Override
    public double[] initializeFit(Localizable point, Observation data) {
        double[] start_param = new double[this.nDims + 2];
        double[][] X = data.X;
        double[] I = data.I;
        double[] X_sum = new double[this.nDims];
        for (int j = 0; j < this.nDims; ++j) {
            X_sum[j] = 0.0;
            for (int i = 0; i < X.length; ++i) {
                int n = j;
                X_sum[n] = X_sum[n] + X[i][j] * I[i];
            }
        }
        double I_sum = 0.0;
        double max_I = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < X.length; ++i) {
            I_sum += I[i];
            if (!(I[i] > max_I)) continue;
            max_I = I[i];
        }
        start_param[this.nDims] = max_I;
        for (int j = 0; j < this.nDims; ++j) {
            start_param[j] = X_sum[j] / I_sum;
        }
        double[] bs = new double[this.nDims];
        for (int j = 0; j < this.nDims; ++j) {
            double C2 = 0.0;
            for (int i = 0; i < X.length; ++i) {
                double dx = X[i][j] - start_param[j];
                C2 += I[i] * dx * dx;
            }
            bs[j] = 1.0 / (C2 /= I_sum) / 2.0;
        }
        double mb = bs[0];
        for (int j = 1; j < bs.length; ++j) {
            mb += bs[j];
        }
        start_param[this.nDims + 1] = mb /= (double)bs.length;
        return start_param;
    }
}

