/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import java.lang.reflect.Array;
import java.util.Arrays;
import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhoodCursor;
import net.imglib2.algorithm.region.localneighborhood.BufferedRectangularNeighborhood;
import net.imglib2.type.Type;

public class BufferedRectangularNeighborhoodCursor<T extends Type<T>>
extends AbstractNeighborhoodCursor<T> {
    private final long[] bufferElements;
    private final long[] min;
    private final long[] max;
    private final long[] bck;
    private final long[] currentPos;
    private final T[] buffer;
    private final int maxCount;
    private int bufferOffset;
    private int activeDim;
    private int bufferPtr;
    private int count;
    private final int n;

    public BufferedRectangularNeighborhoodCursor(BufferedRectangularNeighborhood<T> neighborhood) {
        super(neighborhood);
        this.n = neighborhood.numDimensions();
        this.currentPos = (long[])neighborhood.center.clone();
        this.max = new long[this.n];
        this.min = new long[this.n];
        this.bufferElements = new long[this.n];
        this.bck = new long[this.n];
        Arrays.fill(this.bufferElements, 1L);
        int tmp = 1;
        for (int d = 0; d < neighborhood.span.length; ++d) {
            tmp = (int)((long)tmp * (neighborhood.span[d] * 2L + 1L));
            this.bck[d] = -2L * neighborhood.span[d];
            for (int dd = 0; dd < this.n; ++dd) {
                if (dd == d) continue;
                int n = d;
                this.bufferElements[n] = this.bufferElements[n] * (neighborhood.span[d] * 2L + 1L);
            }
        }
        Object type = ((Type)this.ra.get()).createVariable();
        this.maxCount = tmp;
        this.buffer = (Type[])Array.newInstance(type.getClass(), this.maxCount);
        for (int t = 0; t < this.buffer.length; ++t) {
            this.buffer[t] = type.copy();
        }
    }

    protected BufferedRectangularNeighborhoodCursor(BufferedRectangularNeighborhoodCursor<T> c) {
        this((BufferedRectangularNeighborhood)c.neighborhood);
    }

    @Override
    public T get() {
        return this.buffer[this.bufferPtr];
    }

    @Override
    public T next() {
        this.fwd();
        return this.buffer[this.bufferPtr];
    }

    @Override
    public void fwd() {
        if (++this.bufferPtr >= this.buffer.length) {
            this.bufferPtr = 0;
        }
        if (this.activeDim < 0 || (long)this.count >= (long)this.buffer.length - this.bufferElements[this.activeDim]) {
            for (int d = this.n - 1; d > -1; --d) {
                if (d == this.activeDim) continue;
                if (this.ra.getLongPosition(d) < this.max[d]) {
                    this.ra.fwd(d);
                    break;
                }
                this.ra.move(this.bck[d], d);
            }
            this.buffer[this.bufferPtr].set((Type)((Type)this.ra.get()));
        }
        ++this.count;
    }

    @Override
    public void reset() {
        int d;
        this.activeDim = -1;
        for (d = 0; d < this.neighborhood.center.length; ++d) {
            long tmp = this.currentPos[d];
            this.currentPos[d] = this.neighborhood.center[d];
            this.min[d] = this.neighborhood.center[d] - this.neighborhood.span[d];
            this.max[d] = this.neighborhood.center[d] + this.neighborhood.span[d];
            if (this.neighborhood.center[d] - tmp == 0L) continue;
            if (this.activeDim != -1) {
                this.activeDim = -1;
                break;
            }
            this.activeDim = d;
        }
        this.bufferOffset = this.activeDim >= 0 && (long)this.bufferOffset + this.bufferElements[this.activeDim] < (long)this.buffer.length ? (int)((long)this.bufferOffset + this.bufferElements[this.activeDim]) : 0;
        this.bufferPtr = this.bufferOffset - 1;
        for (d = 0; d < this.n; ++d) {
            if (d == this.activeDim) {
                this.ra.setPosition(this.max[d], d);
                continue;
            }
            this.ra.setPosition(this.min[d], d);
        }
        this.ra.bck(this.ra.numDimensions() - 1);
        this.count = 0;
    }

    @Override
    public boolean hasNext() {
        return this.count < this.maxCount;
    }

    @Override
    public float getFloatPosition(int d) {
        return this.ra.getFloatPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.ra.getDoublePosition(d);
    }

    @Override
    public int getIntPosition(int d) {
        return this.ra.getIntPosition(d);
    }

    @Override
    public long getLongPosition(int d) {
        return this.ra.getLongPosition(d);
    }

    @Override
    public void localize(long[] position) {
        this.ra.localize(position);
    }

    @Override
    public void localize(float[] position) {
        this.ra.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.ra.localize(position);
    }

    @Override
    public void localize(int[] position) {
        this.ra.localize(position);
    }

    @Override
    public BufferedRectangularNeighborhoodCursor<T> copy() {
        return new BufferedRectangularNeighborhoodCursor<T>(this);
    }

    @Override
    public BufferedRectangularNeighborhoodCursor<T> copyCursor() {
        return this.copy();
    }
}

